/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.dao;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.FunctionWork;
import com.centit.framework.hibernate.dao.ProcedureWork;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.SessionImpl;
import org.hibernate.jdbc.Work;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

public abstract class DatabaseOptUtils {
    protected static Logger logger = LoggerFactory.getLogger(DatabaseOptUtils.class);

    private DatabaseOptUtils() {
    }

    public static final int saveBatchObjects(BaseDaoImpl<?, ?> baseDao, Collection<? extends Object> objects) {
        int i = 0;
        try {
            for (Object object : objects) {
                if (object != null) {
                    baseDao.getCurrentSession().saveOrUpdate(object);
                    ++i;
                }
                if (0 != i % 20) continue;
                DatabaseOptUtils.flush(baseDao.getCurrentSession());
            }
        }
        catch (DataAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return i;
    }

    public static final int mergeBatchObjects(BaseDaoImpl<?, ?> baseDao, Collection<? extends Object> objects) {
        int i = 0;
        try {
            for (Object object : objects) {
                if (object != null) {
                    baseDao.getCurrentSession().merge(object);
                    ++i;
                }
                if (0 != i % 20) continue;
                DatabaseOptUtils.flush(baseDao.getCurrentSession());
            }
        }
        catch (DataAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return i;
    }

    public static final int deleteBatchObject(BaseDaoImpl<?, ?> baseDao, Collection<? extends Object> objects) {
        int i = 0;
        try {
            for (Object object : objects) {
                if (object != null) {
                    baseDao.getCurrentSession().delete(object);
                    ++i;
                }
                if (0 != i % 20) continue;
                DatabaseOptUtils.flush(baseDao.getCurrentSession());
            }
        }
        catch (DataAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return i;
    }

    public static final int doExecuteHql(BaseDaoImpl<?, ?> baseDao, String shql) {
        return baseDao.getCurrentSession().createQuery(shql).executeUpdate();
    }

    public static final int doExecuteHql(BaseDaoImpl<?, ?> baseDao, String shql, Object value) {
        Query q = baseDao.getCurrentSession().createQuery(shql);
        DatabaseOptUtils.setQueryParameter(q, new Object[]{value});
        return q.executeUpdate();
    }

    public static final int doExecuteHql(BaseDaoImpl<?, ?> baseDao, String shql, Object[] values) {
        Query q = baseDao.getCurrentSession().createQuery(shql);
        DatabaseOptUtils.setQueryParameter(q, values);
        return q.executeUpdate();
    }

    public static final int doExecuteSql(BaseDaoImpl<?, ?> baseDao, String sSql) {
        NativeQuery q = baseDao.getCurrentSession().createNativeQuery(sSql);
        return q.executeUpdate();
    }

    public static final int doExecuteSql(BaseDaoImpl<?, ?> baseDao, String sSql, Object[] values) {
        NativeQuery q = baseDao.getCurrentSession().createNativeQuery(sSql);
        DatabaseOptUtils.setQueryParameter((Query)q, values);
        return q.executeUpdate();
    }

    public static final void setQueryParameters(Query q, Map<String, Object> values) {
        if (values != null) {
            for (String sParam : q.getParameterMetadata().getNamedParameterNames()) {
                Object value = values.get(sParam);
                if (value == null) {
                    q.setParameter(sParam, null);
                    continue;
                }
                if (value instanceof Collection) {
                    q.setParameterList(sParam, (Collection)value);
                    continue;
                }
                if (value instanceof Object[]) {
                    q.setParameterList(sParam, (Object[])value);
                    continue;
                }
                q.setParameter(sParam, value);
            }
        }
    }

    public static final int doExecuteHql(BaseDaoImpl<?, ?> baseDao, String sSql, Map<String, Object> values) {
        Query q = baseDao.getCurrentSession().createQuery(sSql);
        DatabaseOptUtils.setQueryParameters(q, values);
        return q.executeUpdate();
    }

    public static final int doExecuteSql(BaseDaoImpl<?, ?> baseDao, String sSql, Map<String, Object> values) {
        NativeQuery q = baseDao.getCurrentSession().createNativeQuery(sSql);
        DatabaseOptUtils.setQueryParameters((Query)q, values);
        return q.executeUpdate();
    }

    public final String getNextKeyByMaxInteger(BaseDaoImpl<?, ?> baseDao, String fieldName, String sObjectName) {
        try {
            Query q = baseDao.getCurrentSession().createQuery("SELECT MAX(cast(" + fieldName + " as int)) FROM " + sObjectName);
            return String.valueOf(Integer.valueOf(q.list().get(0).toString()) + 1);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "0";
        }
    }

    public static final String getNextKeyByHqlStrOfMax(BaseDaoImpl<?, ?> baseDao, String fieldName, String sObjectName, int codeLen) {
        Query q = baseDao.getCurrentSession().createQuery("SELECT MAX(" + fieldName + ")  FROM " + sObjectName);
        return StringBaseOpt.nextCode((String)StringBaseOpt.fillZeroForString((String)StringBaseOpt.objectToString(q.list().get(0)), (int)codeLen));
    }

    public static final String getNextKeyByHqlStrOfMax(BaseDaoImpl<?, ?> baseDao, String fieldName, String sObjectName) {
        return DatabaseOptUtils.getNextKeyByHqlStrOfMax(baseDao, fieldName, sObjectName, 0);
    }

    public static final String getCurrValueOfSequence(BaseDaoImpl<?, ?> baseDao, String sequenceName) {
        Long seq = DatabaseOptUtils.getNextLongSequence(baseDao, sequenceName);
        if (seq == null) {
            return null;
        }
        return seq.toString();
    }

    public static final String getNextKeyBySequence(BaseDaoImpl<?, ?> baseDao, String sequenceName, int codeLen) {
        String sKey = DatabaseOptUtils.getNextValueOfSequence(baseDao, sequenceName);
        if (codeLen > 0) {
            sKey = StringBaseOpt.fillZeroForString((String)sKey, (int)codeLen);
        }
        return sKey;
    }

    public static Long getSequenceNextValueUseTable(BaseDaoImpl<?, ?> baseDao, String sequenceName) throws SQLException, IOException {
        Object object = DatabaseOptUtils.getSingleObjectBySql(baseDao, "SELECT count(1) hasValue from sequence_table  where sequence_Name = ?", new Object[]{sequenceName});
        Long l = NumberBaseOpt.castObjectToLong((Object)object);
        if (l == 0L) {
            DatabaseOptUtils.getSingleObjectBySql(baseDao, "insert into sequence_table(sequence_Name,current_value) values(?,?)", new Object[]{sequenceName, 1});
            return 1L;
        }
        DatabaseOptUtils.getSingleObjectBySql(baseDao, "update sequence_table current_value = current_value + 1 where sequence_Name= ?", new Object[]{sequenceName});
        object = DatabaseOptUtils.getSingleObjectBySql(baseDao, "SELECT current_value from sequence_table  where sequence_Name = ?", new Object[]{sequenceName});
        return NumberBaseOpt.castObjectToLong((Object)object);
    }

    public static final Long getNextLongSequence(BaseDaoImpl<?, ?> baseDao, String sequenceName) {
        String dn = ((JdbcServices)((SessionImpl)baseDao.getCurrentSession()).getFactory().getServiceRegistry().getService(JdbcServices.class)).getDialect().getClass().getName();
        if (dn.indexOf("Oracle") >= 0) {
            return NumberBaseOpt.castObjectToLong((Object)DatabaseOptUtils.getSingleObjectBySql(baseDao, "SELECT " + sequenceName + ".nextval from dual"));
        }
        if (dn.indexOf("DB2") >= 0) {
            return NumberBaseOpt.castObjectToLong((Object)DatabaseOptUtils.getSingleObjectBySql(baseDao, "SELECT nextval for " + sequenceName + " from sysibm.sysdummy1"));
        }
        if (dn.indexOf("MySQL") >= 0) {
            return Long.valueOf(DatabaseOptUtils.getSingleObjectBySql(baseDao, "SELECT sequence_nextval ('" + sequenceName + "');").toString());
        }
        try {
            return DatabaseOptUtils.getSequenceNextValueUseTable(baseDao, sequenceName);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static final String getNextValueOfSequence(BaseDaoImpl<?, ?> baseDao, String sequenceName) {
        Long sequence = DatabaseOptUtils.getNextLongSequence(baseDao, sequenceName);
        if (null == sequence) {
            return "";
        }
        return String.valueOf(sequence);
    }

    public static final Object getSingleObjectByHql(BaseDaoImpl<?, ?> baseDao, String sHql) {
        Query queryObject = baseDao.getCurrentSession().createQuery(sHql);
        return queryObject.uniqueResult();
    }

    public static final Object getSingleObjectByHql(BaseDaoImpl<?, ?> baseDao, String sHql, Object paramObject) {
        Query queryObject = baseDao.getCurrentSession().createQuery(sHql);
        DatabaseOptUtils.setQueryParameter(queryObject, new Object[]{paramObject});
        return queryObject.uniqueResult();
    }

    public static final Object getSingleObjectByHql(BaseDaoImpl<?, ?> baseDao, String sHql, Object[] paramObjects) {
        Query queryObject = baseDao.getCurrentSession().createQuery(sHql);
        DatabaseOptUtils.setQueryParameter(queryObject, paramObjects);
        return queryObject.uniqueResult();
    }

    public static final Object getSingleObjectByHql(BaseDaoImpl<?, ?> baseDao, String sHql, String paramName, Object paramObject) {
        Query queryObject = baseDao.getCurrentSession().createQuery(sHql);
        queryObject.setParameter(paramName, paramObject);
        return queryObject.uniqueResult();
    }

    public static final Object getSingleObjectByHql(BaseDaoImpl<?, ?> baseDao, String sHql, Map<String, Object> paramObjects) {
        Query queryObject = baseDao.getCurrentSession().createQuery(sHql);
        DatabaseOptUtils.setQueryParameters(queryObject, paramObjects);
        return queryObject.uniqueResult();
    }

    public static final Object getSingleObjectBySql(BaseDaoImpl<?, ?> baseDao, String sSql) {
        NativeQuery queryObject = baseDao.getCurrentSession().createNativeQuery(sSql);
        return queryObject.uniqueResult();
    }

    public static final Object getSingleObjectBySql(BaseDaoImpl<?, ?> baseDao, String sSql, Object paramObject) {
        NativeQuery queryObject = baseDao.getCurrentSession().createNativeQuery(sSql);
        DatabaseOptUtils.setQueryParameter((Query)queryObject, new Object[]{paramObject});
        return queryObject.uniqueResult();
    }

    public static final Object getSingleObjectBySql(BaseDaoImpl<?, ?> baseDao, String sSql, Object[] paramObjects) {
        NativeQuery queryObject = baseDao.getCurrentSession().createNativeQuery(sSql);
        DatabaseOptUtils.setQueryParameter((Query)queryObject, paramObjects);
        return queryObject.uniqueResult();
    }

    public static final Object getSingleObjectBySql(BaseDaoImpl<?, ?> baseDao, String sSql, String paramName, Object paramObject) {
        NativeQuery queryObject = baseDao.getCurrentSession().createNativeQuery(sSql);
        queryObject.setParameter(paramName, paramObject);
        return queryObject.uniqueResult();
    }

    public static final Object getSingleObjectBySql(BaseDaoImpl<?, ?> baseDao, String sSql, Map<String, Object> paramObjects) {
        NativeQuery queryObject = baseDao.getCurrentSession().createNativeQuery(sSql);
        DatabaseOptUtils.setQueryParameters((Query)queryObject, paramObjects);
        return queryObject.uniqueResult();
    }

    public static final long getSingleIntByHql(BaseDaoImpl<?, ?> baseDao, String sHql, Object paramObject) {
        Object obj = DatabaseOptUtils.getSingleObjectByHql(baseDao, sHql, paramObject);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            return Long.valueOf(obj.toString());
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        return 0L;
    }

    public static final long getSingleIntByHql(BaseDaoImpl<?, ?> baseDao, String hql) {
        Query queryObject = baseDao.getCurrentSession().createQuery(hql);
        Object obj = queryObject.uniqueResult();
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            return Long.valueOf(obj.toString());
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        if (obj instanceof BigInteger) {
            return ((BigInteger)obj).longValue();
        }
        return 0L;
    }

    public static final long getSingleIntBySql(BaseDaoImpl<?, ?> baseDao, String sSql) {
        NativeQuery queryObject = baseDao.getCurrentSession().createNativeQuery(sSql);
        Object obj = queryObject.uniqueResult();
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            return Long.valueOf(obj.toString());
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        return 0L;
    }

    public static final long getSingleIntBySql(BaseDaoImpl<?, ?> baseDao, String sSql, Object paramObject) {
        Object obj = DatabaseOptUtils.getSingleObjectBySql(baseDao, sSql, paramObject);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            return Long.valueOf(obj.toString());
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        return 0L;
    }

    public static final String getSingleStringByHql(BaseDaoImpl<?, ?> baseDao, String hql) {
        Query queryObject = baseDao.getCurrentSession().createQuery(hql);
        Object obj = queryObject.uniqueResult();
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    public static final String getSingleStringBySql(BaseDaoImpl<?, ?> baseDao, String sSql) {
        NativeQuery queryObject = baseDao.getCurrentSession().createNativeQuery(sSql);
        Object obj = queryObject.uniqueResult();
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    public static final boolean callProcedure(BaseDaoImpl<?, ?> baseDao, String procName, Object ... paramObjs) {
        ProcedureWork pwork = new ProcedureWork(procName, paramObjs);
        baseDao.getCurrentSession().doWork((Work)pwork);
        return pwork.hasBeSucceedExecuted();
    }

    public static final ResultSet callProcedureOutRS(Connection conn, String procName, Object ... paramObjs) throws SQLException {
        int n = paramObjs.length;
        StringBuilder procDesc = new StringBuilder("{call ");
        procDesc.append(procName).append("(");
        for (int i = 1; i < n; ++i) {
            procDesc.append("?,");
        }
        procDesc.append("?)}");
        try (CallableStatement stmt = conn.prepareCall(procDesc.toString());){
            DatabaseAccess.setQueryStmtParameters((PreparedStatement)stmt, (Object[])paramObjs);
            stmt.registerOutParameter(n + 1, -10);
            stmt.execute();
            ResultSet resultSet = (ResultSet)stmt.getObject(n + 1);
            return resultSet;
        }
    }

    public static final ResultSet callProcedureOutRS(BaseDaoImpl<?, ?> baseDao, String procName, Object ... paramObjs) {
        ProcedureWork pwork = new ProcedureWork(procName, paramObjs);
        pwork.setOracleProcedureWithReturnCursor(true);
        baseDao.getCurrentSession().doWork((Work)pwork);
        return pwork.getRetrunResultSet();
    }

    public static final Object callFunction(BaseDaoImpl<?, ?> baseDao, String procName, int resultType, Object ... paramObjs) {
        FunctionWork pwork = new FunctionWork(procName, resultType, paramObjs);
        baseDao.getCurrentSession().doWork((Work)pwork);
        return pwork.getRetrunObject();
    }

    public static final List<?> findObjectsByHql(BaseDaoImpl<?, ?> baseDao, String shql, Object[] values, PageDesc pageDesc) {
        List l;
        int startPos = -1;
        int maxSize = 0;
        if (pageDesc != null) {
            startPos = pageDesc.getRowStart();
            maxSize = pageDesc.getPageSize();
        }
        Query q = baseDao.getCurrentSession().createQuery(shql);
        DatabaseOptUtils.setQueryParameter(q, values);
        if (maxSize > 0) {
            q.setMaxResults(maxSize);
        }
        if (startPos >= 0) {
            q.setFirstResult(startPos);
        }
        if ((l = q.list()) != null && pageDesc != null) {
            if (maxSize > 0) {
                q = baseDao.getCurrentSession().createQuery(QueryUtils.buildGetCountHQL((String)shql));
                DatabaseOptUtils.setQueryParameter(q, values);
                pageDesc.setTotalRows(Integer.valueOf(q.list().get(0).toString()));
            } else {
                pageDesc.setTotalRows(l.size());
            }
        }
        return l;
    }

    public static final List<?> findObjectsByHql(BaseDaoImpl<?, ?> baseDao, String shql, Map<String, Object> values, PageDesc pageDesc) {
        List l;
        int startPos = 0;
        int maxSize = 0;
        if (pageDesc != null) {
            startPos = pageDesc.getRowStart();
            maxSize = pageDesc.getPageSize();
        }
        Query q = baseDao.getCurrentSession().createQuery(shql);
        DatabaseOptUtils.setQueryParameters(q, values);
        if (maxSize > 0) {
            q.setMaxResults(maxSize);
        }
        if (startPos >= 0) {
            q.setFirstResult(startPos);
        }
        if ((l = q.list()) != null && pageDesc != null) {
            if (maxSize > 0) {
                q = baseDao.getCurrentSession().createQuery(QueryUtils.buildGetCountHQL((String)shql));
                DatabaseOptUtils.setQueryParameters(q, values);
                pageDesc.setTotalRows(Integer.valueOf(q.list().get(0).toString()));
            } else {
                pageDesc.setTotalRows(l.size());
            }
        }
        return l;
    }

    public static final List<?> findObjectsByHql(BaseDaoImpl<?, ?> baseDao, String shql, Map<String, Object> values) {
        return DatabaseOptUtils.findObjectsByHql(baseDao, shql, values, null);
    }

    public static final List<?> findObjectsByHql(BaseDaoImpl<?, ?> baseDao, String shql, Object[] values) {
        return DatabaseOptUtils.findObjectsByHql(baseDao, shql, values, new PageDesc(-1, -1));
    }

    public static final List<?> findObjectsByHql(BaseDaoImpl<?, ?> baseDao, String shql) {
        try {
            return baseDao.getCurrentSession().createQuery(shql).list();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static final List<?> findObjectsBySql(BaseDaoImpl<?, ?> baseDao, String ssql) {
        try {
            return baseDao.getCurrentSession().createNativeQuery(ssql).list();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static final List<?> findObjectsBySql(BaseDaoImpl<?, ?> baseDao, String ssql, Object[] values) {
        return DatabaseOptUtils.findObjectsBySql(baseDao, ssql, values, new PageDesc(-1, -1), null);
    }

    public static final <T> List<T> findObjectsBySql(BaseDaoImpl<?, ?> baseDao, String ssql, Class<T> objectType) {
        try {
            NativeQuery q = baseDao.getCurrentSession().createNativeQuery(ssql);
            q.addEntity(objectType);
            return q.list();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static final void setQueryParameter(Query query, Object[] values) {
        if (values != null) {
            int basePostion = query.getParameterMetadata().isOrdinalParametersZeroBased() ? 0 : 1;
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(basePostion + i, values[i]);
            }
        }
    }

    public static final <T> List<T> findObjectsBySql(BaseDaoImpl<?, ?> baseDao, String ssql, Object[] values, PageDesc pageDesc, Class<T> objectType) {
        List l;
        int startPos = 0;
        int maxSize = 0;
        if (pageDesc != null) {
            startPos = pageDesc.getRowStart();
            maxSize = pageDesc.getPageSize();
        }
        NativeQuery q = baseDao.getCurrentSession().createNativeQuery(ssql);
        DatabaseOptUtils.setQueryParameter((Query)q, values);
        if (maxSize > 0) {
            q.setMaxResults(maxSize);
        }
        if (startPos >= 0) {
            q.setFirstResult(startPos);
        }
        if (objectType != null) {
            q.addEntity(objectType);
        }
        if ((l = q.list()) != null && pageDesc != null) {
            if (maxSize > 0) {
                q = baseDao.getCurrentSession().createNativeQuery(QueryUtils.buildGetCountSQL((String)ssql));
                DatabaseOptUtils.setQueryParameter((Query)q, values);
                pageDesc.setTotalRows(Integer.valueOf(q.list().get(0).toString()));
            } else {
                pageDesc.setTotalRows(l.size());
            }
        }
        return l;
    }

    public static final int getHqlReturnObjectCounts(BaseDaoImpl<?, ?> baseDao, String shql, Object[] values) {
        Query q = baseDao.getCurrentSession().createQuery(QueryUtils.buildGetCountHQL((String)shql));
        DatabaseOptUtils.setQueryParameter(q, values);
        return Integer.valueOf(q.list().get(0).toString());
    }

    public static final int getHqlReturnObjectCounts(BaseDaoImpl<?, ?> baseDao, String shql, Map<String, Object> values) {
        Query q = baseDao.getCurrentSession().createQuery(QueryUtils.buildGetCountHQL((String)shql));
        DatabaseOptUtils.setQueryParameters(q, values);
        return Integer.valueOf(q.list().get(0).toString());
    }

    public static final int getSqlReturnObjectCounts(BaseDaoImpl<?, ?> baseDao, String ssql, Object[] values) {
        NativeQuery q = baseDao.getCurrentSession().createNativeQuery(QueryUtils.buildGetCountSQL((String)ssql));
        DatabaseOptUtils.setQueryParameter((Query)q, values);
        return Integer.valueOf(q.list().get(0).toString());
    }

    public static final int getSqlReturnObjectCounts(BaseDaoImpl<?, ?> baseDao, String sSql, Map<String, Object> values) {
        NativeQuery q = baseDao.getCurrentSession().createNativeQuery(QueryUtils.buildGetCountSQL((String)sSql));
        DatabaseOptUtils.setQueryParameters((Query)q, values);
        return Integer.valueOf(q.list().get(0).toString());
    }

    public static final <T> List<T> findObjectsBySql(BaseDaoImpl<?, ?> baseDao, String ssql, Map<String, Object> values, PageDesc pageDesc, Class<T> objectType) {
        List l;
        int startPos = 0;
        int maxSize = 0;
        if (pageDesc != null) {
            startPos = pageDesc.getRowStart();
            maxSize = pageDesc.getPageSize();
        }
        NativeQuery q = baseDao.getCurrentSession().createNativeQuery(ssql);
        DatabaseOptUtils.setQueryParameters((Query)q, values);
        if (maxSize > 0) {
            q.setMaxResults(maxSize);
        }
        if (startPos >= 0) {
            q.setFirstResult(startPos);
        }
        if (objectType != null) {
            q.addEntity(objectType);
        }
        if ((l = q.list()) != null && pageDesc != null) {
            if (maxSize > 0) {
                q = baseDao.getCurrentSession().createNativeQuery(QueryUtils.buildGetCountSQL((String)ssql));
                DatabaseOptUtils.setQueryParameters((Query)q, values);
                pageDesc.setTotalRows(Integer.valueOf(q.list().get(0).toString()));
            } else {
                pageDesc.setTotalRows(l.size());
            }
        }
        return l;
    }

    public static final List<?> findObjectsBySql(BaseDaoImpl<?, ?> baseDao, String ssql, Map<String, Object> values, PageDesc pageDesc) {
        return DatabaseOptUtils.findObjectsBySql(baseDao, ssql, values, pageDesc, null);
    }

    public static final List<?> findObjectsBySql(BaseDaoImpl<?, ?> baseDao, String shql, Map<String, Object> values) {
        return DatabaseOptUtils.findObjectsBySql(baseDao, shql, values, new PageDesc(-1, -1), null);
    }

    public static final <T> List<T> findObjectsBySql(BaseDaoImpl<?, ?> baseDao, String ssql, Object[] values, Class<T> objectType) {
        return DatabaseOptUtils.findObjectsBySql(baseDao, ssql, values, new PageDesc(-1, -1), objectType);
    }

    public static final List<?> findObjectsBySql(BaseDaoImpl<?, ?> baseDao, String ssql, Object[] values, PageDesc pageDesc) {
        return DatabaseOptUtils.findObjectsBySql(baseDao, ssql, values, pageDesc, null);
    }

    public static final JSONArray findObjectsAsJSONByHql(BaseDaoImpl<?, ?> baseDao, String shql, String[] fieldnames, Object[] values, PageDesc pageDesc) {
        List<?> dataList = DatabaseOptUtils.findObjectsByHql(baseDao, shql, values, pageDesc);
        if (dataList == null || dataList.size() == 0) {
            return null;
        }
        String[] fieldNames = fieldnames;
        if (fieldNames == null) {
            List fields = QueryUtils.getSqlFiledNames((String)shql);
            if (fields == null || fields.size() < 1) {
                return null;
            }
            fieldNames = fields.toArray(new String[fields.size()]);
        }
        JSONArray ja = new JSONArray();
        for (int j = 0; j < dataList.size(); ++j) {
            JSONObject jo = new JSONObject();
            for (int i = 0; i < fieldNames.length; ++i) {
                Object obj = DatabaseAccess.fetchLobField((Object)((Object[])dataList.get(j))[i], (boolean)false);
                jo.put(fieldNames[i], obj);
            }
            ja.add((Object)jo);
        }
        return ja;
    }

    public static final JSONArray findObjectsAsJSONByHql(BaseDaoImpl<?, ?> baseDao, String shql, String[] fieldnames, Map<String, Object> values, PageDesc pageDesc) {
        List<?> dataList = DatabaseOptUtils.findObjectsByHql(baseDao, shql, values, pageDesc);
        if (dataList == null || dataList.size() == 0) {
            return null;
        }
        String[] fieldNames = fieldnames;
        if (fieldNames == null) {
            List fields = QueryUtils.getSqlFiledNames((String)shql);
            if (fields == null || fields.size() < 1) {
                return null;
            }
            fieldNames = fields.toArray(new String[fields.size()]);
        }
        JSONArray ja = new JSONArray();
        for (int j = 0; j < dataList.size(); ++j) {
            JSONObject jo = new JSONObject();
            for (int i = 0; i < fieldNames.length; ++i) {
                jo.put(fieldNames[i], DatabaseAccess.fetchLobField((Object)((Object[])dataList.get(j))[i], (boolean)false));
            }
            ja.add((Object)jo);
        }
        return ja;
    }

    public static final JSONArray findObjectsAsJSONByHql(BaseDaoImpl<?, ?> baseDao, String shql, String[] fieldNames) {
        return DatabaseOptUtils.findObjectsAsJSONByHql(baseDao, shql, fieldNames, (Object[])null, new PageDesc(-1, -1));
    }

    public static final JSONArray findObjectsAsJSONByHql(BaseDaoImpl<?, ?> baseDao, String shql, Object[] values, PageDesc pageDesc) {
        return DatabaseOptUtils.findObjectsAsJSONByHql(baseDao, shql, null, values, new PageDesc(-1, -1));
    }

    public static final JSONArray findObjectsAsJSONByHql(BaseDaoImpl<?, ?> baseDao, String shql, Map<String, Object> values, PageDesc pageDesc) {
        return DatabaseOptUtils.findObjectsAsJSONByHql(baseDao, shql, null, values, new PageDesc(-1, -1));
    }

    public static final JSONArray findObjectsAsJSONByHql(BaseDaoImpl<?, ?> baseDao, String ssql) {
        return DatabaseOptUtils.findObjectsAsJSONByHql(baseDao, ssql, null, (Object[])null, new PageDesc(-1, -1));
    }

    public static final JSONArray findObjectsAsJSONBySql(BaseDaoImpl<?, ?> baseDao, String ssql, String[] fieldnames, Object[] values, PageDesc pageDesc) {
        List dataList = DatabaseOptUtils.findObjectsBySql(baseDao, ssql, values, pageDesc, null);
        if (dataList == null || dataList.size() == 0) {
            return null;
        }
        String[] fieldNames = fieldnames;
        if (fieldNames == null) {
            List fields = QueryUtils.getSqlFiledNames((String)ssql);
            if (fields == null || fields.size() < 1) {
                return null;
            }
            fieldNames = fields.toArray(new String[fields.size()]);
        }
        JSONArray ja = new JSONArray();
        for (int j = 0; j < dataList.size(); ++j) {
            JSONObject jo = new JSONObject();
            for (int i = 0; i < fieldNames.length; ++i) {
                jo.put(fieldNames[i], DatabaseAccess.fetchLobField((Object)((Object[])dataList.get(j))[i], (boolean)false));
            }
            ja.add((Object)jo);
        }
        return ja;
    }

    public static final JSONArray findObjectsAsJSONBySql(BaseDaoImpl<?, ?> baseDao, String ssql, String[] fieldnames, Map<String, Object> values, PageDesc pageDesc) {
        List dataList = DatabaseOptUtils.findObjectsBySql(baseDao, ssql, values, pageDesc, null);
        if (dataList == null || dataList.size() == 0) {
            return null;
        }
        String[] fieldNames = fieldnames;
        if (fieldNames == null) {
            List fields = QueryUtils.getSqlFiledNames((String)ssql);
            if (fields == null || fields.size() < 1) {
                return null;
            }
            fieldNames = fields.toArray(new String[fields.size()]);
        }
        JSONArray ja = new JSONArray();
        for (int j = 0; j < dataList.size(); ++j) {
            JSONObject jo = new JSONObject();
            for (int i = 0; i < fieldNames.length; ++i) {
                jo.put(fieldNames[i], DatabaseAccess.fetchLobField((Object)((Object[])dataList.get(j))[i], (boolean)false));
            }
            ja.add((Object)jo);
        }
        return ja;
    }

    public static final JSONArray findObjectsAsJSONBySql(BaseDaoImpl<?, ?> baseDao, String ssql, String[] fieldNames) {
        return DatabaseOptUtils.findObjectsAsJSONBySql(baseDao, ssql, fieldNames, (Object[])null, new PageDesc(-1, -1));
    }

    public static final JSONArray findObjectsAsJSONBySql(BaseDaoImpl<?, ?> baseDao, String shql, Object[] values, PageDesc pageDesc) {
        return DatabaseOptUtils.findObjectsAsJSONBySql(baseDao, shql, null, values, pageDesc);
    }

    public static final JSONArray findObjectsAsJSONBySql(BaseDaoImpl<?, ?> baseDao, String shql, Map<String, Object> values, PageDesc pageDesc) {
        return DatabaseOptUtils.findObjectsAsJSONBySql(baseDao, shql, null, values, pageDesc);
    }

    public static final JSONArray findObjectsAsJSONBySql(BaseDaoImpl<?, ?> baseDao, String ssql) {
        return DatabaseOptUtils.findObjectsAsJSONBySql(baseDao, ssql, null, (Object[])null, new PageDesc(-1, -1));
    }

    public static final void flush(Session dbSession) {
        dbSession.flush();
        dbSession.clear();
    }
}

