/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.service;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.service.BaseEntityManager;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseEntityManagerImpl<T extends Serializable, PK extends Serializable, D extends BaseDaoImpl<T, PK>>
implements BaseEntityManager<T, PK> {
    protected D baseDao = null;
    protected Logger logger = LoggerFactory.getLogger(BaseEntityManagerImpl.class);
    protected boolean logDebug = this.logger.isDebugEnabled();

    protected void setBaseDao(D baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteObject(T o) {
        ((BaseDaoImpl)this.baseDao).deleteObject(o);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteObjectById(PK id) {
        ((BaseDaoImpl)this.baseDao).deleteObjectById(id);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void saveObject(T o) {
        ((BaseDaoImpl)this.baseDao).saveObject(o);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void saveNewObject(T o) {
        ((BaseDaoImpl)this.baseDao).saveNewObject(o);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updateObject(T o) {
        ((BaseDaoImpl)this.baseDao).saveObject(o);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void mergeObject(T o) {
        ((BaseDaoImpl)this.baseDao).mergeObject(o);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updateObjectCheckTimestamp(T o) {
        ((BaseDaoImpl)this.baseDao).updateObjectCheckTimestamp(o);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public T getObjectById(PK id) {
        return ((BaseDaoImpl)this.baseDao).getObjectById(id);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public T getObjectByProperty(String propertyName, Object propertyValue) {
        return ((BaseDaoImpl)this.baseDao).getObjectByProperty(propertyName, propertyValue);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public T getObjectByProperties(Map<String, Object> properties) {
        return ((BaseDaoImpl)this.baseDao).getObjectByProperties(properties);
    }

    @Override
    public void copyObjectNotNullProperty(T des, T sou) {
        ReflectionOpt.invokeBinaryOpt(des, (String)"copyNotNullProperty", sou);
    }

    @Override
    public void clearObjectProperties(T des) {
        ReflectionOpt.invokeNoParamFunc(des, (String)"clearProperties");
    }

    @Override
    public void copyObject(T des, T sou) {
        ReflectionOpt.invokeBinaryOpt(des, (String)"copy", sou);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<T> listObjects() {
        return ((BaseDaoImpl)this.baseDao).listObjects();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<T> listValidObjects() {
        return ((BaseDaoImpl)this.baseDao).listValidObjects();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<T> listObjects(String shql, Map<String, Object> filterMap) {
        return ((BaseDaoImpl)this.baseDao).listObjects(shql, filterMap);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<T> listObjects(Map<String, Object> filterMap) {
        return ((BaseDaoImpl)this.baseDao).listObjects(filterMap, null);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<T> listObjects(String shql, Map<String, Object> filterMap, PageDesc pageDesc) {
        return ((BaseDaoImpl)this.baseDao).listObjects(shql, filterMap, pageDesc);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<T> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return ((BaseDaoImpl)this.baseDao).listObjects(filterMap, pageDesc);
    }
}

