/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.dao;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.support.database.jsonmaptable.DB2JsonObjectDao;
import com.centit.support.database.jsonmaptable.H2JsonObjectDao;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.jsonmaptable.MySqlJsonObjectDao;
import com.centit.support.database.jsonmaptable.OracleJsonObjectDao;
import com.centit.support.database.jsonmaptable.PostgreSqlJsonObjectDao;
import com.centit.support.database.jsonmaptable.SqlSvrJsonObjectDao;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.DBType;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonObjectWork
implements JsonObjectDao {
    private TableInfo tableInfo;
    private BaseDaoImpl<?, ?> baseDao;
    protected static Logger logger = LoggerFactory.getLogger(JsonObjectWork.class);

    public JsonObjectWork() {
    }

    public JsonObjectWork(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public JsonObjectWork(BaseDaoImpl<?, ?> baseDao, TableInfo tableInfo) {
        this.tableInfo = tableInfo;
        this.baseDao = baseDao;
    }

    public void setBaseDao(BaseDaoImpl<?, ?> baseDao) {
        this.baseDao = baseDao;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    private JsonObjectDao createDao(Connection connection) {
        DBType dbtype = DBType.mapDBType((Connection)connection);
        switch (dbtype) {
            case Oracle: {
                return new OracleJsonObjectDao(connection, this.tableInfo);
            }
            case DB2: {
                return new DB2JsonObjectDao(connection, this.tableInfo);
            }
            case SqlServer: {
                return new SqlSvrJsonObjectDao(connection, this.tableInfo);
            }
            case MySql: {
                return new MySqlJsonObjectDao(connection, this.tableInfo);
            }
            case H2: {
                return new H2JsonObjectDao(connection, this.tableInfo);
            }
            case PostgreSql: {
                return new PostgreSqlJsonObjectDao(connection, this.tableInfo);
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + dbtype.toString());
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public JSONObject getObjectById(Object keyValue) throws SQLException, IOException {
        return (JSONObject)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.getObjectById(keyValue);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public JSONObject getObjectByProperties(Map<String, Object> properties) throws SQLException, IOException {
        return (JSONObject)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.getObjectByProperties(properties);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public JSONArray listObjectsByProperties(Map<String, Object> properties) throws SQLException, IOException {
        return (JSONArray)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.listObjectsByProperties(properties);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public JSONArray listObjectsByProperties(Map<String, Object> properties, int startPos, int maxSize) throws SQLException, IOException {
        return (JSONArray)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.listObjectsByProperties(properties, startPos, maxSize);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public Long fetchObjectsCount(Map<String, Object> properties) throws SQLException, IOException {
        return (Long)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.fetchObjectsCount(properties);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public int saveNewObject(Map<String, Object> object) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDao(connection).saveNewObject(object));
    }

    public int updateObject(Collection<String> fields, Map<String, Object> object) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDao(connection).updateObject(fields, object));
    }

    public int updateObject(Map<String, Object> object) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDao(connection).updateObject(object));
    }

    public int mergeObject(Collection<String> fields, Map<String, Object> object) throws SQLException, IOException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.mergeObject(fields, object);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return 0;
            }
        });
    }

    public int mergeObject(Map<String, Object> object) throws SQLException, IOException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.mergeObject(object);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return 0;
            }
        });
    }

    public int updateObjectsByProperties(Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            return dao.updateObjectsByProperties(fieldValues, properties);
        });
    }

    public int updateObjectsByProperties(Collection<String> fields, Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDao(connection).updateObjectsByProperties(fields, fieldValues, properties));
    }

    public int deleteObjectById(Object keyValue) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDao(connection).deleteObjectById(keyValue));
    }

    public int deleteObjectsByProperties(Map<String, Object> properties) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDao(connection).deleteObjectsByProperties(properties));
    }

    public int insertObjectsAsTabulation(List<Map<String, Object>> objects) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDao(connection).insertObjectsAsTabulation(objects));
    }

    public int deleteObjects(List<Object> objects) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDao(connection).deleteObjects(objects));
    }

    public int deleteObjectsAsTabulation(String propertyName, Object propertyValue) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDao(connection).deleteObjectsAsTabulation(propertyName, propertyValue));
    }

    public int deleteObjectsAsTabulation(Map<String, Object> properties) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDao(connection).deleteObjectsAsTabulation(properties));
    }

    public int replaceObjectsAsTabulation(List<Map<String, Object>> newObjects, List<Map<String, Object>> dbObjects) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            return dao.replaceObjectsAsTabulation(newObjects, dbObjects);
        });
    }

    public int replaceObjectsAsTabulation(List<Map<String, Object>> newObjects, String propertyName, Object propertyValue) throws SQLException, IOException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.replaceObjectsAsTabulation(newObjects, propertyName, propertyValue);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return 0;
            }
        });
    }

    public int replaceObjectsAsTabulation(List<Map<String, Object>> newObjects, Map<String, Object> properties) throws SQLException, IOException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.replaceObjectsAsTabulation(newObjects, properties);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return 0;
            }
        });
    }

    public Long getSequenceNextValue(String sequenceName) throws SQLException, IOException {
        return (Long)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.getSequenceNextValue(sequenceName);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public List<Object[]> findObjectsBySql(String sSql, Object[] values) throws SQLException, IOException {
        return (List)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.findObjectsBySql(sSql, values);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public List<Object[]> findObjectsBySql(String sSql, Object[] values, int pageNo, int pageSize) throws SQLException, IOException {
        return (List)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.findObjectsBySql(sSql, values, pageNo, pageSize);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public List<Object[]> findObjectsByNamedSql(String sSql, Map<String, Object> values) throws SQLException, IOException {
        return (List)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.findObjectsByNamedSql(sSql, values);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public List<Object[]> findObjectsByNamedSql(String sSql, Map<String, Object> values, int pageNo, int pageSize) throws SQLException, IOException {
        return (List)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.findObjectsByNamedSql(sSql, values, pageNo, pageSize);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public JSONArray findObjectsAsJSON(String sSql, Object[] values, String[] fieldnames) throws SQLException, IOException {
        return (JSONArray)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.findObjectsAsJSON(sSql, values, fieldnames);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public JSONArray findObjectsAsJSON(String sSql, Object[] values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        return (JSONArray)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.findObjectsAsJSON(sSql, values, fieldnames, pageNo, pageSize);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public JSONArray findObjectsByNamedSqlAsJSON(String sSql, Map<String, Object> values, String[] fieldnames) throws SQLException, IOException {
        return (JSONArray)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.findObjectsByNamedSqlAsJSON(sSql, values, fieldnames);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public JSONArray findObjectsByNamedSqlAsJSON(String sSql, Map<String, Object> values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        return (JSONArray)this.baseDao.getCurrentSession().doReturningWork(connection -> {
            JsonObjectDao dao = this.createDao(connection);
            try {
                return dao.findObjectsByNamedSqlAsJSON(sSql, values, fieldnames, pageNo, pageSize);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public boolean doExecuteSql(String sSql) throws SQLException {
        return (Boolean)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDao(connection).doExecuteSql(sSql));
    }

    public int doExecuteSql(String sSql, Object[] values) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDao(connection).doExecuteSql(sSql, values));
    }

    public int doExecuteNamedSql(String sSql, Map<String, Object> values) throws SQLException {
        return (Integer)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDao(connection).doExecuteNamedSql(sSql, values));
    }
}

