/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jdbc.dao;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.core.dao.ExtendedQueryPool;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.core.po.EntityWithDeleteTag;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.ListOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.compiler.Lexer;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.orm.JpaMetadata;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.orm.TableMapInfo;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.PersistenceException;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import com.centit.support.file.FileType;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

public abstract class BaseDaoImpl<T extends Serializable, PK extends Serializable> {
    protected static Logger logger = LoggerFactory.getLogger(BaseDaoImpl.class);
    private Class<?> poClass = null;
    private Class<?> pkClass = null;
    protected Map<String, String> filterField = null;
    protected JdbcTemplate jdbcTemplate;
    private String daoEmbeddedFilter;

    @Resource
    public void setDataSource(DataSource dataSource) {
        if (this.jdbcTemplate == null || dataSource != this.jdbcTemplate.getDataSource()) {
            this.jdbcTemplate = new JdbcTemplate(dataSource);
        }
    }

    public final JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public final DataSource getDataSource() {
        return this.jdbcTemplate != null ? this.jdbcTemplate.getDataSource() : null;
    }

    protected final Connection getConnection() throws CannotGetJdbcConnectionException {
        return DataSourceUtils.getConnection((DataSource)this.getDataSource());
    }

    protected final void releaseConnection(Connection con) {
        DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.getDataSource());
    }

    private final void fetchTypeParams() {
        ParameterizedType genType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] params = genType.getActualTypeArguments();
        this.poClass = (Class)params[0];
        this.pkClass = (Class)params[1];
    }

    public final Class<?> getPoClass() {
        if (this.poClass == null) {
            this.fetchTypeParams();
        }
        return this.poClass;
    }

    public final Class<?> getPkClass() {
        if (this.pkClass == null) {
            this.fetchTypeParams();
        }
        return this.pkClass;
    }

    public String encapsulateFilterToSql(String filterQuery) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        if (mapInfo == null) {
            throw new PersistenceException(14, "\u6ca1\u6709\u5bf9\u5e94\u7684\u5143\u6570\u636e\u4fe1\u606f\uff1a" + this.getPoClass().getName());
        }
        return "select " + GeneralJsonObjectDao.buildFieldSql((TableInfo)mapInfo, null) + " from " + mapInfo.getTableName() + " where 1=1 " + filterQuery + (StringUtils.isBlank((CharSequence)mapInfo.getOrderBy()) ? "" : " order by " + mapInfo.getOrderBy());
    }

    public String getExtendFilterQuerySql() {
        return ExtendedQueryPool.getExtendedSql((String)(FileType.getFileExtName((String)this.getPoClass().getName()) + "_QUERY_0"));
    }

    public abstract Map<String, String> getFilterField();

    private static ImmutablePair<String, String> parseParameter(String sParameter) {
        int e = sParameter.indexOf(41);
        if (e > 0) {
            int b = sParameter.indexOf(40) + 1;
            String paramPretreatment = sParameter.substring(b, e).trim();
            String paramAlias = sParameter.substring(e + 1).trim();
            return new ImmutablePair((Object)paramAlias, (Object)paramPretreatment);
        }
        return new ImmutablePair((Object)sParameter, null);
    }

    public static Map<String, Pair<String, String>> getFilterFieldWithPretreatment(Map<String, String> fieldMap) {
        if (fieldMap == null) {
            return null;
        }
        HashMap<String, Pair<String, String>> filterFieldWithPretreatment = new HashMap<String, Pair<String, String>>(fieldMap.size() * 2);
        for (Map.Entry<String, String> ent : fieldMap.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)ent.getKey())) continue;
            ImmutablePair<String, String> paramMeta = BaseDaoImpl.parseParameter(ent.getKey());
            filterFieldWithPretreatment.put((String)paramMeta.left, (Pair<String, String>)new ImmutablePair((Object)ent.getValue(), paramMeta.getRight()));
        }
        return filterFieldWithPretreatment;
    }

    public static String translatePropertyNameToColumnName(TableMapInfo mapInfo, String sql, String alias) {
        StringBuilder sqlb = new StringBuilder();
        Lexer lex = new Lexer(sql, 2);
        boolean needTranslate = true;
        int prePos = 0;
        int preWordPos = 0;
        String aWord = lex.getAWord();
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        if ("[".equals(aWord)) {
            aWord = lex.getAWord();
            while (aWord != null && !"".equals(aWord) && !"|".equals(aWord)) {
                if ("(".equals(aWord)) {
                    lex.seekToRightBracket();
                }
                aWord = lex.getAWord();
            }
        }
        while (aWord != null && !"".equals(aWord)) {
            SimpleTableField col;
            if ("select".equalsIgnoreCase(aWord) || "from".equalsIgnoreCase(aWord)) {
                needTranslate = false;
            } else if ("where".equalsIgnoreCase(aWord)) {
                needTranslate = true;
            }
            if (!needTranslate) {
                preWordPos = lex.getCurrPos();
                aWord = lex.getAWord();
                continue;
            }
            if (":".equals(aWord)) {
                lex.getAWord();
                preWordPos = lex.getCurrPos();
                aWord = lex.getAWord();
            }
            if (Lexer.isLabel((String)aWord) && (col = mapInfo.findFieldByName(aWord)) != null) {
                if (preWordPos > prePos) {
                    sqlb.append(sql.substring(prePos, preWordPos));
                }
                sqlb.append(addAlias ? " " + alias + "." : " ").append(col.getColumnName());
                prePos = lex.getCurrPos();
            }
            preWordPos = lex.getCurrPos();
            aWord = lex.getAWord();
        }
        sqlb.append(sql.substring(prePos));
        return sqlb.toString();
    }

    public String buildFieldFilterSql(String alias, boolean useDefaultFilter) {
        StringBuilder sBuilder = new StringBuilder();
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        Map<String, Pair<String, String>> fieldFilter = BaseDaoImpl.getFilterFieldWithPretreatment(this.getFilterField());
        if (useDefaultFilter) {
            mapInfo.getColumns().stream().filter(col -> fieldFilter == null || !fieldFilter.containsKey(col.getPropertyName())).forEach(col -> sBuilder.append(" [:").append(col.getPropertyName()).append("| and ").append(col.getColumnName()).append(" = :").append(col.getPropertyName()).append(" ]"));
        }
        if (fieldFilter != null) {
            for (Map.Entry<String, Pair<String, String>> ent : fieldFilter.entrySet()) {
                SimpleTableField col2;
                String skey = ent.getKey();
                String sSqlFormat = (String)ent.getValue().getLeft();
                if (skey.startsWith("NP_")) {
                    sBuilder.append(" [").append(skey).append("| and ").append(BaseDaoImpl.translatePropertyNameToColumnName(mapInfo, sSqlFormat, alias)).append(" ]");
                    continue;
                }
                String pretreatment = (String)ent.getValue().getRight();
                if (sSqlFormat.equalsIgnoreCase("EQUAL")) {
                    col2 = mapInfo.findFieldByName(skey);
                    if (col2 == null) continue;
                    sBuilder.append(" [:");
                    if (StringUtils.isNotBlank((CharSequence)pretreatment)) {
                        sBuilder.append("(").append(pretreatment).append(")");
                    }
                    sBuilder.append(skey).append("| and ").append(addAlias ? alias + "." : "").append(col2.getColumnName()).append(" = :").append(col2.getPropertyName()).append(" ]");
                    continue;
                }
                if (sSqlFormat.equalsIgnoreCase("LIKE")) {
                    col2 = mapInfo.findFieldByName(skey);
                    if (col2 == null) continue;
                    sBuilder.append(" [:(").append(StringUtils.isBlank((CharSequence)pretreatment) ? "like" : pretreatment).append(")").append(skey).append("| and ").append(addAlias ? alias + "." : "").append(col2.getColumnName()).append(" like :").append(col2.getPropertyName()).append(" ]");
                    continue;
                }
                if (sSqlFormat.equalsIgnoreCase("IN")) {
                    col2 = mapInfo.findFieldByName(skey);
                    if (col2 == null) continue;
                    sBuilder.append(" [:");
                    if (StringUtils.isNotBlank((CharSequence)pretreatment)) {
                        sBuilder.append("(").append(pretreatment).append(")");
                    }
                    sBuilder.append(skey).append("| and ").append(addAlias ? alias + "." : "").append(col2.getColumnName()).append(" in (:").append(col2.getPropertyName()).append(") ]");
                    continue;
                }
                if ("[".equals(Lexer.getFirstWord((String)sSqlFormat))) {
                    sBuilder.append(BaseDaoImpl.translatePropertyNameToColumnName(mapInfo, sSqlFormat, alias));
                    continue;
                }
                sBuilder.append(" [:");
                if (StringUtils.isNotBlank((CharSequence)pretreatment)) {
                    sBuilder.append("(").append(pretreatment).append(")");
                }
                sBuilder.append(skey).append("| and ").append(BaseDaoImpl.translatePropertyNameToColumnName(mapInfo, sSqlFormat, alias)).append(" ]");
            }
        }
        return sBuilder.toString();
    }

    public String buildDefaultFieldFilterSql() {
        if (this.daoEmbeddedFilter == null) {
            this.daoEmbeddedFilter = this.buildFieldFilterSql(null, false);
        }
        return this.daoEmbeddedFilter;
    }

    public final String getFilterQuerySql() {
        String querySql = this.getExtendFilterQuerySql();
        if (StringUtils.isBlank((CharSequence)querySql)) {
            querySql = this.buildDefaultFieldFilterSql();
            return this.encapsulateFilterToSql(querySql);
        }
        if ("[".equals(Lexer.getFirstWord((String)querySql))) {
            return this.encapsulateFilterToSql(querySql);
        }
        return querySql;
    }

    public void saveNewObject(T o) {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.saveNewObject((Connection)conn, (Object)o));
    }

    public void deleteObjectForce(T o) {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.deleteObject((Connection)conn, (Object)o));
    }

    public void deleteObjectForceById(Object id) {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.deleteObjectById((Connection)conn, (Object)id, this.getPoClass()));
    }

    public void deleteObjectsForceByProperties(Map<String, Object> filterMap) {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.deleteObjectByProperties((Connection)conn, (Map)filterMap, this.getPoClass()));
    }

    public void deleteObject(T o) {
        if (o instanceof EntityWithDeleteTag) {
            ((EntityWithDeleteTag)o).setDeleted(true);
            this.updateObject(o);
        } else {
            this.deleteObjectForce(o);
        }
    }

    public void deleteObjectById(Object id) {
        if (EntityWithDeleteTag.class.isAssignableFrom(this.getPoClass())) {
            T o = this.getObjectById(id);
            ((EntityWithDeleteTag)o).setDeleted(true);
            this.updateObject(o);
        } else {
            this.deleteObjectForceById(id);
        }
    }

    public void deleteObjectsByProperties(Map<String, Object> filterMap) {
        if (EntityWithDeleteTag.class.isAssignableFrom(this.getPoClass())) {
            List<T> deleteList = this.listObjectsByProperties(filterMap);
            if (deleteList != null) {
                for (Serializable obj : deleteList) {
                    ((EntityWithDeleteTag)obj).setDeleted(true);
                    this.updateObject(obj);
                }
            }
        } else {
            this.deleteObjectsForceByProperties(filterMap);
        }
    }

    public void updateObject(T o) {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.updateObject((Connection)conn, (Object)o));
    }

    public void updateObject(Collection<String> fields, T object) throws PersistenceException {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.updateObject((Connection)conn, (Collection)fields, (Object)object));
    }

    public void batchUpdateObject(Collection<String> fields, T object, Map<String, Object> properties) {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.batchUpdateObject((Connection)conn, (Collection)fields, (Object)object, (Map)properties));
    }

    public void updateObject(String[] fields, T object) throws PersistenceException {
        this.updateObject(ListOpt.arrayToList((Object[])fields), object);
    }

    public void batchUpdateObject(String[] fields, T object, Map<String, Object> properties) {
        this.batchUpdateObject(ListOpt.arrayToList((Object[])fields), object, properties);
    }

    public void mergeObject(T o) {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.mergeObject((Connection)conn, (Object)o));
    }

    public T getObjectById(Object id) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.getObjectById((Connection)conn, (Object)id, this.getPoClass())));
    }

    public T getObjectIncludeLazyById(Object id) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.getObjectIncludeLazyById((Connection)conn, (Object)id, this.getPoClass())));
    }

    public T getObjectCascadeById(Object id) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.getObjectCascadeById((Connection)conn, (Object)id, this.getPoClass())));
    }

    public T getObjectCascadeShallowById(Object id) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.getObjectCascadeShallowById((Connection)conn, (Object)id, this.getPoClass())));
    }

    public T fetchObjectLazyColumn(T o, String columnName) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.fetchObjectLazyColumn((Connection)conn, (Object)o, (String)columnName)));
    }

    public T fetchObjectLazyColumns(T o) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.fetchObjectLazyColumns((Connection)conn, (Object)o)));
    }

    public T fetchObjectReference(T o, String columnName) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.fetchObjectReference((Connection)conn, (Object)o, (String)columnName)));
    }

    public T fetchObjectReferences(T o) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.fetchObjectReferences((Connection)conn, (Object)o)));
    }

    public Integer saveObjectReference(T o, String columnName) {
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.saveObjectReference((Connection)conn, (Object)o, (String)columnName));
    }

    public Integer saveObjectReferences(T o) {
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.saveObjectReferences((Connection)conn, (Object)o));
    }

    public T getObjectByProperties(Map<String, Object> properties) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.getObjectByProperties((Connection)conn, (Map)properties, this.getPoClass())));
    }

    public List<T> listObjectsByProperty(String propertyName, Object value) {
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.listObjectsByProperties((Connection)conn, (Map)QueryUtils.createSqlParamsMap((Object[])new Object[]{propertyName, value}), this.getPoClass()));
    }

    public List<T> listObjectsByProperties(Map<String, Object> filterMap) {
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.listObjectsByProperties((Connection)conn, (Map)filterMap, this.getPoClass()));
    }

    public List<T> listObjectsByProperties(Map<String, Object> filterMap, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0 && pageDesc.getPageNo() > 0) {
            return (List)this.jdbcTemplate.execute(conn -> {
                pageDesc.setTotalRows(OrmDaoUtils.fetchObjectsCount((Connection)conn, (Map)filterMap, this.getPoClass()));
                return OrmDaoUtils.listObjectsByProperties((Connection)conn, (Map)filterMap, this.getPoClass(), (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize());
            });
        }
        List<T> objList = this.listObjectsByProperties(filterMap);
        if (pageDesc != null && objList != null) {
            pageDesc.setTotalRows(objList.size());
        }
        return objList;
    }

    public int pageCount(Map<String, Object> filterMap) {
        String sql = this.getFilterQuerySql();
        if (StringUtils.isBlank((CharSequence)sql)) {
            return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.fetchObjectsCount((Connection)conn, (Map)filterMap, this.getPoClass()));
        }
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)QueryUtils.buildGetCountSQLByReplaceFields((String)sql), filterMap);
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.fetchObjectsCount((Connection)conn, (String)qap.getSql(), (Map)qap.getParams()));
    }

    public List<T> pageQuery(Map<String, Object> filterMap) {
        String querySql = this.getFilterQuerySql();
        PageDesc pageDesc = QueryParameterPrepare.fetckPageDescParams(filterMap);
        if (StringUtils.isBlank((CharSequence)querySql)) {
            return this.listObjectsByProperties(filterMap, pageDesc);
        }
        String selfOrderBy = BaseDaoImpl.fetchSelfOrderSql(filterMap);
        if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
            querySql = QueryUtils.removeOrderBy((String)querySql) + " order by " + selfOrderBy;
        }
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, filterMap);
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams(), this.getPoClass(), (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize()));
    }

    public List<T> listObjects() {
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.listAllObjects((Connection)conn, this.getPoClass()));
    }

    public List<T> listObjects(Map<String, Object> filterMap) {
        String querySql = this.getFilterQuerySql();
        if (StringUtils.isBlank((CharSequence)querySql)) {
            return this.listObjectsByProperties(filterMap);
        }
        String selfOrderBy = BaseDaoImpl.fetchSelfOrderSql(filterMap);
        if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
            querySql = QueryUtils.removeOrderBy((String)querySql) + " order by " + selfOrderBy;
        }
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, filterMap);
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)qap.getSql(), (Map)qap.getParams(), this.getPoClass()));
    }

    public List<T> listObjectsByFilter(String whereSql, Object[] params) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        String fieldsSql = GeneralJsonObjectDao.buildFieldSql((TableInfo)mapInfo, null);
        String querySql = "select " + fieldsSql + " from " + mapInfo.getTableName() + " " + whereSql;
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)querySql, (Object[])params, this.getPoClass()));
    }

    public List<T> listObjectsByFilter(String whereSql, Map<String, Object> namedParams) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        String fieldsSql = GeneralJsonObjectDao.buildFieldSql((TableInfo)mapInfo, null);
        String querySql = "select " + fieldsSql + " from " + mapInfo.getTableName() + " " + whereSql;
        return this.listObjectsBySql(querySql, namedParams);
    }

    @Deprecated
    public List<T> listObjectsByFilter(String whereSql, Object[] params, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0 && pageDesc.getPageNo() > 0) {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
            String fieldsSql = GeneralJsonObjectDao.buildFieldSql((TableInfo)mapInfo, null);
            String querySql = "select " + fieldsSql + " from " + mapInfo.getTableName() + " " + whereSql;
            pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery(this, "select count(1) from " + mapInfo.getTableName() + " " + QueryUtils.removeOrderBy((String)whereSql), params)));
            return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)querySql, (Object[])params, this.getPoClass(), (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize()));
        }
        List<T> objList = this.listObjectsByFilter(whereSql, params);
        if (pageDesc != null && objList != null) {
            pageDesc.setTotalRows(objList.size());
        }
        return objList;
    }

    @Deprecated
    public List<T> listObjectsByFilter(String whereSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0 && pageDesc.getPageNo() > 0) {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
            String fieldsSql = GeneralJsonObjectDao.buildFieldSql((TableInfo)mapInfo, null);
            String querySql = "select " + fieldsSql + " from " + mapInfo.getTableName() + " " + whereSql;
            pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery(this, "select count(1) from " + mapInfo.getTableName() + " " + QueryUtils.removeOrderBy((String)whereSql), namedParams)));
            return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)querySql, (Map)namedParams, this.getPoClass(), (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize()));
        }
        List<T> objList = this.listObjectsByFilter(whereSql, namedParams);
        if (pageDesc != null && objList != null) {
            pageDesc.setTotalRows(objList.size());
        }
        return objList;
    }

    public List<T> listObjectsBySql(String querySql, Map<String, Object> namedParams) {
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)querySql, (Map)namedParams, this.getPoClass()));
    }

    private static String fetchSelfOrderSql(Map<String, Object> filterMap) {
        String sortField;
        String selfOrderBy = StringBaseOpt.objectToString((Object)filterMap.get("ORDER_BY"));
        if (StringUtils.isBlank((CharSequence)selfOrderBy) && StringUtils.isNotBlank((CharSequence)(sortField = StringBaseOpt.objectToString((Object)filterMap.get("sort"))))) {
            selfOrderBy = sortField;
            String sOrder = StringBaseOpt.objectToString((Object)filterMap.get("order"));
            if ("desc".equalsIgnoreCase(sOrder)) {
                selfOrderBy = sortField + " " + sOrder;
            }
        }
        return selfOrderBy;
    }

    public JSONArray listObjectsAsJson(Map<String, Object> filterMap, PageDesc pageDesc) {
        String querySql = this.getFilterQuerySql();
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        Pair q = GeneralJsonObjectDao.buildFieldSqlWithFieldName((TableInfo)mapInfo, null);
        String selfOrderBy = BaseDaoImpl.fetchSelfOrderSql(filterMap);
        Map paramsMap = filterMap;
        if (StringUtils.isBlank((CharSequence)querySql)) {
            String orderBy;
            String filter = GeneralJsonObjectDao.buildFilterSql((TableInfo)mapInfo, null, filterMap.keySet());
            querySql = "select " + (String)q.getLeft() + " from " + mapInfo.getTableName();
            if (StringUtils.isNotBlank((CharSequence)filter)) {
                querySql = querySql + " where " + filter;
            }
            String string = orderBy = StringUtils.isBlank((CharSequence)selfOrderBy) ? mapInfo.getOrderBy() : selfOrderBy;
            if (StringUtils.isNotBlank((CharSequence)orderBy)) {
                querySql = querySql + " order by " + orderBy;
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
                querySql = QueryUtils.removeOrderBy((String)querySql) + " order by " + selfOrderBy;
            }
            QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, filterMap);
            querySql = qap.getQuery();
            paramsMap = qap.getParams();
        }
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            return DatabaseOptUtils.listObjectsBySqlAsJson(this, querySql, (String[])q.getRight(), QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), paramsMap, pageDesc);
        }
        return DatabaseOptUtils.listObjectsBySqlAsJson(this, querySql, (String[])q.getRight(), paramsMap);
    }

    public JSONArray listObjectsByFilterAsJson(String whereSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        Pair fieldsDesc = GeneralJsonObjectDao.buildFieldSqlWithFieldName((TableInfo)mapInfo, null);
        String querySql = "select " + (String)fieldsDesc.getLeft() + " from " + mapInfo.getTableName() + " " + whereSql;
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            return DatabaseOptUtils.listObjectsBySqlAsJson(this, querySql, (String[])fieldsDesc.getRight(), QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), namedParams, pageDesc);
        }
        return DatabaseOptUtils.listObjectsBySqlAsJson(this, querySql, (String[])fieldsDesc.getRight(), namedParams);
    }

    public JSONArray listObjectsByFilterAsJson(String whereSql, Object[] params, PageDesc pageDesc) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        Pair fieldsDesc = GeneralJsonObjectDao.buildFieldSqlWithFieldName((TableInfo)mapInfo, null);
        String querySql = "select " + (String)fieldsDesc.getLeft() + " from " + mapInfo.getTableName() + " " + whereSql;
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            return DatabaseOptUtils.listObjectsBySqlAsJson(this, querySql, (String[])fieldsDesc.getRight(), QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), params, pageDesc);
        }
        return DatabaseOptUtils.listObjectsBySqlAsJson(this, querySql, params, (String[])fieldsDesc.getRight());
    }
}

