/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jdbc.dao;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.core.dao.ExtendedQueryPool;
import com.centit.framework.core.dao.QueryParameterPrepare;
import com.centit.framework.core.po.EntityWithDeleteTag;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.ListOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.compiler.Lexer;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableReference;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.orm.JpaMetadata;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.orm.TableMapInfo;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.PersistenceException;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import com.centit.support.file.FileType;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

public abstract class BaseDaoImpl<T extends Serializable, PK extends Serializable> {
    protected static Logger logger = LoggerFactory.getLogger(BaseDaoImpl.class);
    private Class<?> poClass = null;
    private Class<?> pkClass = null;
    protected Map<String, String> filterField = null;
    protected JdbcTemplate jdbcTemplate;
    private String daoEmbeddedFilter;

    @Resource
    public void setDataSource(DataSource dataSource) {
        if (this.jdbcTemplate == null || dataSource != this.jdbcTemplate.getDataSource()) {
            this.jdbcTemplate = new JdbcTemplate(dataSource);
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public DataSource getDataSource() {
        return this.jdbcTemplate != null ? this.jdbcTemplate.getDataSource() : null;
    }

    public Connection getConnection() throws CannotGetJdbcConnectionException {
        return DataSourceUtils.getConnection((DataSource)this.getDataSource());
    }

    public void releaseConnection(Connection con) {
        DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.getDataSource());
    }

    private void fetchTypeParams() {
        ParameterizedType genType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] params = genType.getActualTypeArguments();
        this.poClass = (Class)params[0];
        this.pkClass = (Class)params[1];
    }

    public Class<?> getPoClass() {
        if (this.poClass == null) {
            this.fetchTypeParams();
        }
        return this.poClass;
    }

    public Class<?> getPkClass() {
        if (this.pkClass == null) {
            this.fetchTypeParams();
        }
        return this.pkClass;
    }

    public String encapsulateFilterToSql(String filterQuery) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        if (mapInfo == null) {
            throw new PersistenceException(14, "\u6ca1\u6709\u5bf9\u5e94\u7684\u5143\u6570\u636e\u4fe1\u606f\uff1a" + this.getPoClass().getName());
        }
        return "select " + GeneralJsonObjectDao.buildFieldSql((TableInfo)mapInfo, null) + " from " + mapInfo.getTableName() + " where 1=1 {" + mapInfo.getTableName() + "}" + filterQuery + (StringUtils.isBlank((CharSequence)mapInfo.getOrderBy()) ? "" : " order by " + mapInfo.getOrderBy());
    }

    public String getExtendFilterQuerySql() {
        return ExtendedQueryPool.getExtendedSql((String)(FileType.getFileExtName((String)this.getPoClass().getName()) + "_QUERY_0"));
    }

    protected static ImmutablePair<String, String> parseParameter(String sParameter) {
        int e = sParameter.indexOf(41);
        if (e > 0) {
            int b = sParameter.indexOf(40) + 1;
            String paramPretreatment = sParameter.substring(b, e).trim();
            String paramAlias = sParameter.substring(e + 1).trim();
            return new ImmutablePair((Object)paramAlias, (Object)paramPretreatment);
        }
        return new ImmutablePair((Object)sParameter, null);
    }

    public static Map<String, Pair<String, String>> getFilterFieldWithPretreatment(Map<String, String> fieldMap) {
        if (fieldMap == null) {
            return null;
        }
        HashMap<String, Pair<String, String>> filterFieldWithPretreatment = new HashMap<String, Pair<String, String>>(fieldMap.size() * 2);
        for (Map.Entry<String, String> ent : fieldMap.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)ent.getKey())) continue;
            ImmutablePair<String, String> paramMeta = BaseDaoImpl.parseParameter(ent.getKey());
            filterFieldWithPretreatment.put((String)paramMeta.left, (Pair<String, String>)new ImmutablePair((Object)ent.getValue(), paramMeta.getRight()));
        }
        return filterFieldWithPretreatment;
    }

    public static String translatePropertyNameToColumnName(TableMapInfo mapInfo, String sql, String alias) {
        StringBuilder sqlb = new StringBuilder();
        Lexer lex = new Lexer(sql, 2);
        boolean needTranslate = true;
        int prePos = 0;
        int preWordPos = 0;
        String aWord = lex.getAWord();
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        if ("[".equals(aWord)) {
            aWord = lex.getAWord();
            while (aWord != null && !"".equals(aWord) && !"|".equals(aWord)) {
                if ("(".equals(aWord)) {
                    lex.seekToRightBracket();
                }
                aWord = lex.getAWord();
            }
        }
        while (aWord != null && !"".equals(aWord)) {
            SimpleTableField col;
            if ("select".equalsIgnoreCase(aWord) || "from".equalsIgnoreCase(aWord)) {
                needTranslate = false;
            } else if ("where".equalsIgnoreCase(aWord)) {
                needTranslate = true;
            }
            if (!needTranslate) {
                preWordPos = lex.getCurrPos();
                aWord = lex.getAWord();
                continue;
            }
            if (":".equals(aWord)) {
                lex.getAWord();
                preWordPos = lex.getCurrPos();
                aWord = lex.getAWord();
            }
            if (Lexer.isLabel((String)aWord) && (col = mapInfo.findFieldByName(aWord)) != null) {
                if (preWordPos > prePos) {
                    sqlb.append(sql.substring(prePos, preWordPos));
                }
                sqlb.append(addAlias ? " " + alias + "." : " ").append(col.getColumnName());
                prePos = lex.getCurrPos();
            }
            preWordPos = lex.getCurrPos();
            aWord = lex.getAWord();
        }
        sqlb.append(sql.substring(prePos));
        return sqlb.toString();
    }

    public String buildFieldFilterSql(String alias, boolean useDefaultFilter) {
        StringBuilder sBuilder = new StringBuilder();
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        Map<String, Pair<String, String>> fieldFilter = BaseDaoImpl.getFilterFieldWithPretreatment(this.getFilterField());
        if (useDefaultFilter || fieldFilter == null || fieldFilter.size() == 0) {
            mapInfo.getColumns().stream().filter(col -> fieldFilter == null || !fieldFilter.containsKey(col.getPropertyName())).forEach(col -> sBuilder.append(" [:").append(col.getPropertyName()).append("| and ").append(col.getColumnName()).append(" = :").append(col.getPropertyName()).append(" ]"));
        }
        if (fieldFilter != null) {
            for (Map.Entry<String, Pair<String, String>> ent : fieldFilter.entrySet()) {
                SimpleTableField col2;
                String skey = ent.getKey();
                String sSqlFormat = (String)ent.getValue().getLeft();
                if ("ORDER BY".equalsIgnoreCase(skey)) continue;
                if (skey.startsWith("NP_")) {
                    sBuilder.append(" [").append(skey).append("| and ").append(BaseDaoImpl.translatePropertyNameToColumnName(mapInfo, sSqlFormat, alias)).append(" ]");
                    continue;
                }
                String pretreatment = (String)ent.getValue().getRight();
                if (sSqlFormat.equalsIgnoreCase("EQUAL")) {
                    col2 = mapInfo.findFieldByName(skey);
                    if (col2 == null) continue;
                    sBuilder.append(" [:");
                    if (StringUtils.isNotBlank((CharSequence)pretreatment)) {
                        sBuilder.append("(").append(pretreatment).append(")");
                    }
                    sBuilder.append(skey).append("| and ").append(addAlias ? alias + "." : "").append(col2.getColumnName()).append(" = :").append(col2.getPropertyName()).append(" ]");
                    continue;
                }
                if (sSqlFormat.equalsIgnoreCase("LIKE")) {
                    col2 = mapInfo.findFieldByName(skey);
                    if (col2 == null) continue;
                    sBuilder.append(" [:(").append(StringUtils.isBlank((CharSequence)pretreatment) ? "like" : pretreatment).append(")").append(skey).append("| and ").append(addAlias ? alias + "." : "").append(col2.getColumnName()).append(" like :").append(col2.getPropertyName()).append(" ]");
                    continue;
                }
                if (sSqlFormat.equalsIgnoreCase("IN")) {
                    col2 = mapInfo.findFieldByName(skey);
                    if (col2 == null) continue;
                    sBuilder.append(" [:");
                    if (StringUtils.isNotBlank((CharSequence)pretreatment)) {
                        sBuilder.append("(").append(pretreatment).append(")");
                    }
                    sBuilder.append(skey).append("| and ").append(addAlias ? alias + "." : "").append(col2.getColumnName()).append(" in (:").append(col2.getPropertyName()).append(") ]");
                    continue;
                }
                if ("[".equals(Lexer.getFirstWord((String)sSqlFormat))) {
                    sBuilder.append(BaseDaoImpl.translatePropertyNameToColumnName(mapInfo, sSqlFormat, alias));
                    continue;
                }
                sBuilder.append(" [:");
                if (StringUtils.isNotBlank((CharSequence)pretreatment)) {
                    sBuilder.append("(").append(pretreatment).append(")");
                }
                sBuilder.append(skey).append("| and ").append(BaseDaoImpl.translatePropertyNameToColumnName(mapInfo, sSqlFormat, alias)).append(" ]");
            }
        }
        return sBuilder.toString();
    }

    public abstract Map<String, String> getFilterField();

    public boolean enableDefaultFilter() {
        return false;
    }

    public String buildDefaultFieldFilterSql() {
        if (this.daoEmbeddedFilter == null) {
            this.daoEmbeddedFilter = this.buildFieldFilterSql(null, this.enableDefaultFilter());
        }
        return this.daoEmbeddedFilter;
    }

    public String getFilterQuerySql() {
        String querySql = this.getExtendFilterQuerySql();
        if (StringUtils.isBlank((CharSequence)querySql)) {
            querySql = this.buildDefaultFieldFilterSql();
            return this.encapsulateFilterToSql(querySql);
        }
        if ("[".equals(Lexer.getFirstWord((String)querySql))) {
            return this.encapsulateFilterToSql(querySql);
        }
        return querySql;
    }

    public void saveNewObject(T o) {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.saveNewObject((Connection)conn, (Object)o));
    }

    public void deleteObjectForce(T o) {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.deleteObject((Connection)conn, (Object)o));
    }

    public void deleteObjectForceById(Object id) {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.deleteObjectById((Connection)conn, (Object)id, this.getPoClass()));
    }

    public void deleteObjectsForceByProperties(Map<String, Object> filterMap) {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.deleteObjectByProperties((Connection)conn, (Map)filterMap, this.getPoClass()));
    }

    public void deleteObject(T o) {
        if (o instanceof EntityWithDeleteTag) {
            ((EntityWithDeleteTag)o).setDeleted(true);
            this.updateObject(o);
        } else {
            this.deleteObjectForce(o);
        }
    }

    public void deleteObjectById(Object id) {
        if (EntityWithDeleteTag.class.isAssignableFrom(this.getPoClass())) {
            T o = this.getObjectById(id);
            ((EntityWithDeleteTag)o).setDeleted(true);
            this.updateObject(o);
        } else {
            this.deleteObjectForceById(id);
        }
    }

    public void deleteObjectsByProperties(Map<String, Object> filterMap) {
        if (EntityWithDeleteTag.class.isAssignableFrom(this.getPoClass())) {
            List<T> deleteList = this.listObjectsByProperties(filterMap);
            if (deleteList != null) {
                for (Serializable obj : deleteList) {
                    ((EntityWithDeleteTag)obj).setDeleted(true);
                    this.updateObject(obj);
                }
            }
        } else {
            this.deleteObjectsForceByProperties(filterMap);
        }
    }

    public void updateObject(T o) {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.updateObject((Connection)conn, (Object)o));
    }

    public void updateObject(Collection<String> fields, T object) throws PersistenceException {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.updateObject((Connection)conn, (Collection)fields, (Object)object));
    }

    public void updateObject(String[] fields, T object) throws PersistenceException {
        this.updateObject(ListOpt.arrayToList((Object[])fields), object);
    }

    public void mergeObject(T o) {
        this.jdbcTemplate.execute(conn -> OrmDaoUtils.mergeObject((Connection)conn, (Object)o));
    }

    public T getObjectById(Object id) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.getObjectById((Connection)conn, (Object)id, this.getPoClass())));
    }

    public T getObjectIncludeLazyById(Object id) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.getObjectIncludeLazyById((Connection)conn, (Object)id, this.getPoClass())));
    }

    public T getObjectWithReferences(Object id) {
        T obj = this.getObjectById(id);
        return this.fetchObjectReferences(obj);
    }

    public T fetchObjectLazyColumn(T o, String columnName) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.fetchObjectLazyColumn((Connection)conn, (Object)o, (String)columnName)));
    }

    public T fetchObjectLazyColumns(T o) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.fetchObjectLazyColumns((Connection)conn, (Object)o)));
    }

    public T fetchObjectReference(T object, String columnName) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        SimpleTableReference ref = mapInfo.findReference(columnName);
        SimpleTableField field = mapInfo.findFieldByName(columnName);
        if (ref == null || field == null || ref.getReferenceColumns().size() < 1) {
            return object;
        }
        Class refType = ref.getTargetEntityType();
        TableMapInfo refMapInfo = JpaMetadata.fetchTableMapInfo((Class)refType);
        if (refMapInfo == null) {
            return object;
        }
        HashMap properties = new HashMap(6);
        for (Map.Entry entry : ref.getReferenceColumns().entrySet()) {
            properties.put(entry.getValue(), ReflectionOpt.getFieldValue(object, (String)((String)entry.getKey())));
        }
        List refs = (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.listObjectsByProperties((Connection)conn, (Map)properties, (Class)refType));
        if (refs != null && refs.size() > 0) {
            if (ref.getReferenceType().isAssignableFrom(refType)) {
                if (EntityWithDeleteTag.class.isAssignableFrom(refType)) {
                    for (Object refObject : refs) {
                        if (((EntityWithDeleteTag)refObject).isDeleted()) continue;
                        field.setObjectFieldValue(object, refObject);
                        break;
                    }
                } else {
                    field.setObjectFieldValue(object, refs.get(0));
                }
            } else if (Set.class.isAssignableFrom(ref.getReferenceType())) {
                HashSet hashSet = new HashSet(refs.size() + 1);
                if (EntityWithDeleteTag.class.isAssignableFrom(refType)) {
                    for (Object refObject : refs) {
                        if (((EntityWithDeleteTag)refObject).isDeleted()) continue;
                        hashSet.add(refObject);
                    }
                } else {
                    hashSet.addAll(refs);
                }
                field.setObjectFieldValue(object, hashSet);
            } else if (List.class.isAssignableFrom(ref.getReferenceType())) {
                if (EntityWithDeleteTag.class.isAssignableFrom(refType)) {
                    ArrayList arrayList = new ArrayList(refs.size());
                    for (Object refObject : refs) {
                        if (((EntityWithDeleteTag)refObject).isDeleted()) continue;
                        arrayList.add(refObject);
                    }
                } else {
                    field.setObjectFieldValue(object, (Object)refs);
                }
            }
        }
        return object;
    }

    public T fetchObjectReferences(T o) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                this.fetchObjectReference(o, ref.getReferenceName());
            }
        }
        return o;
    }

    public Integer saveObjectReference(T object, String columnName) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        SimpleTableReference ref = mapInfo.findReference(columnName);
        if (ref == null || ref.getReferenceColumns().size() < 1) {
            return 0;
        }
        Object newObj = ref.getObjectFieldValue(object);
        Class refType = ref.getTargetEntityType();
        TableMapInfo refMapInfo = JpaMetadata.fetchTableMapInfo((Class)refType);
        if (refMapInfo == null) {
            return 0;
        }
        HashMap properties = new HashMap(6);
        for (Map.Entry entry : ref.getReferenceColumns().entrySet()) {
            properties.put(entry.getValue(), ReflectionOpt.getFieldValue(object, (String)((String)entry.getKey())));
        }
        List refs = (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.listObjectsByProperties((Connection)conn, (Map)properties, (Class)refType));
        if (newObj == null) {
            if (refs != null && refs.size() > 0) {
                if (EntityWithDeleteTag.class.isAssignableFrom(refType)) {
                    for (Object refObject : refs) {
                        if (((EntityWithDeleteTag)refObject).isDeleted()) continue;
                        ((EntityWithDeleteTag)refObject).setDeleted(true);
                        this.jdbcTemplate.execute(conn -> OrmDaoUtils.updateObject((Connection)conn, (Object)refObject));
                    }
                } else {
                    return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.deleteObjectReference((Connection)conn, (Object)object, (SimpleTableReference)ref));
                }
            }
            return 1;
        }
        OrmDaoUtils.OrmObjectComparator ormObjectComparator = new OrmDaoUtils.OrmObjectComparator(refMapInfo);
        if (ref.getReferenceType().isAssignableFrom(refType)) {
            for (Map.Entry entry : ref.getReferenceColumns().entrySet()) {
                Object obj = mapInfo.findFieldByName((String)entry.getKey()).getObjectFieldValue(object);
                refMapInfo.findFieldByName((String)entry.getValue()).setObjectFieldValue(newObj, obj);
            }
            boolean haveSaved = false;
            if (refs != null && refs.size() > 0) {
                for (Object refObject : refs) {
                    if (ormObjectComparator.compare(refObject, newObj) == 0) {
                        this.jdbcTemplate.execute(conn -> OrmDaoUtils.updateObject((Connection)conn, (Object)newObj));
                        haveSaved = true;
                        continue;
                    }
                    if (EntityWithDeleteTag.class.isAssignableFrom(refType)) {
                        if (((EntityWithDeleteTag)refObject).isDeleted()) continue;
                        ((EntityWithDeleteTag)refObject).setDeleted(true);
                        this.jdbcTemplate.execute(conn -> OrmDaoUtils.updateObject((Connection)conn, (Object)refObject));
                        continue;
                    }
                    this.jdbcTemplate.execute(conn -> OrmDaoUtils.deleteObject((Connection)conn, (Object)refObject));
                }
            }
            if (!haveSaved) {
                this.jdbcTemplate.execute(conn -> OrmDaoUtils.saveNewObject((Connection)conn, (Object)newObj));
            }
            return 1;
        }
        List newListObj = Set.class.isAssignableFrom(ref.getReferenceType()) ? new ArrayList((Set)newObj) : (List)newObj;
        for (Map.Entry ent : ref.getReferenceColumns().entrySet()) {
            Object obj = mapInfo.findFieldByName((String)ent.getKey()).getObjectFieldValue(object);
            for (Object subObj : newListObj) {
                refMapInfo.findFieldByName((String)ent.getValue()).setObjectFieldValue(subObj, obj);
            }
        }
        Triple triple = ListOpt.compareTwoList((List)refs, newListObj, (Comparator)new OrmDaoUtils.OrmObjectComparator(mapInfo));
        int resN = 0;
        if (triple.getLeft() != null) {
            for (Object obj : (List)triple.getLeft()) {
                resN += ((Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.saveNewObject((Connection)conn, (Object)obj))).intValue();
            }
        }
        if (triple.getRight() != null) {
            for (Object obj : (List)triple.getRight()) {
                if (EntityWithDeleteTag.class.isAssignableFrom(refType)) {
                    if (((EntityWithDeleteTag)obj).isDeleted()) continue;
                    ((EntityWithDeleteTag)obj).setDeleted(true);
                    resN += ((Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.updateObject((Connection)conn, (Object)obj))).intValue();
                    continue;
                }
                resN += ((Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.deleteObject((Connection)conn, (Object)obj))).intValue();
            }
        }
        if (triple.getMiddle() != null) {
            for (Pair pobj : (List)triple.getMiddle()) {
                resN += ((Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.updateObject((Connection)conn, (Object)pobj.getRight()))).intValue();
            }
        }
        return resN;
    }

    public Integer saveObjectReferences(T o) {
        int nRes = 0;
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                nRes += this.saveObjectReference(o, ref.getReferenceName()).intValue();
            }
        }
        return nRes;
    }

    public T getObjectByProperties(Map<String, Object> properties) {
        return (T)((Serializable)this.jdbcTemplate.execute(conn -> (Serializable)OrmDaoUtils.getObjectByProperties((Connection)conn, (Map)properties, this.getPoClass())));
    }

    public List<T> listObjectsByProperty(String propertyName, Object propertyValue) {
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.listObjectsByProperties((Connection)conn, (Map)QueryUtils.createSqlParamsMap((Object[])new Object[]{propertyName, propertyValue}), this.getPoClass()));
    }

    public List<T> listObjectsByProperties(Map<String, Object> propertiesMap) {
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.listObjectsByProperties((Connection)conn, (Map)propertiesMap, this.getPoClass()));
    }

    public List<T> listObjectsByProperties(Map<String, Object> filterMap, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0 && pageDesc.getPageNo() > 0) {
            return (List)this.jdbcTemplate.execute(conn -> {
                pageDesc.setTotalRows(OrmDaoUtils.fetchObjectsCount((Connection)conn, (Map)filterMap, this.getPoClass()));
                return OrmDaoUtils.listObjectsByProperties((Connection)conn, (Map)filterMap, this.getPoClass(), (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize());
            });
        }
        List<T> objList = this.listObjectsByProperties(filterMap);
        if (pageDesc != null && objList != null) {
            pageDesc.setTotalRows(objList.size());
        }
        return objList;
    }

    @Deprecated
    public int pageCount(Map<String, Object> filterMap) {
        String sql = this.getFilterQuerySql();
        if (StringUtils.isBlank((CharSequence)sql)) {
            return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.fetchObjectsCount((Connection)conn, (Map)filterMap, this.getPoClass()));
        }
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)QueryUtils.buildGetCountSQLByReplaceFields((String)sql), filterMap);
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.fetchObjectsCount((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams()));
    }

    @Deprecated
    public List<T> pageQuery(Map<String, Object> filterMap) {
        String querySql = this.getFilterQuerySql();
        PageDesc pageDesc = QueryParameterPrepare.fetckPageDescParams(filterMap);
        if (StringUtils.isBlank((CharSequence)querySql)) {
            return this.listObjectsByProperties(filterMap, pageDesc);
        }
        String selfOrderBy = BaseDaoImpl.fetchSelfOrderSql(querySql, filterMap);
        if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
            querySql = QueryUtils.removeOrderBy((String)querySql) + " order by " + selfOrderBy;
        }
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, filterMap);
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams(), this.getPoClass(), (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize()));
    }

    public List<T> listObjects() {
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.listAllObjects((Connection)conn, this.getPoClass()));
    }

    public List<T> listObjects(Map<String, Object> filterMap) {
        String querySql = this.getFilterQuerySql();
        if (StringUtils.isBlank((CharSequence)querySql)) {
            return this.listObjectsByProperties(filterMap);
        }
        String selfOrderBy = BaseDaoImpl.fetchSelfOrderSql(querySql, filterMap);
        if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
            querySql = QueryUtils.removeOrderBy((String)querySql) + " order by " + selfOrderBy;
        }
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, filterMap);
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams(), this.getPoClass()));
    }

    public List<T> listObjectsByFilter(String whereSql, Object[] params) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        String fieldsSql = GeneralJsonObjectDao.buildFieldSql((TableInfo)mapInfo, null);
        String querySql = "select " + fieldsSql + " from " + mapInfo.getTableName() + " " + whereSql;
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)querySql, (Object[])params, this.getPoClass()));
    }

    public List<T> listObjectsByFilter(String whereSql, Map<String, Object> namedParams) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        String fieldsSql = GeneralJsonObjectDao.buildFieldSql((TableInfo)mapInfo, null);
        String querySql = "select " + fieldsSql + " from " + mapInfo.getTableName() + " " + whereSql;
        return this.listObjectsBySql(querySql, namedParams);
    }

    @Deprecated
    public List<T> listObjectsByFilter(String whereSql, Object[] params, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0 && pageDesc.getPageNo() > 0) {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
            String fieldsSql = GeneralJsonObjectDao.buildFieldSql((TableInfo)mapInfo, null);
            String querySql = "select " + fieldsSql + " from " + mapInfo.getTableName() + " " + whereSql;
            pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery(this, "select count(1) from " + mapInfo.getTableName() + " " + QueryUtils.removeOrderBy((String)whereSql), params)));
            return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)querySql, (Object[])params, this.getPoClass(), (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize()));
        }
        List<T> objList = this.listObjectsByFilter(whereSql, params);
        if (pageDesc != null && objList != null) {
            pageDesc.setTotalRows(objList.size());
        }
        return objList;
    }

    @Deprecated
    public List<T> listObjectsByFilter(String whereSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0 && pageDesc.getPageNo() > 0) {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
            String fieldsSql = GeneralJsonObjectDao.buildFieldSql((TableInfo)mapInfo, null);
            String querySql = "select " + fieldsSql + " from " + mapInfo.getTableName() + " " + whereSql;
            pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery(this, "select count(1) from " + mapInfo.getTableName() + " " + QueryUtils.removeOrderBy((String)whereSql), namedParams)));
            return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)querySql, (Map)namedParams, this.getPoClass(), (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize()));
        }
        List<T> objList = this.listObjectsByFilter(whereSql, namedParams);
        if (pageDesc != null && objList != null) {
            pageDesc.setTotalRows(objList.size());
        }
        return objList;
    }

    public List<T> listObjectsBySql(String querySql, Map<String, Object> namedParams) {
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)querySql, (Map)namedParams, this.getPoClass()));
    }

    public static String fetchSelfOrderSql(String querySql, Map<String, Object> filterMap) {
        String sortField;
        String selfOrderBy = StringBaseOpt.objectToString((Object)filterMap.get("ORDER_BY"));
        if (StringUtils.isBlank((CharSequence)selfOrderBy) && StringUtils.isNotBlank((CharSequence)(sortField = StringBaseOpt.objectToString((Object)filterMap.get("sort")))) && (sortField = DatabaseOptUtils.mapFieldToColumnPiece(querySql, sortField)) != null) {
            selfOrderBy = sortField;
            String sOrder = StringBaseOpt.objectToString((Object)filterMap.get("order"));
            if ("desc".equalsIgnoreCase(sOrder)) {
                selfOrderBy = sortField + " desc";
            }
        }
        return selfOrderBy;
    }

    public JSONArray listObjectsAsJson(Map<String, Object> filterMap, Collection<String> filters, PageDesc pageDesc) {
        String querySql = this.getFilterQuerySql();
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        Pair q = GeneralJsonObjectDao.buildFieldSqlWithFieldName((TableInfo)mapInfo, null);
        String selfOrderBy = BaseDaoImpl.fetchSelfOrderSql(querySql, filterMap);
        if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
            querySql = QueryUtils.removeOrderBy((String)querySql) + " order by " + selfOrderBy;
        }
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, filters, filterMap, (boolean)false);
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            return DatabaseOptUtils.listObjectsBySqlAsJson(this, qap.getQuery(), (String[])q.getRight(), QueryUtils.buildGetCountSQLByReplaceFields((String)qap.getQuery()), qap.getParams(), pageDesc);
        }
        return DatabaseOptUtils.listObjectsBySqlAsJson(this, qap.getQuery(), (String[])q.getRight(), qap.getParams());
    }

    public JSONArray listObjectsAsJson(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.listObjectsAsJson(filterMap, null, pageDesc);
    }

    public JSONArray listObjectsByFilterAsJson(String whereSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        Pair fieldsDesc = GeneralJsonObjectDao.buildFieldSqlWithFieldName((TableInfo)mapInfo, null);
        String querySql = "select " + (String)fieldsDesc.getLeft() + " from " + mapInfo.getTableName() + " " + whereSql;
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            return DatabaseOptUtils.listObjectsBySqlAsJson(this, querySql, (String[])fieldsDesc.getRight(), QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), namedParams, pageDesc);
        }
        return DatabaseOptUtils.listObjectsBySqlAsJson(this, querySql, (String[])fieldsDesc.getRight(), namedParams);
    }

    public JSONArray listObjectsByFilterAsJson(String whereSql, Object[] params, PageDesc pageDesc) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(this.getPoClass());
        Pair fieldsDesc = GeneralJsonObjectDao.buildFieldSqlWithFieldName((TableInfo)mapInfo, null);
        String querySql = "select " + (String)fieldsDesc.getLeft() + " from " + mapInfo.getTableName() + " " + whereSql;
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            return DatabaseOptUtils.listObjectsBySqlAsJson(this, querySql, (String[])fieldsDesc.getRight(), QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), params, pageDesc);
        }
        return DatabaseOptUtils.listObjectsBySqlAsJson(this, querySql, params, (String[])fieldsDesc.getRight());
    }
}

