/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jdbc.dao;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.support.algorithm.ListOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.PersistenceException;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryAndParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

public abstract class DatabaseOptUtils {
    protected static Logger logger = LoggerFactory.getLogger(DatabaseOptUtils.class);

    public static Object callFunction(BaseDaoImpl<?, ?> baseDao, String procName, int sqlType, Object ... paramObjs) {
        try {
            return baseDao.getJdbcTemplate().execute(conn -> DatabaseAccess.callFunction((Connection)conn, (String)procName, (int)sqlType, (Object[])paramObjs));
        }
        catch (DataAccessException e) {
            throw new PersistenceException(8, (Throwable)e);
        }
    }

    public static final boolean callProcedure(BaseDaoImpl<?, ?> baseDao, String procName, Object ... paramObjs) {
        try {
            return (Boolean)baseDao.getJdbcTemplate().execute(conn -> DatabaseAccess.callProcedure((Connection)conn, (String)procName, (Object[])paramObjs));
        }
        catch (DataAccessException e) {
            throw new PersistenceException(8, (Throwable)e);
        }
    }

    public static final boolean doExecuteSql(BaseDaoImpl<?, ?> baseDao, String sSql) throws SQLException {
        baseDao.getJdbcTemplate().execute(sSql);
        return true;
    }

    public static final int doExecuteSql(BaseDaoImpl<?, ?> baseDao, String sSql, Object[] values) throws SQLException {
        return baseDao.getJdbcTemplate().update(sSql, values);
    }

    public static final int doExecuteNamedSql(BaseDaoImpl<?, ?> baseDao, String sSql, Map<String, Object> values) throws SQLException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams((QueryAndNamedParams)new QueryAndNamedParams(sSql, values));
        return DatabaseOptUtils.doExecuteSql(baseDao, qap.getQuery(), qap.getParams());
    }

    public static String mapFieldToColumnPiece(String querySql, String fieldName) {
        List fields = QueryUtils.getSqlFieldNamePieceMap((String)querySql);
        for (Pair field : fields) {
            if (!fieldName.equalsIgnoreCase((String)field.getLeft()) && !fieldName.equals(DatabaseAccess.mapColumnNameToField((String)((String)field.getKey()))) && !fieldName.equalsIgnoreCase((String)field.getRight())) continue;
            return (String)field.getRight();
        }
        return null;
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return (JSONArray)baseDao.getJdbcTemplate().execute(conn -> {
            try {
                pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)queryCountSql, (Map)namedParams)));
                return DatabaseAccess.findObjectsByNamedSqlAsJSON((Connection)conn, (String)querySql, (Map)namedParams, (String[])fieldNames, (int)pageDesc.getPageNo(), (int)pageDesc.getPageSize());
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, Map<String, Object> namedParams, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, querySql, fieldNames, QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), namedParams, pageDesc);
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, Map<String, Object> namedParams) {
        return (JSONArray)baseDao.getJdbcTemplate().execute(conn -> {
            try {
                return DatabaseAccess.findObjectsByNamedSqlAsJSON((Connection)conn, (String)querySql, (Map)namedParams, (String[])fieldNames);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, querySql, null, queryCountSql, namedParams, pageDesc);
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> params) {
        return (JSONArray)baseDao.getJdbcTemplate().execute(conn -> {
            try {
                return DatabaseAccess.findObjectsByNamedSqlAsJSON((Connection)conn, (String)querySql, (Map)params);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> namedParams, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, querySql, null, QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), namedParams, pageDesc);
        }
        return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, querySql, namedParams);
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, String queryCountSql, Object[] params, PageDesc pageDesc) {
        return (JSONArray)baseDao.getJdbcTemplate().execute(conn -> {
            try {
                pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)queryCountSql, (Object[])params)));
                return DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)querySql, (Object[])params, (String[])fieldNames, (int)pageDesc.getPageNo(), (int)pageDesc.getPageSize());
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, Object[] params) {
        return (JSONArray)baseDao.getJdbcTemplate().execute(conn -> {
            try {
                return DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)querySql, (Object[])params, (String[])fieldNames);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String queryCountSql, Object[] params, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, querySql, null, queryCountSql, params, pageDesc);
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Object[] params, String[] fieldnames) {
        return (JSONArray)baseDao.getJdbcTemplate().execute(conn -> {
            try {
                return DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)querySql, (Object[])params, (String[])fieldnames);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Object[] params) {
        return (JSONArray)baseDao.getJdbcTemplate().execute(conn -> {
            try {
                return DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)querySql, (Object[])params);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Object[] params, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, querySql, QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), params, pageDesc);
        }
        return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, querySql, params);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, namedParams);
        Map paramsMap = qap.getParams();
        QueryAndNamedParams countQap = QueryUtils.translateQuery((String)queryCountSql, namedParams);
        paramsMap.putAll(countQap.getParams());
        return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, qap.getQuery(), fieldNames, countQap.getQuery(), paramsMap, pageDesc);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, Map<String, Object> namedParams, PageDesc pageDesc) {
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, namedParams);
        return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, qap.getQuery(), fieldNames, QueryUtils.buildGetCountSQLByReplaceFields((String)qap.getQuery()), qap.getParams(), pageDesc);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String[] fieldNames, Map<String, Object> namedParams) {
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, namedParams);
        return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, qap.getQuery(), fieldNames, qap.getParams());
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsByParamsDriverSqlAsJson(baseDao, querySql, null, queryCountSql, namedParams, pageDesc);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> namedParams) {
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, namedParams);
        return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, qap.getQuery(), qap.getParams());
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> namedParams, PageDesc pageDesc) {
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, namedParams);
        return DatabaseOptUtils.listObjectsBySqlAsJson(baseDao, qap.getQuery(), qap.getParams(), pageDesc);
    }

    public static JSONObject getObjectBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Object[] params, String[] fieldName) {
        return (JSONObject)baseDao.getJdbcTemplate().execute(conn -> {
            try {
                return DatabaseAccess.getObjectAsJSON((Connection)conn, (String)querySql, (Object[])params, (String[])fieldName);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONObject getObjectBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Object[] params) {
        return DatabaseOptUtils.getObjectBySqlAsJson(baseDao, querySql, params, null);
    }

    public static JSONObject getObjectBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> params, String[] fieldName) {
        return (JSONObject)baseDao.getJdbcTemplate().execute(conn -> {
            try {
                return DatabaseAccess.getObjectAsJSON((Connection)conn, (String)querySql, (Map)params, (String[])fieldName);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONObject getObjectBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql, Map<String, Object> params) {
        return DatabaseOptUtils.getObjectBySqlAsJson(baseDao, querySql, params, null);
    }

    public <T> T getObjectCascadeById(BaseDaoImpl<?, ?> baseDao, Object id, Class<T> type) {
        return (T)baseDao.getJdbcTemplate().execute(conn -> OrmDaoUtils.getObjectCascadeById((Connection)conn, (Object)id, (Class)type));
    }

    public <T> T getObjectCascadeShallowById(BaseDaoImpl<?, ?> baseDao, Object id, Class<T> type) {
        return (T)baseDao.getJdbcTemplate().execute(conn -> OrmDaoUtils.getObjectCascadeShallowById((Connection)conn, (Object)id, (Class)type));
    }

    public <T> T fetchObjectReference(BaseDaoImpl<?, ?> baseDao, T o, String columnName) {
        return (T)baseDao.getJdbcTemplate().execute(conn -> OrmDaoUtils.fetchObjectReference((Connection)conn, (Object)o, (String)columnName));
    }

    public <T> T fetchObjectReferences(BaseDaoImpl<?, ?> baseDao, T o) {
        return (T)baseDao.getJdbcTemplate().execute(conn -> OrmDaoUtils.fetchObjectReferences((Connection)conn, (Object)o));
    }

    public <T> Integer saveObjectReference(BaseDaoImpl<?, ?> baseDao, T o, String columnName) {
        return (Integer)baseDao.getJdbcTemplate().execute(conn -> OrmDaoUtils.saveObjectReference((Connection)conn, (Object)o, (String)columnName));
    }

    public <T> Integer saveObjectReferences(BaseDaoImpl<?, ?> baseDao, T o) {
        return (Integer)baseDao.getJdbcTemplate().execute(conn -> OrmDaoUtils.saveObjectReferences((Connection)conn, (Object)o));
    }

    public static JSONObject getObjectBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String querySql) {
        return (JSONObject)baseDao.getJdbcTemplate().execute(conn -> {
            try {
                return DatabaseAccess.getObjectAsJSON((Connection)conn, (String)querySql);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static Object getScalarObjectQuery(BaseDaoImpl<?, ?> baseDao, String sSql, Map<String, Object> values) {
        return baseDao.getJdbcTemplate().execute(conn -> {
            try {
                return DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)sSql, (Map)values);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static Object getScalarObjectQuery(BaseDaoImpl<?, ?> baseDao, String sSql, Object[] values) {
        return baseDao.getJdbcTemplate().execute(conn -> {
            try {
                return DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)sSql, (Object[])values);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static Object getScalarObjectQuery(BaseDaoImpl<?, ?> baseDao, String sSql) throws SQLException, IOException {
        return baseDao.getJdbcTemplate().execute(conn -> {
            try {
                return DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)sSql);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static Object getScalarObjectQuery(BaseDaoImpl<?, ?> baseDao, String sSql, Object value) throws SQLException, IOException {
        return baseDao.getJdbcTemplate().execute(conn -> {
            try {
                return DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)sSql, (Object)value);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static Long getSequenceNextValue(BaseDaoImpl<?, ?> baseDao, String sequenceName) {
        return (Long)baseDao.getJdbcTemplate().execute(conn -> OrmDaoUtils.getSequenceNextValue((Connection)conn, (String)sequenceName));
    }

    public static int batchSaveNewObjects(BaseDaoImpl<?, ?> baseDao, Collection<? extends Object> objects) {
        return (Integer)baseDao.getJdbcTemplate().execute(conn -> {
            int successSaved = 0;
            for (Object o : objects) {
                successSaved += OrmDaoUtils.saveNewObject((Connection)conn, o);
            }
            return successSaved;
        });
    }

    public static int batchUpdateObjects(BaseDaoImpl<?, ?> baseDao, Collection<? extends Object> objects) {
        return (Integer)baseDao.getJdbcTemplate().execute(conn -> {
            int successUpdated = 0;
            for (Object o : objects) {
                successUpdated += OrmDaoUtils.updateObject((Connection)conn, o);
            }
            return successUpdated;
        });
    }

    public static int batchMergeObjects(BaseDaoImpl<?, ?> baseDao, Collection<? extends Object> objects) {
        return (Integer)baseDao.getJdbcTemplate().execute(conn -> {
            int successMerged = 0;
            for (Object o : objects) {
                successMerged += OrmDaoUtils.mergeObject((Connection)conn, o);
            }
            return successMerged;
        });
    }

    public static int batchDeleteObjects(BaseDaoImpl<?, ?> baseDao, Collection<? extends Object> objects) {
        return (Integer)baseDao.getJdbcTemplate().execute(conn -> {
            int successDeleted = 0;
            for (Object o : objects) {
                successDeleted += OrmDaoUtils.deleteObject((Connection)conn, o);
            }
            return successDeleted;
        });
    }

    public <T> Integer batchUpdateObject(BaseDaoImpl<?, ?> baseDao, Collection<String> fields, T object, Map<String, Object> properties) {
        return (Integer)baseDao.getJdbcTemplate().execute(conn -> OrmDaoUtils.batchUpdateObject((Connection)conn, (Collection)fields, (Object)object, (Map)properties));
    }

    public <T> Integer batchUpdateObject(BaseDaoImpl<?, ?> baseDao, String[] fields, T object, Map<String, Object> properties) {
        return this.batchUpdateObject(baseDao, ListOpt.arrayToList((Object[])fields), object, properties);
    }

    public static Integer batchUpdateObject(BaseDaoImpl<?, ?> baseDao, Class<?> type, Map<String, Object> propertiesValue, Map<String, Object> propertiesFilter) {
        return (Integer)baseDao.getJdbcTemplate().execute(conn -> OrmDaoUtils.batchUpdateObject((Connection)conn, (Class)type, (Map)propertiesValue, (Map)propertiesFilter));
    }
}

