/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jdbc.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.support.database.ddl.DDLOperations;
import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDLOperationsWork
implements DDLOperations {
    protected static Logger logger = LoggerFactory.getLogger(DDLOperations.class);
    private BaseDaoImpl<?, ?> baseDao;
    private DDLOperations operations = null;

    public DDLOperationsWork() {
    }

    public DDLOperationsWork(BaseDaoImpl<?, ?> baseDao) {
        this.baseDao = baseDao;
    }

    public void setBaseDao(BaseDaoImpl<?, ?> baseDao) {
        this.baseDao = baseDao;
    }

    public DDLOperations getDDLOperations() throws SQLException {
        if (this.operations == null) {
            this.operations = GeneralDDLOperations.createDDLOperations((Connection)this.baseDao.getConnection());
        }
        return this.operations;
    }

    public void createSequence(String sequenceName) throws SQLException {
        this.getDDLOperations().createSequence(sequenceName);
    }

    public void createTable(TableInfo tableInfo) throws SQLException {
        this.getDDLOperations().createTable(tableInfo);
    }

    public void dropTable(String tableCode) throws SQLException {
        this.getDDLOperations().dropTable(tableCode);
    }

    public void addColumn(String tableCode, TableField column) throws SQLException {
        this.getDDLOperations().addColumn(tableCode, column);
    }

    public void modifyColumn(String tableCode, TableField oldColumn, TableField column) throws SQLException {
        this.getDDLOperations().modifyColumn(tableCode, oldColumn, column);
    }

    public void dropColumn(String tableCode, String columnCode) throws SQLException {
        this.getDDLOperations().dropColumn(tableCode, columnCode);
    }

    public void renameColumn(String tableCode, String columnCode, TableField column) throws SQLException {
        this.getDDLOperations().renameColumn(tableCode, columnCode, column);
    }

    public void reconfigurationColumn(String tableCode, String columnCode, TableField column) throws SQLException {
        this.getDDLOperations().reconfigurationColumn(tableCode, columnCode, column);
    }

    public String makeCreateSequenceSql(String sequenceName) {
        try {
            return this.getDDLOperations().makeCreateSequenceSql(sequenceName);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String makeCreateTableSql(TableInfo tableInfo) {
        try {
            return this.getDDLOperations().makeCreateTableSql(tableInfo);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String makeDropTableSql(String tableCode) {
        try {
            return this.getDDLOperations().makeDropTableSql(tableCode);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String makeAddColumnSql(String tableCode, TableField column) {
        try {
            return this.getDDLOperations().makeAddColumnSql(tableCode, column);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String makeModifyColumnSql(String tableCode, TableField oldColumn, TableField column) {
        try {
            return this.getDDLOperations().makeModifyColumnSql(tableCode, oldColumn, column);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String makeDropColumnSql(String tableCode, String columnCode) {
        try {
            return this.getDDLOperations().makeDropColumnSql(tableCode, columnCode);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String makeRenameColumnSql(String tableCode, String columnCode, TableField column) {
        try {
            return this.getDDLOperations().makeRenameColumnSql(tableCode, columnCode, column);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public List<String> makeReconfigurationColumnSqls(String tableCode, String columnCode, TableField column) {
        try {
            return this.getDDLOperations().makeReconfigurationColumnSqls(tableCode, columnCode, column);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
            return null;
        }
    }
}

