/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.mybatis.config;

import com.centit.framework.core.config.DataSourceConfig;
import com.centit.framework.mybatis.dao.BaseDaoSupport;
import com.centit.framework.mybatis.plugin.ParameterDriverSqlInterceptor;
import com.centit.support.algorithm.StringRegularOpt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.logging.stdout.StdOutImpl;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableTransactionManagement(proxyTargetClass=true)
@Lazy
public class MybatisConfig
extends DataSourceConfig {
    @Bean
    public SqlSessionFactoryBean sqlSessionFactory(@Autowired DataSource dataSource) throws IOException {
        SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        Configuration configuration = new Configuration();
        configuration.setLazyLoadingEnabled(true);
        configuration.setSafeRowBoundsEnabled(false);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setAggressiveLazyLoading(false);
        if (StringRegularOpt.isTrue((String)this.env.getProperty("jdbc.show.sql"))) {
            configuration.setLogImpl(StdOutImpl.class);
        }
        configuration.addInterceptor((Interceptor)new ParameterDriverSqlInterceptor());
        Properties properties = new Properties();
        properties.setProperty("Oracle", "oracle");
        properties.setProperty("DB2", "db2");
        properties.setProperty("MySQL", "mysql");
        properties.setProperty("SQL Server", "sqlserver");
        properties.setProperty("H2", "h2");
        properties.setProperty("PostgreSQL", "postgresql");
        VendorDatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        databaseIdProvider.setProperties(properties);
        sessionFactory.setDataSource(dataSource);
        sessionFactory.setConfiguration(configuration);
        sessionFactory.setDatabaseIdProvider((DatabaseIdProvider)databaseIdProvider);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        String fileMatch = this.env.getProperty("mybatis.map.xml.filematch");
        String[] fileMatchs = fileMatch.split(",");
        ArrayList<Resource> fileMatchList = new ArrayList<Resource>(256);
        for (String fm : fileMatchs) {
            Resource[] resources = resolver.getResources(fm);
            if (resources == null) continue;
            for (Resource obj : resources) {
                fileMatchList.add(obj);
            }
        }
        Resource[] resources = new Resource[fileMatchList.size()];
        sessionFactory.setMapperLocations(fileMatchList.toArray(resources));
        return sessionFactory;
    }

    @Bean
    public MapperScannerConfigurer mapperScannerConfigurer() throws IOException {
        MapperScannerConfigurer configuerer = new MapperScannerConfigurer();
        configuerer.setBasePackage("com.centit");
        configuerer.setAnnotationClass(Repository.class);
        configuerer.setSqlSessionFactoryBeanName("sqlSessionFactory");
        return configuerer;
    }

    @Bean
    @DependsOn(value={"flyway"})
    public DataSourceTransactionManager transactionManager(DataSource dataSource) {
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager();
        transactionManager.setDataSource(dataSource);
        return transactionManager;
    }

    @Bean
    public PersistenceExceptionTranslationPostProcessor persistenceExceptionTranslationPostProcessor() {
        return new PersistenceExceptionTranslationPostProcessor();
    }

    @Bean
    public BaseDaoSupport baseDaoSupport(@Autowired SqlSessionFactory sqlSessionFactory) {
        BaseDaoSupport baseDaoSupport = new BaseDaoSupport();
        baseDaoSupport.setSqlSessionFactory(sqlSessionFactory);
        return baseDaoSupport;
    }
}

