/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.appclient;

import com.centit.framework.appclient.AppSession;
import com.centit.framework.common.ResponseJSON;
import com.centit.support.network.HttpExecutor;
import java.io.IOException;
import java.util.List;
import org.apache.http.impl.client.CloseableHttpClient;

public class RestfulHttpRequest {
    public static ResponseJSON getResponseData(String httpGetUrl) {
        CloseableHttpClient httpClient = HttpExecutor.createHttpClient();
        ResponseJSON resJson = RestfulHttpRequest.getResponseData(httpClient, httpGetUrl);
        try {
            httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resJson;
    }

    public static ResponseJSON getResponseData(CloseableHttpClient httpclient, String httpGetUrl) {
        ResponseJSON resJson = null;
        try {
            resJson = ResponseJSON.valueOfJson(HttpExecutor.simpleGet((CloseableHttpClient)httpclient, (String)httpGetUrl, (String)""));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resJson;
    }

    public static <T> List<T> getResponseObjectList(CloseableHttpClient httpClient, String httpGetUrl, Class<T> clazz) {
        try {
            ResponseJSON resJson = RestfulHttpRequest.getResponseData(httpClient, httpGetUrl);
            if (resJson == null) {
                return null;
            }
            return resJson.getDataAsArray(clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T getResponseObject(CloseableHttpClient httpClient, String httpGetUrl, Class<T> clazz) {
        try {
            ResponseJSON resJson = RestfulHttpRequest.getResponseData(httpClient, httpGetUrl);
            if (resJson == null) {
                return null;
            }
            return resJson.getDataAsObject(clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> getResponseObjectList(AppSession appSession, String httpGetUrl, Class<T> clazz) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.getHttpClient();
            List<T> list = RestfulHttpRequest.getResponseObjectList(httpClient, appSession.completeQueryUrl(httpGetUrl), clazz);
            return list;
        }
        catch (Exception e) {
            List<T> list = null;
            return list;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getResponseObject(AppSession appSession, String httpGetUrl, Class<T> clazz) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.getHttpClient();
            T t = RestfulHttpRequest.getResponseObject(httpClient, appSession.completeQueryUrl(httpGetUrl), clazz);
            return t;
        }
        catch (Exception e) {
            T t = null;
            return t;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseJSON getResponseData(AppSession appSession, String httpGetUrl) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.getHttpClient();
            ResponseJSON responseJSON = RestfulHttpRequest.getResponseData(httpClient, appSession.completeQueryUrl(httpGetUrl));
            return responseJSON;
        }
        catch (Exception e) {
            ResponseJSON responseJSON = null;
            return responseJSON;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }
}

