/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.common;

import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysParametersUtils {
    private static final Logger logger = LoggerFactory.getLogger(SysParametersUtils.class);
    private static Properties prop;

    public static String getAppHome() {
        return SysParametersUtils.getParameters(Parameter.APP_HOME);
    }

    public static String getTempHome() {
        return SysParametersUtils.getParameters(Parameter.APP_HOME) + SysParametersUtils.getParameters(Parameter.TEMP);
    }

    public static String getUploadTempHome() {
        return SysParametersUtils.getTempHome();
    }

    public static String getConfigHome() {
        return SysParametersUtils.getParameters(Parameter.APP_HOME) + "/config";
    }

    public static String getLogHome() {
        return SysParametersUtils.getParameters(Parameter.APP_HOME) + SysParametersUtils.getParameters(Parameter.LOG_HOME);
    }

    public static String getUploadHome() {
        return SysParametersUtils.getParameters(Parameter.APP_HOME) + SysParametersUtils.getParameters(Parameter.UPLOAD_HOME);
    }

    public static String getIndexHome() {
        return SysParametersUtils.getParameters(Parameter.APP_HOME) + SysParametersUtils.getParameters(Parameter.INDEX_HOME);
    }

    public static String getPublicFileHome() {
        return SysParametersUtils.getUploadHome() + SysParametersUtils.getParameters(Parameter.PUBLIC_FILE);
    }

    public static String getParameters(Parameter p) {
        return SysParametersUtils.loadProperties().getProperty(p.getValue());
    }

    public static String getStringValue(String key) {
        return SysParametersUtils.loadProperties().getProperty(key);
    }

    public static String getStringValue(String key, String defaultValue) {
        return SysParametersUtils.loadProperties().getProperty(key, defaultValue);
    }

    public static int getIntValue(String key) {
        return Integer.parseInt(SysParametersUtils.loadProperties().getProperty(key));
    }

    public static int getIntValue(String key, int defaultValue) {
        String s = SysParametersUtils.loadProperties().getProperty(key);
        if (StringRegularOpt.isNumber((String)s)) {
            return NumberBaseOpt.parseInteger((String)s, (Integer)defaultValue);
        }
        return defaultValue;
    }

    public static boolean getBoolean(String key) {
        return Boolean.parseBoolean(SysParametersUtils.getStringValue(key));
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String sValue = SysParametersUtils.getStringValue(key);
        return StringUtils.isNotBlank((CharSequence)sValue) ? Boolean.parseBoolean(sValue) : defaultValue;
    }

    public static Properties loadProperties() {
        return SysParametersUtils.loadProperties(false);
    }

    public static Properties loadProperties(boolean forceReload) {
        if (forceReload || null == prop) {
            prop = new Properties();
            try {
                InputStream resource = SysParametersUtils.class.getResourceAsStream("/system.properties");
                if (resource == null) {
                    resource = ClassLoader.getSystemResourceAsStream("/system.properties");
                }
                prop.load(resource);
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        return prop;
    }

    public static enum Parameter {
        APP_HOME("app.home"),
        LOG_HOME("dir.log"),
        UPLOAD_HOME("dir.upload"),
        PUBLIC_FILE("dir.publicfile"),
        INDEX_HOME("dir.index"),
        TEMP("dir.temp");

        private String value;

        private Parameter(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

