/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseJSON {
    private static final Logger logger = LoggerFactory.getLogger(ResponseJSON.class);
    private JSONObject resJSON;

    private ResponseJSON() {
    }

    public boolean isNull() {
        return this.resJSON == null;
    }

    public Integer getCode() {
        if (this.resJSON == null) {
            return null;
        }
        return this.resJSON.getInteger("code");
    }

    public String getMessage() {
        if (this.resJSON == null) {
            return null;
        }
        return this.resJSON.getString("message");
    }

    public Object getData() {
        if (this.resJSON == null) {
            return null;
        }
        return this.resJSON.get((Object)"data");
    }

    public String getDataAsString() {
        return JSON.toJSONString((Object)this.resJSON.get((Object)"data"));
    }

    public <T> T getDataAsObject(Class<T> clazz) {
        return (T)this.resJSON.getObject("data", clazz);
    }

    public <T> List<T> getDataAsArray(Class<T> clazz) {
        JSONArray jsonArray = this.resJSON.getJSONArray("data");
        if (jsonArray == null) {
            return null;
        }
        return jsonArray.toJavaList(clazz);
    }

    public <T> Map<String, T> convertJSONToMap(JSONObject jsonMap, Class<T> clazz) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String sKey : jsonMap.keySet()) {
            ret.put(sKey, jsonMap.getObject(sKey, clazz));
        }
        return ret;
    }

    public <T> Map<String, T> getDataAsMap(Class<T> clazz) {
        Object data = this.getData();
        if (data == null) {
            return null;
        }
        if (data instanceof JSONObject) {
            return this.convertJSONToMap((JSONObject)data, clazz);
        }
        return null;
    }

    public Object getData(String skey) {
        Object data = this.getData();
        if (data == null) {
            return null;
        }
        if (data instanceof JSONObject) {
            return ((JSONObject)data).get((Object)skey);
        }
        return null;
    }

    public String getDataAsString(String skey) {
        return JSON.toJSONString((Object)this.getData(skey));
    }

    public <T> T getDataAsObject(String sKey, Class<T> clazz) {
        Object data = this.getData();
        if (data == null) {
            return null;
        }
        if (data instanceof JSONObject) {
            return (T)((JSONObject)data).getObject(sKey, clazz);
        }
        return null;
    }

    public <T> List<T> getDataAsArray(String sKey, Class<T> clazz) {
        Object data = this.getData(sKey);
        if (data == null) {
            return null;
        }
        if (data instanceof JSONArray) {
            return ((JSONArray)data).toJavaList(clazz);
        }
        return null;
    }

    public <T> Map<String, T> getDataAsMap(String sKey, Class<T> clazz) {
        Object data = this.getData(sKey);
        if (data == null || !(data instanceof JSONObject)) {
            return null;
        }
        return this.convertJSONToMap((JSONObject)data, clazz);
    }

    public static ResponseJSON valueOfJson(String jsonStr) {
        if (jsonStr == null) {
            return null;
        }
        ResponseJSON retJson = new ResponseJSON();
        retJson.resJSON = JSON.parseObject((String)jsonStr);
        return retJson;
    }

    public JSONObject getOriginalJSON() {
        return this.resJSON;
    }
}

