/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.common;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.centit.framework.common.ResponseData;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResponseMapData
implements ResponseData {
    private int resCode;
    private String resMessage;
    private Map<String, Object> resMapData;

    public ResponseMapData() {
        this.resCode = 0;
        this.resMessage = "OK";
        this.resMapData = new LinkedHashMap<String, Object>();
    }

    public ResponseMapData(int nCode) {
        this.resCode = nCode;
        this.resMessage = nCode == 0 ? "OK" : "ERROR";
        this.resMapData = new LinkedHashMap<String, Object>();
    }

    public ResponseMapData(String message) {
        this.resCode = 0;
        this.resMessage = message;
        this.resMapData = new LinkedHashMap<String, Object>();
    }

    public ResponseMapData(int nCode, String message) {
        this.resCode = nCode;
        this.resMessage = message;
        this.resMapData = new LinkedHashMap<String, Object>();
    }

    public static ResponseMapData makeResponseData(Map<String, Object> resMapData) {
        ResponseMapData resData = new ResponseMapData();
        resData.setData(resMapData);
        return resData;
    }

    @Override
    public int getCode() {
        return this.resCode;
    }

    public void setCode(int resCode) {
        this.resCode = resCode;
    }

    @Override
    public String getMessage() {
        return this.resMessage;
    }

    public void setMessage(String resMessage) {
        this.resMessage = resMessage;
    }

    public void setResponseMessage(String resMessage) {
        this.resMessage = resMessage;
    }

    @Override
    public Map<String, Object> getData() {
        return this.resMapData;
    }

    public Map<String, Object> setData(Map<String, Object> objValue) {
        Map<String, Object> oldObj = this.resMapData;
        this.resMapData = objValue;
        return oldObj;
    }

    public void addResponseData(String sKey, Object objValue) {
        this.resMapData.put(sKey, objValue);
    }

    public Object getResponseData(String sKey) {
        return this.resMapData.get(sKey);
    }

    @Override
    public String toJSONString(PropertyPreFilter simplePropertyPreFilter) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("code", this.resCode);
        param.put("message", this.resMessage);
        if (this.resMapData != null) {
            param.put("data", this.resMapData);
        }
        if (simplePropertyPreFilter == null) {
            return JSONObject.toJSONString(param);
        }
        return JSONObject.toJSONString(param, (SerializeFilter)simplePropertyPreFilter, (SerializerFeature[])new SerializerFeature[0]);
    }

    public String toString() {
        return this.toJSONString();
    }
}

