/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.appclient;

import com.alibaba.fastjson.JSON;
import com.centit.framework.appclient.PooledHttpClientFactory;
import com.centit.framework.common.ObjectException;
import com.centit.framework.common.ResponseJSON;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.impl.client.CloseableHttpClient;

public class AppSession {
    public static final String SECURITY_CONTEXT_TOKENNAME = "accessToken";
    private String appServerUrl;
    private String userCode;
    private String password;
    private String accessToken;
    private Date tokenCheckTime;
    private boolean needAuthenticated;
    private GenericObjectPool<CloseableHttpClient> httpClientPool;

    public AppSession(String appServerUrl, boolean needAuthenticated, String userCode, String password) {
        this.appServerUrl = appServerUrl;
        this.needAuthenticated = needAuthenticated;
        this.userCode = userCode;
        this.password = password;
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        this.httpClientPool = new GenericObjectPool((PooledObjectFactory)new PooledHttpClientFactory(), config);
    }

    public AppSession(String appServerUrl, String userCode, String password) {
        this(appServerUrl, true, userCode, password);
    }

    public AppSession(String appServerUrl) {
        this(appServerUrl, false, null, null);
    }

    public AppSession() {
        this(null, false, null, null);
    }

    public boolean checkAccessToken(CloseableHttpClient httpclient) throws ClientProtocolException, ObjectException, IOException {
        boolean alive;
        if (!this.needAuthenticated) {
            return true;
        }
        boolean bl = alive = this.tokenCheckTime != null && DatetimeOpt.currentUtilDate().before(DatetimeOpt.addMinutes((Date)this.tokenCheckTime, (int)110));
        if (alive) {
            return true;
        }
        this.askAccessToken(httpclient);
        this.tokenCheckTime = DatetimeOpt.currentUtilDate();
        return true;
    }

    public void askAccessToken(CloseableHttpClient httpclient) throws ClientProtocolException, IOException, ObjectException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userCode", this.userCode);
        param.put("password", this.password);
        String jsonStr = HttpExecutor.formPost((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpclient), (String)(this.appServerUrl + "/system/mainframe/loginasclient"), param);
        ResponseJSON jsonData = ResponseJSON.valueOfJson(jsonStr);
        if (jsonData == null || jsonData.getCode() != 0) {
            throw new ObjectException(jsonData == null ? "\u8bbf\u95ee\u670d\u52a1\u5668\u5931\u8d25" : jsonData.getMessage());
        }
        this.accessToken = jsonData.getDataAsString(SECURITY_CONTEXT_TOKENNAME);
    }

    public String completeQueryUrl(String queryUrl) {
        String baseUrl;
        String string = baseUrl = queryUrl.indexOf("://") > 0 ? queryUrl : this.appServerUrl + queryUrl;
        return this.needAuthenticated ? baseUrl + (queryUrl.indexOf(63) >= 0 ? "&" : "?") + SECURITY_CONTEXT_TOKENNAME + "=" + this.accessToken : baseUrl;
    }

    public CloseableHttpClient allocHttpClient() throws Exception {
        return (CloseableHttpClient)this.httpClientPool.borrowObject();
    }

    public void releaseHttpClient(CloseableHttpClient httpClient) {
        this.httpClientPool.returnObject((Object)httpClient);
    }

    public ResponseJSON getResponseData(CloseableHttpClient httpClient, String httpGetUrl, String queryParam) throws IOException {
        return ResponseJSON.valueOfJson(HttpExecutor.simpleGet((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient), (String)this.completeQueryUrl(httpGetUrl), (String)queryParam));
    }

    public ResponseJSON getResponseData(CloseableHttpClient httpClient, String httpGetUrl) throws IOException {
        return ResponseJSON.valueOfJson(HttpExecutor.simpleGet((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient), (String)this.completeQueryUrl(httpGetUrl), (String)""));
    }

    public String formPost(CloseableHttpClient httpClient, String httpPostUrl, Object formData, boolean asPut) throws IOException {
        return HttpExecutor.formPost((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient), (String)this.completeQueryUrl(httpPostUrl), (Object)formData, (boolean)asPut);
    }

    public String formPost(CloseableHttpClient httpClient, String httpPostUrl, Object formData) throws IOException {
        return HttpExecutor.formPost((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient), (String)this.completeQueryUrl(httpPostUrl), (Object)formData, (boolean)false);
    }

    public String formPut(CloseableHttpClient httpClient, String httpPutUrl, Object formData) throws IOException {
        return HttpExecutor.formPut((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient), (String)this.completeQueryUrl(httpPutUrl), (Object)formData);
    }

    public String jsonPost(CloseableHttpClient httpClient, String httpPostUrl, Object formData, boolean asPut) throws IOException {
        return HttpExecutor.jsonPost((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient), (String)this.completeQueryUrl(httpPostUrl), (Object)formData, (boolean)asPut);
    }

    public String jsonPost(CloseableHttpClient httpClient, String httpPostUrl, Object formData) throws IOException {
        return HttpExecutor.jsonPost((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient), (String)this.completeQueryUrl(httpPostUrl), (Object)formData, (boolean)false);
    }

    public String jsonPut(CloseableHttpClient httpClient, String httpPutUrl, Object formData) throws IOException {
        String jsonString = null;
        if (formData != null) {
            jsonString = formData instanceof String ? (String)formData : JSON.toJSONString((Object)formData);
        }
        return HttpExecutor.jsonPut((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient), (String)this.completeQueryUrl(httpPutUrl), (String)jsonString);
    }

    public String doDelete(CloseableHttpClient httpClient, String httpDeleteUrl, String queryParam) throws IOException {
        return HttpExecutor.simpleDelete((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient), (String)this.completeQueryUrl(httpDeleteUrl), (String)queryParam);
    }

    public String getAppServerUrl() {
        return this.appServerUrl;
    }

    public void setAppServerUrl(String appServerUrl) {
        this.appServerUrl = appServerUrl;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isNeedAuthenticated() {
        return this.needAuthenticated;
    }

    public void setNeedAuthenticated(boolean needAuthenticated) {
        this.needAuthenticated = needAuthenticated;
    }
}

