/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.appclient;

import com.alibaba.fastjson.JSON;
import com.centit.framework.appclient.AppSession;
import com.centit.framework.common.ResponseJSON;
import java.util.List;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulHttpRequest {
    private static Logger logger = LoggerFactory.getLogger(RestfulHttpRequest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseJSON getResponseData(AppSession appSession, String httpGetUrl) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            ResponseJSON responseJSON = appSession.getResponseData(httpClient, appSession.completeQueryUrl(httpGetUrl));
            return responseJSON;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            ResponseJSON responseJSON = null;
            return responseJSON;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> getResponseObjectList(AppSession appSession, String httpGetUrl, Class<T> clazz) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            ResponseJSON resJson = appSession.getResponseData(httpClient, httpGetUrl);
            if (resJson == null) {
                List<T> list = null;
                return list;
            }
            List<T> list = resJson.getDataAsArray(clazz);
            return list;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            List<T> list = null;
            return list;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getResponseObject(AppSession appSession, String httpGetUrl, Class<T> clazz) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            ResponseJSON resJson = appSession.getResponseData(httpClient, httpGetUrl);
            if (resJson == null) {
                T t = null;
                return t;
            }
            T t = resJson.getDataAsObject(clazz);
            return t;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            T t = null;
            return t;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String jsonPost(AppSession appSession, String httpPostUrl, Object formData, boolean asPut) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            String string = appSession.jsonPost(httpClient, httpPostUrl, formData, asPut);
            return string;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    public static String jsonPost(AppSession appSession, String httpPostUrl, Object formData) {
        return RestfulHttpRequest.jsonPost(appSession, httpPostUrl, formData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String jsonPut(AppSession appSession, String httpPostUrl, Object formData) {
        String jsonString = null;
        if (formData != null) {
            jsonString = formData instanceof String ? (String)formData : JSON.toJSONString((Object)formData);
        }
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            String string = appSession.jsonPut(httpClient, httpPostUrl, jsonString);
            return string;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formPost(AppSession appSession, String httpPostUrl, Object formData, boolean asPut) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            String string = appSession.formPost(httpClient, httpPostUrl, formData, asPut);
            return string;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    public static String formPost(AppSession appSession, String httpPostUrl, Object formData) {
        return RestfulHttpRequest.formPost(appSession, httpPostUrl, formData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formPut(AppSession appSession, String httpPostUrl, Object formData) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            String string = appSession.formPut(httpClient, httpPostUrl, formData);
            return string;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doDelete(AppSession appSession, String httpDeleteUrl, String queryParam) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            String string = appSession.doDelete(httpClient, httpDeleteUrl, queryParam);
            return string;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }
}

