/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.appclient;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.StringBaseOpt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpReceiveJSON {
    private Object resObj;
    private boolean isResponseData;
    private JSONObject resJSONObject;

    private HttpReceiveJSON() {
    }

    public boolean isNull() {
        return this.resObj == null;
    }

    public boolean isJSON() {
        return this.resObj instanceof JSON;
    }

    public boolean isResponseData() {
        return this.isResponseData;
    }

    public int getCode() {
        if (this.isResponseData) {
            Integer retCode = this.resJSONObject.getInteger("code");
            return retCode == null ? 0 : retCode;
        }
        return 0;
    }

    public String getMessage() {
        return this.isResponseData ? this.resJSONObject.getString("message") : "OK";
    }

    public Object getData() {
        if (this.resObj == null) {
            return null;
        }
        return this.isResponseData ? this.resJSONObject.get((Object)"data") : this.resObj;
    }

    public String getDataAsString() {
        Object obj;
        if (this.resObj == null) {
            return null;
        }
        Object object = obj = this.isResponseData ? this.resJSONObject.get((Object)"data") : this.resObj;
        if (obj instanceof JSON) {
            return ((JSON)obj).toJSONString();
        }
        return StringBaseOpt.objectToString((Object)obj);
    }

    public <T> T getDataAsObject(Class<T> clazz) {
        Object data = this.getData();
        if (data == null) {
            return null;
        }
        if (data instanceof JSONObject) {
            return (T)JSON.toJavaObject((JSON)((JSONObject)data), clazz);
        }
        if (clazz.isAssignableFrom(data.getClass())) {
            return (T)data;
        }
        return null;
    }

    public <T> List<T> getDataAsArray(Class<T> clazz) {
        Object data = this.getData();
        if (data == null) {
            return null;
        }
        if (data instanceof JSONArray) {
            return ((JSONArray)data).toJavaList(clazz);
        }
        return null;
    }

    public static <T> Map<String, T> convertJSONToMap(JSONObject jsonMap, Class<T> clazz) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String sKey : jsonMap.keySet()) {
            ret.put(sKey, jsonMap.getObject(sKey, clazz));
        }
        return ret;
    }

    public <T> Map<String, T> getDataAsMap(Class<T> clazz) {
        Object data = this.getData();
        if (data == null) {
            return null;
        }
        if (data instanceof JSONObject) {
            return HttpReceiveJSON.convertJSONToMap((JSONObject)data, clazz);
        }
        return null;
    }

    public Object getData(String skey) {
        Object data = this.getData();
        if (data == null) {
            return null;
        }
        if (data instanceof JSONObject) {
            return ((JSONObject)data).get((Object)skey);
        }
        return null;
    }

    public String getDataAsString(String skey) {
        Object obj = this.getData(skey);
        if (obj instanceof JSON) {
            return ((JSON)obj).toJSONString();
        }
        return StringBaseOpt.objectToString((Object)obj);
    }

    public <T> T getDataAsObject(String sKey, Class<T> clazz) {
        Object data = this.getData();
        if (data == null) {
            return null;
        }
        if (data instanceof JSONObject) {
            return (T)((JSONObject)data).getObject(sKey, clazz);
        }
        return null;
    }

    public <T> List<T> getDataAsArray(String sKey, Class<T> clazz) {
        Object data = this.getData(sKey);
        if (data == null) {
            return null;
        }
        if (data instanceof JSONArray) {
            return ((JSONArray)data).toJavaList(clazz);
        }
        return null;
    }

    public <T> Map<String, T> getDataAsMap(String sKey, Class<T> clazz) {
        Object data = this.getData(sKey);
        if (data instanceof JSONObject) {
            return HttpReceiveJSON.convertJSONToMap((JSONObject)data, clazz);
        }
        return null;
    }

    public static HttpReceiveJSON valueOfJson(String jsonStr) {
        if (jsonStr == null) {
            return null;
        }
        HttpReceiveJSON recvJson = new HttpReceiveJSON();
        recvJson.resObj = JSON.parse((String)jsonStr);
        recvJson.isResponseData = false;
        if (recvJson.resObj instanceof JSONObject) {
            recvJson.resJSONObject = (JSONObject)recvJson.resObj;
            recvJson.isResponseData = recvJson.resJSONObject.containsKey((Object)"code") && recvJson.resJSONObject.containsKey((Object)"message");
        }
        return recvJson;
    }

    public JSON getOriginalJSON() {
        if (this.isJSON()) {
            return (JSON)this.resObj;
        }
        return null;
    }
}

