/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.centit.framework.common.ResponseData;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.file.FileType;
import com.centit.support.xml.XMLObject;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonResultUtils {
    private static Logger logger = LoggerFactory.getLogger(JsonResultUtils.class);
    private static final String DEFAULT_RESPONSE_CHARACTER = "UTF-8";

    private JsonResultUtils() {
    }

    public static <T> void writeOriginalResponse(String contentType, T objValue, HttpServletResponse response) {
        response.setCharacterEncoding(DEFAULT_RESPONSE_CHARACTER);
        response.setContentType(contentType);
        try {
            if (objValue instanceof String) {
                response.getWriter().write((String)objValue);
            } else {
                response.getWriter().print(objValue);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void writeOriginalJson(JSON json, HttpServletResponse response) {
        JsonResultUtils.writeOriginalResponse("application/json; charset=utf-8", json.toJSONString(), response);
    }

    public static void writeOriginalJson(String jsonValue, HttpServletResponse response) {
        JsonResultUtils.writeOriginalResponse("application/json; charset=utf-8", jsonValue, response);
    }

    public static <T> void writeOriginalHtml(T objValue, HttpServletResponse response) {
        JsonResultUtils.writeOriginalResponse("text/html; charset=utf-8", objValue, response);
    }

    public static void writeOriginalXml(String xml, HttpServletResponse response) {
        JsonResultUtils.writeOriginalResponse("text/xml; charset=utf-8", xml, response);
    }

    public static void writeOriginalImage(RenderedImage image, HttpServletResponse response) {
        response.setCharacterEncoding(DEFAULT_RESPONSE_CHARACTER);
        response.setContentType("image/gif");
        try (ServletOutputStream os = response.getOutputStream();){
            ImageIO.write(image, "gif", (OutputStream)os);
            os.flush();
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void writeOriginalFile(InputStream is, String fileName, HttpServletResponse response) {
        response.setCharacterEncoding(DEFAULT_RESPONSE_CHARACTER);
        response.setContentType(FileType.getFileMimeType((String)fileName));
        response.setHeader("Content-Disposition", "attachment; filename=" + StringEscapeUtils.escapeHtml4((String)fileName));
        try (ServletOutputStream out = response.getOutputStream();
             BufferedOutputStream bufferOut = new BufferedOutputStream((OutputStream)out);){
            int length;
            byte[] buffer = new byte[65536];
            while ((length = is.read(buffer, 0, buffer.length)) != -1) {
                bufferOut.write(buffer, 0, length);
                bufferOut.flush();
            }
        }
        catch (IOException e) {
            logger.error("\u5ba2\u6237\u7aef\u65ad\u5f00\u94fe\u63a5\uff1a" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void writeOriginalFile(File file, HttpServletResponse response) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            JsonResultUtils.writeOriginalFile(inputStream, file.getName(), response);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u6253\u5f00\u5931\u8d25\uff1a" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void writeOriginalObject(Object objValue, HttpServletResponse response) {
        if (ReflectionOpt.isScalarType(objValue.getClass())) {
            JsonResultUtils.writeOriginalResponse("text/plain; charset=utf-8", JSON.toJSONString((Object)objValue), response);
        } else {
            JsonResultUtils.writeOriginalResponse("application/json; charset=utf-8", JSON.toJSONString((Object)objValue), response);
        }
    }

    public static void writeJavaScript(String scriptValue, HttpServletResponse response) {
        JsonResultUtils.writeOriginalResponse("application/javascript; charset=utf-8", scriptValue, response);
    }

    public static void writeSingleDataJson(int code, String message, Object objValue, HttpServletResponse response, PropertyPreFilter simplePropertyPreFilter) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("code", code);
        param.put("message", message);
        if (objValue != null) {
            param.put("data", objValue);
        }
        String text = JSONObject.toJSONString(param, (SerializeFilter)simplePropertyPreFilter, (SerializerFeature[])new SerializerFeature[0]);
        JsonResultUtils.writeOriginalJson(text, response);
    }

    public static void writeSingleDataXml(int code, String message, Object objValue, HttpServletResponse response) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("code", code);
        param.put("message", message);
        if (objValue != null) {
            param.put("data", objValue);
        }
        String text = XMLObject.objectToXMLString((String)"response", param);
        JsonResultUtils.writeOriginalXml(text, response);
    }

    public static void writeResponseDataAsJson(ResponseData resData, HttpServletResponse response, PropertyPreFilter propertyPreFilter) {
        JsonResultUtils.writeSingleDataJson(resData.getCode(), resData.getMessage(), resData.getData(), response, propertyPreFilter);
    }

    public static void writeResponseDataAsJson(ResponseData resData, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson(resData.getCode(), resData.getMessage(), resData.getData(), response, null);
    }

    public static void writeResponseDataAsXml(ResponseData resData, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataXml(resData.getCode(), resData.getMessage(), resData.getData(), response);
    }

    public static void writeHttpErrorMessage(int errorCode, String errorMessage, HttpServletResponse response) {
        try {
            response.sendError(errorCode, errorMessage);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void writeErrorMessageJson(int errorCode, String errorMessage, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson(errorCode, errorMessage, null, response, null);
    }

    public static void writeMessageJson(String message, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson(0, message, null, response, null);
    }

    public static void writeMessageAndData(String message, Object objValue, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson(0, message, objValue, response, null);
    }

    public static void writeErrorMessageJson(String errorMessage, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson(500, errorMessage, null, response, null);
    }

    public static void writeBlankJson(HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson(0, "OK", null, response, null);
    }

    public static void writeSingleDataJson(Object objValue, HttpServletResponse response, PropertyPreFilter simplePropertyPreFilter) {
        JsonResultUtils.writeSingleDataJson(0, "OK", objValue, response, simplePropertyPreFilter);
    }

    public static void writeSingleDataJson(Object objValue, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson(0, "OK", objValue, response, null);
    }

    public static void writeSingleDataXml(Object objValue, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataXml(0, "OK", objValue, response);
    }

    public static void writeSingleErrorDataJson(int errorCode, String errorMessage, Object objValue, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson(errorCode, errorMessage, objValue, response, null);
    }

    public static void writeSuccessJson(HttpServletResponse response) {
        JsonResultUtils.writeBlankJson(response);
    }

    static {
        JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.DisableCircularReferenceDetect.getMask();
    }
}

