/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.appclient;

import com.alibaba.fastjson.JSON;
import com.centit.framework.appclient.AppSession;
import com.centit.framework.appclient.HttpReceiveJSON;
import com.centit.support.common.ObjectException;
import com.centit.support.network.UrlOptUtils;
import java.util.List;
import java.util.Map;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulHttpRequest {
    private static Logger logger = LoggerFactory.getLogger(RestfulHttpRequest.class);

    public static void checkHttpReceiveJSON(HttpReceiveJSON resJson) {
        if (resJson == null) {
            throw new ObjectException(500, "\u670d\u52a1\u5668\u6ca1\u6709\u8fd4\u56de\u4efb\u4f55\u6570\u636e!");
        }
        if (resJson.getCode() != 0) {
            throw new ObjectException(resJson.getData(), resJson.getCode(), resJson.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpReceiveJSON getResponseData(AppSession appSession, String httpGetUrl) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            HttpReceiveJSON httpReceiveJSON = appSession.getResponseData(httpClient, appSession.completeQueryUrl(httpGetUrl));
            return httpReceiveJSON;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            HttpReceiveJSON httpReceiveJSON = null;
            return httpReceiveJSON;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> getResponseObjectList(AppSession appSession, String httpGetUrl, Class<T> clazz) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            HttpReceiveJSON resJson = appSession.getResponseData(httpClient, httpGetUrl);
            RestfulHttpRequest.checkHttpReceiveJSON(resJson);
            List<T> list = resJson.getDataAsArray(clazz);
            return list;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            List<T> list = null;
            return list;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getResponseObject(AppSession appSession, String httpGetUrl, Class<T> clazz) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            HttpReceiveJSON resJson = appSession.getResponseData(httpClient, httpGetUrl);
            RestfulHttpRequest.checkHttpReceiveJSON(resJson);
            T t = resJson.getDataAsObject(clazz);
            return t;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            T t = null;
            return t;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    public static HttpReceiveJSON getResponseData(AppSession appSession, String httpGetUrl, Map<String, Object> queryParam) {
        return RestfulHttpRequest.getResponseData(appSession, UrlOptUtils.appendParamsToUrl((String)httpGetUrl, queryParam));
    }

    public static <T> List<T> getResponseObjectList(AppSession appSession, String httpGetUrl, Map<String, Object> queryParam, Class<T> clazz) {
        return RestfulHttpRequest.getResponseObjectList(appSession, UrlOptUtils.appendParamsToUrl((String)httpGetUrl, queryParam), clazz);
    }

    public static <T> T getResponseObject(AppSession appSession, String httpGetUrl, Map<String, Object> queryParam, Class<T> clazz) {
        return RestfulHttpRequest.getResponseObject(appSession, UrlOptUtils.appendParamsToUrl((String)httpGetUrl, queryParam), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String jsonPost(AppSession appSession, String httpPostUrl, Object formData, boolean asPut) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            String string = appSession.jsonPost(httpClient, httpPostUrl, formData, asPut);
            return string;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    public static String jsonPost(AppSession appSession, String httpPostUrl, Object formData) {
        return RestfulHttpRequest.jsonPost(appSession, httpPostUrl, formData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String jsonPut(AppSession appSession, String httpPostUrl, Object formData) {
        String jsonString = null;
        if (formData != null) {
            jsonString = formData instanceof String ? (String)formData : JSON.toJSONString((Object)formData);
        }
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            String string = appSession.jsonPut(httpClient, httpPostUrl, jsonString);
            return string;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formPost(AppSession appSession, String httpPostUrl, Object formData, boolean asPut) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            String string = appSession.formPost(httpClient, httpPostUrl, formData, asPut);
            return string;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    public static String formPost(AppSession appSession, String httpPostUrl, Object formData) {
        return RestfulHttpRequest.formPost(appSession, httpPostUrl, formData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formPut(AppSession appSession, String httpPostUrl, Object formData) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            String string = appSession.formPut(httpClient, httpPostUrl, formData);
            return string;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doDelete(AppSession appSession, String httpDeleteUrl) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            String string = appSession.doDelete(httpClient, httpDeleteUrl);
            return string;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doDelete(AppSession appSession, String httpDeleteUrl, Map<String, Object> queryParam) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = appSession.allocHttpClient();
            appSession.checkAccessToken(httpClient);
            String string = appSession.doDelete(httpClient, httpDeleteUrl, queryParam);
            return string;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                appSession.releaseHttpClient(httpClient);
            }
        }
    }
}

