/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.dubbo.config;

import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:system.properties"})
public class DubboClientConfig {
    @Value(value="${centit.dubbo.consumer.nacos.url:nacos://192.168.134.10:8848}")
    private String nacosUrl;
    @Value(value="${centit.dubbo.consumer.app.name:centit-consumer}")
    private String appName;
    @Value(value="${centit.dubbo.consumer.check:false}")
    private Boolean check;
    @Value(value="${centit.dubbo.consumer.retries:0}")
    private Integer retries;

    @Bean
    public ApplicationConfig applicationConfig() {
        ApplicationConfig applicationConfig = new ApplicationConfig();
        applicationConfig.setName(this.appName);
        return applicationConfig;
    }

    @Bean
    public RegistryConfig registryConfig() {
        RegistryConfig registryConfig = new RegistryConfig();
        registryConfig.setAddress(this.nacosUrl);
        return registryConfig;
    }

    @Bean
    public ConsumerConfig consumerConfig() {
        ConsumerConfig consumerConfig = new ConsumerConfig();
        consumerConfig.setCheck(this.check);
        consumerConfig.setRetries(this.retries);
        return consumerConfig;
    }
}

