/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.dubbo.config;

import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:system.properties"})
public class DubboServiceConfig {
    Logger logger = LoggerFactory.getLogger(DubboServiceConfig.class);
    @Value(value="${centit.dubbo.nacos.url:nacos://192.168.134.10:8848}")
    private String nacosUrl;
    @Value(value="${centit.dubbo.app.name:centit-provider}")
    private String appName;
    @Value(value="${centit.dubbo.provider.timeout:50000}")
    private Integer timeout;
    @Value(value="${centit.dubbo.dubboprotocol.name:dubbo}")
    private String dubboProtocolName;
    @Value(value="${centit.dubbo.dubboprotocol.server:}")
    private String dubboprotocolServer;
    @Value(value="${centit.dubbo.dubboprotocol.port:20885}")
    private Integer dubboprotocolPort;

    @Bean
    public ApplicationConfig applicationConfig() {
        ApplicationConfig applicationConfig = new ApplicationConfig();
        applicationConfig.setName(this.appName);
        return applicationConfig;
    }

    @Bean
    public RegistryConfig registryConfig() {
        RegistryConfig registryConfig = new RegistryConfig();
        registryConfig.setAddress(this.nacosUrl);
        return registryConfig;
    }

    @Bean
    public ProviderConfig providerConfig() {
        ProviderConfig providerConfig = new ProviderConfig();
        providerConfig.setTimeout(this.timeout);
        return providerConfig;
    }

    @Bean
    public ProtocolConfig protocolConfig() {
        ProtocolConfig protocolConfig = new ProtocolConfig();
        protocolConfig.setName(this.dubboProtocolName);
        protocolConfig.setPort(this.dubboprotocolPort);
        protocolConfig.setServer(this.dubboprotocolServer);
        return protocolConfig;
    }
}

