/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.hibernateimpl;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.InnerMsgRecipientDao;
import com.centit.framework.system.po.InnerMsgRecipient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="innerMsgRecipientDao")
public class InnerMsgRecipientDaoImpl
extends BaseDaoImpl<InnerMsgRecipient, String>
implements InnerMsgRecipientDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("receive", "receive = :receive");
            this.filterField.put("sender", "msgCode in ( select  msgCode from InnerMsg where sender = :sender )");
            this.filterField.put("(like)msgContent", "msgCode in ( select  msgCode from InnerMsg where msgContent LIKE :msgContent )");
            this.filterField.put("(like)msgTitle", "msgCode in ( select  msgCode from InnerMsg where msgTitle LIKE :msgTitle )");
            this.filterField.put("mailType", "msgCode in ( select  msgCode from InnerMsg where mailType = :mailType )");
            this.filterField.put("mailTypeNot", "msgCode in ( select  msgCode from InnerMsg where mailType != :mailTypeNot )");
            this.filterField.put("msgStateNot", "msgState != :msgStateNot");
            this.filterField.put("innerMsgStateNot", "msgCode in ( select  msgCode from InnerMsg where msgState != :innerMsgStateNot )");
            this.filterField.put("isRecycled", "EQUAL");
            this.filterField.put("msgState", "EQUAL");
            this.filterField.put("msgType", "msgCode in ( select  msgCode from InnerMsg where msgType = :msgType )");
            this.filterField.put("ORDER BY", "msgCode desc");
        }
        return this.filterField;
    }

    @Transactional
    public void saveNewObject(InnerMsgRecipient recipient) {
        String id = DatabaseOptUtils.getNextKeyBySequence((BaseDaoImpl)this, (String)"S_RECIPIENT", (int)16);
        recipient.setId(id);
        super.saveNewObject((Serializable)recipient);
    }

    @Transactional
    public List<InnerMsgRecipient> getExchangeMsgs(String sender, String receiver) {
        String queryString = "From InnerMsgRecipient where( (msgCode in (Select msgCode from InnerMsg where sender= ? and (mailType='I' or mailType='O')) and Receive= ?) or (msgCode in (Select msgCode from InnerMsg where sender= ? and (mailType='I' or mailType='O')) and Receive= ?)) order by msgCode desc";
        List l = this.listObjects(queryString, new Object[]{sender, receiver, receiver, sender});
        return l;
    }

    public long getUnreadMessageCount(String userCode) {
        Object obj = DatabaseOptUtils.getSingleObjectByHql((BaseDaoImpl)this, (String)"select count(1) from InnerMsgRecipient re Where re.receive = ? and msgState ='U'", (Object)userCode);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            return Long.valueOf(obj.toString());
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        return 0L;
    }

    public List<InnerMsgRecipient> listUnreadMessage(String userCode) {
        String queryString = "From InnerMsgRecipient re Where re.receive = ? and re.msgState ='U'   order by re.id desc";
        return this.listObjects(queryString, userCode);
    }

    public void updateInnerMsgRecipient(InnerMsgRecipient innerMsgRecipient) {
        super.updateObject((Serializable)innerMsgRecipient);
    }

    public String getNextKey() {
        return DatabaseOptUtils.getNextValueOfSequence((BaseDaoImpl)this, (String)"S_RECIPIENT");
    }
}

