/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.hibernateimpl;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.po.FVUserOptList;
import com.centit.framework.system.po.FVUserOptMoudleList;
import com.centit.framework.system.po.OptInfo;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.po.OptMethodUrlMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="optInfoDao")
public class OptInfoDaoImpl
extends BaseDaoImpl<OptInfo, String>
implements OptInfoDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("OPTID", "EQUAL");
            this.filterField.put("OPTURL", "EQUAL");
            this.filterField.put("OPTNAME", "LIKE");
            this.filterField.put("preOptId", "EQUAL");
            this.filterField.put("NP_TOPOPT", "(preOptId is null or preOptId='0')");
            this.filterField.put("optType", "EQUAL");
            this.filterField.put("optTypes", "optType in :optTypes");
            this.filterField.put("TOPOPTID", "EQUAL");
            this.filterField.put("ISINTOOLBAR", "EQUAL");
            this.filterField.put("ORDER BY", " preOptId, orderInd");
        }
        return this.filterField;
    }

    @Transactional
    public List<OptInfo> getMenuFuncByOptUrl() {
        String hql1 = "FROM OptInfo where optUrl='...' order by orderInd ";
        List preOpts = this.listObjects(hql1);
        return preOpts;
    }

    @Transactional
    public List<FVUserOptMoudleList> getMenuFuncByUserID(String userCode, String optType) {
        String hql = "FROM FVUserOptMoudleList where isintoolbar='Y' and userCode=? and opttype = ? ORDER BY orderind";
        List ls = DatabaseOptUtils.findObjectsByHql((BaseDaoImpl)this, (String)hql, (Object[])new Object[]{userCode, optType});
        return ls;
    }

    @Transactional
    public List<String> listUserDataPowerByOptMethod(String userCode, String optId, String optMethod) {
        String sSqlsen = "select OPTSCOPECODES from F_V_USEROPTDATASCOPES where USERCODE = ? and OPTID = ? and OPTMETHOD = ?";
        List l = DatabaseOptUtils.findObjectsBySql((BaseDaoImpl)this, (String)sSqlsen, (Object[])new Object[]{userCode, optId, optMethod});
        if (l == null) {
            return null;
        }
        ArrayList<String> scopeCodes = new ArrayList<String>();
        for (Object[] obj : l) {
            scopeCodes.add(String.valueOf(obj[0]));
        }
        return scopeCodes;
    }

    @Transactional
    public List<OptInfo> getFunctionsByUserAndSuperFunctionId(String userID, String superFunctionId) {
        String[] params = null;
        String hql = "FROM FVUserOptMoudleList  where userCode=? and topoptid=? ORDER BY preOptId, orderInd";
        params = new String[]{userID, superFunctionId};
        List ls = DatabaseOptUtils.findObjectsByHql((BaseDaoImpl)this, (String)hql, (Object[])params);
        ArrayList<OptInfo> opts = new ArrayList<OptInfo>();
        for (FVUserOptMoudleList opm : ls) {
            OptInfo opt = new OptInfo();
            opt.setFormCode(opm.getFormcode());
            opt.setImgIndex(opm.getImgindex());
            opt.setIsInToolbar(opm.getIsintoolbar());
            opt.setMsgNo(opm.getMsgno());
            opt.setOptType(opm.getOpttype());
            opt.setMsgPrm(opm.getMsgprm());
            opt.setOptId(opm.getOptid());
            opt.setOptName(opm.getOptname());
            opt.setOptUrl(opm.getOpturl());
            opt.setPreOptId(opm.getPreoptid());
            opt.setTopOptId(opm.getTopoptid());
            opts.add(opt);
            System.out.print(opt.getOptType());
        }
        return opts;
    }

    @Transactional
    public List<OptMethod> getMethodByUserAndOptid(String userCode, String optid) {
        String[] params = null;
        String hql = "FROM FVUserOptList urv where urv.id.userCode=? and optid= ?";
        params = new String[]{userCode, optid};
        List ls = DatabaseOptUtils.findObjectsByHql((BaseDaoImpl)this, (String)hql, (Object[])params);
        ArrayList<OptMethod> methods = new ArrayList<OptMethod>();
        for (FVUserOptList opm : ls) {
            OptMethod method = new OptMethod();
            method.setOptCode(opm.getId().getOptcode());
            method.setOptId(opm.getOptId());
            method.setOptMethod(opm.getOptMethod());
            method.setOptName(opm.getOptName());
            methods.add(method);
        }
        return methods;
    }

    @Transactional
    public List<OptMethodUrlMap> listAllOptMethodUrlMap() {
        List listObjects = DatabaseOptUtils.findObjectsByHql((BaseDaoImpl)this, (String)"from OptMethodUrlMap");
        return listObjects;
    }

    public int countChildrenSum(String optId) {
        return (int)DatabaseOptUtils.getSingleIntByHql((BaseDaoImpl)this, (String)"select count(1) as hasChildren from OptInfo where preOptId = ?", (Object)optId);
    }

    public List<OptInfo> listObjectsByCon(String condition) {
        return this.listObjects("From OptInfo where " + condition);
    }

    public List<OptInfo> listObjectByParentOptid(String optId) {
        return this.listObjects("From OptInfo where preOptId = ?", optId);
    }

    public List<OptInfo> listMenuByTypes(String ... types) {
        HashMap<String, String[]> map = new HashMap<String, String[]>(2);
        if (types.length == 1) {
            map.put("optType", types);
        } else {
            map.put("optTypes", types);
        }
        return this.listObjects(map);
    }

    public void updateOptInfo(OptInfo optInfo) {
        super.updateObject((Serializable)optInfo);
    }

    public List<FVUserOptMoudleList> listUserAllSubMenu(String userCode, String optType) {
        String hql = "FROM FVUserOptMoudleList where userCode=? and opttype = ? ORDER BY orderind";
        List ls = DatabaseOptUtils.findObjectsByHql((BaseDaoImpl)this, (String)hql, (Object[])new Object[]{userCode, optType});
        return ls;
    }
}

