/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.hibernateimpl;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="unitInfoDao")
public class UnitInfoDaoImpl
extends BaseDaoImpl<UnitInfo, String>
implements UnitInfoDao {
    public static final Logger logger = LoggerFactory.getLogger(UnitInfoDaoImpl.class);

    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("unitCode", "EQUAL");
            this.filterField.put("UNITNAME", "LIKE");
            this.filterField.put("ISVALID", "EQUAL");
            this.filterField.put("UNITTAG", "EQUAL");
            this.filterField.put("unitWord", "EQUAL");
            this.filterField.put("parentUnit", "EQUAL");
            this.filterField.put("NP_TOPUnit", "(parentUnit is null or parentUnit='0')");
            this.filterField.put("ORDER BY", " unitOrder, unitCode ");
        }
        return this.filterField;
    }

    @Transactional
    public String getNextKey() {
        return DatabaseOptUtils.getNextValueOfSequence((BaseDaoImpl)this, (String)"S_UNITCODE");
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<UserInfo> listUnitUsers(String unitCode) {
        String sSqlsen = "select a.* from F_USERINFO a join F_USERUNIT b on(a.USERCODE=b.USERCODE) where b.UNITCODE =?";
        return DatabaseOptUtils.findObjectsBySql((BaseDaoImpl)this, (String)sSqlsen, (Object[])new Object[]{unitCode}, UserInfo.class);
    }

    @Transactional
    public void batchSave(List<UnitInfo> unitinfos) {
        for (int i = 0; i < unitinfos.size(); ++i) {
            this.saveObject((Serializable)unitinfos.get(i));
        }
    }

    @Transactional
    public void batchMerge(List<UnitInfo> unitinfos) {
        for (int i = 0; i < unitinfos.size(); ++i) {
            this.mergeObject((Serializable)unitinfos.get(i));
            if (19 != i % 20) continue;
            DatabaseOptUtils.flush((Session)this.getCurrentSession());
        }
    }

    @Transactional
    public UnitInfo getUnitByName(String name) {
        String hql;
        List list;
        if (StringUtils.isNotBlank((CharSequence)name) && (list = this.listObjects(hql = "from UnitInfo where unitName = ? or unitShortName = ? order by unitOrder asc", new Object[]{name, name})) != null && !list.isEmpty()) {
            return (UnitInfo)list.get(0);
        }
        return null;
    }

    @Transactional
    public UnitInfo getUnitByTag(String unitTag) {
        return (UnitInfo)super.getObjectByProperty("unitTag", (Object)unitTag);
    }

    @Transactional
    public UnitInfo getUnitByWord(String unitWord) {
        return (UnitInfo)super.getObjectByProperty("unitWord", (Object)unitWord);
    }

    @Transactional
    public List<UnitInfo> listSubUnits(String unitCode) {
        return super.listObjectByProperty("parentUnit", (Object)unitCode);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<UnitInfo> listSubUnitsByUnitPaht(String unitPath) {
        String hql = "from UnitInfo where unitPath like ?";
        return this.listObjects(hql, new Object[]{unitPath + "%"});
    }

    public List<String> getAllParentUnit() {
        return DatabaseOptUtils.findObjectsBySql((BaseDaoImpl)this, (String)"select distinct t.parent_unit from f_unitinfo t ");
    }

    public UnitInfo getPeerUnitByName(String unitName, String parentCode, String unitCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("unitName", unitName);
        map.put("parentUnit", parentCode);
        map.put("unitCode", unitCode);
        StringBuilder sql = new StringBuilder();
        sql.append("from UnitInfo u where u.unitName = :unitName and u.parentUnit = :parentUnit and u.unitCode <> :unitCode");
        List unitInfos = this.listObjectsByNamedHql(sql.toString(), map, -1, -1);
        if (unitInfos == null || unitInfos.size() == 0) {
            return null;
        }
        return (UnitInfo)unitInfos.get(0);
    }

    public Integer isExistsUnitByParentAndOrder(String parentUnit, long unitOrder) {
        String sql = "select count(*) as existUnit from UnitInfo u  where u.unitOrder = :unitOrder and u.parentUnit = :parentUnit ";
        Object object = DatabaseOptUtils.getSingleObjectByHql((BaseDaoImpl)this, (String)sql, (Map)QueryUtils.createSqlParamsMap((Object[])new Object[]{"unitOrder", unitOrder, "parentUnit", parentUnit}));
        return NumberBaseOpt.castObjectToInteger((Object)object);
    }

    public void updateUnit(UnitInfo unitInfo) {
        super.updateObject((Serializable)unitInfo);
    }
}

