/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.hibernateimpl;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.InnerMsgDao;
import com.centit.framework.system.po.InnerMsg;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="innerMsgDao")
public class InnerMsgDaoImpl
extends BaseDaoImpl<InnerMsg, String>
implements InnerMsgDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("msgType", "EQUAL");
            this.filterField.put("msgTitle", "LIKE");
            this.filterField.put("msgContent", "LIKE");
            this.filterField.put("msgStateNot", "msgState != :msgStateNot");
            this.filterField.put("sender", "EQUAL");
            this.filterField.put("receive", "msgCode in (select re.mInnerMsg.msgCode as msgCode from InnerMsgRecipient re Where re.receive = :receive)");
            this.filterField.put("ORDER BY", "sendDate desc");
        }
        return this.filterField;
    }

    @Transactional
    public void saveNewObject(InnerMsg o) {
        String msgCode = DatabaseOptUtils.getNextKeyBySequence((BaseDaoImpl)this, (String)"S_MSGCODE", (int)16);
        o.setMsgCode(msgCode);
        super.saveNewObject((Serializable)o);
    }

    public void updateInnerMsg(InnerMsg innerMsg) {
        super.updateObject((Serializable)innerMsg);
    }

    public String getNextKey() {
        return DatabaseOptUtils.getNextValueOfSequence((BaseDaoImpl)this, (String)"S_MSGCODE");
    }
}

