/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.hibernateimpl;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.po.FVUserOptList;
import com.centit.framework.system.po.UserInfo;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="userInfoDao")
public class UserInfoDaoImpl
extends BaseDaoImpl<UserInfo, String>
implements UserInfoDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("userCode", "LIKE");
            this.filterField.put("USERCODE_EQ", "EQUAL");
            this.filterField.put("USERNAME", "LIKE");
            this.filterField.put("ISVALID", "EQUAL");
            this.filterField.put("LOGINNAME", "LIKE");
            this.filterField.put("USERSTATE", "EQUAL");
            this.filterField.put("USERORDER", "EQUAL");
            this.filterField.put("USERTAG", "EQUAL");
            this.filterField.put("USERWORD", "EQUAL");
            this.filterField.put("byUnderUnit", "userCode in (select  id.userCode from UserUnit where id.unitCode = :byUnderUnit) ");
            this.filterField.put("queryByUnit", "userCode in (select  id.userCode from UserUnit where id.unitCode = :queryByUnit) ");
            this.filterField.put("roleCode", "userCode in (select  v.id.userCode from FVUserRoles v where v.id.roleCode = :roleCode) ");
            this.filterField.put("queryByGW", "userCode in (select  id.userCode from UserUnit where id.userStation = :queryByGW)");
            this.filterField.put("queryByXZ", "userCode in (select  id.userCode from UserUnit where id.userRank = :queryByXZ)");
            this.filterField.put("queryByRole", "userCode in (select r.id.userCode from UserRole r, RoleInfo i where r.id.roleCode = :queryByRole and r.id.roleCode = i.roleCode and i.isValid = 'T')");
            this.filterField.put("ORDER BY", "userOrder asc");
            this.filterField.put("unitCode", "userCode in (select userCode from UserUnit where unitCode in (select unitCode from UnitInfo where unitCode = :unitCode or parentUnit = :unitCode))");
        }
        return this.filterField;
    }

    @Transactional
    public String getNextKey() {
        return DatabaseOptUtils.getNextValueOfSequence((BaseDaoImpl)this, (String)"S_USERCODE");
    }

    @Transactional
    public List<FVUserOptList> getAllOptMethodByUser(String userCode) {
        String[] params = null;
        String hql = "FROM FVUserOptList urv where urv.id.userCode=?";
        params = new String[]{userCode};
        List ls = DatabaseOptUtils.findObjectsByHql((BaseDaoImpl)this, (String)hql, (Object[])params);
        return ls;
    }

    @Transactional
    public List<UserInfo> listUnderUnit(Map<String, Object> filterMap) {
        return this.listObjects(filterMap);
    }

    @Transactional
    public List<UserInfo> listUnderUnit(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.listObjects(filterMap, pageDesc);
    }

    @Transactional
    public UserInfo getUserByCode(String userCode) {
        return (UserInfo)this.getObjectById((Serializable)((Object)userCode));
    }

    @Transactional
    public UserInfo getUserByLoginName(String loginName) {
        return (UserInfo)super.getObjectByProperty("loginName", (Object)loginName);
    }

    @Transactional
    public UserInfo getUserByRegEmail(String regEmail) {
        return (UserInfo)super.getObjectByProperty("regEmail", (Object)regEmail);
    }

    @Transactional
    public UserInfo getUserByRegCellPhone(String regCellPhone) {
        return (UserInfo)super.getObjectByProperty("regCellPhone", (Object)regCellPhone);
    }

    @Transactional
    public UserInfo getUserByTag(String userTag) {
        return (UserInfo)super.getObjectByProperty("userTag", (Object)userTag);
    }

    @Transactional
    public UserInfo getUserByUserWord(String userWord) {
        return (UserInfo)super.getObjectByProperty("userWord", (Object)userWord);
    }

    @Transactional
    public UserInfo getUserByIdCardNo(String idCardNo) {
        return (UserInfo)super.getObjectByProperty("idCardNo", (Object)idCardNo);
    }

    @Transactional
    public void batchSave(List<UserInfo> userinfos) {
        for (int i = 0; i < userinfos.size(); ++i) {
            this.saveObject((Serializable)userinfos.get(i));
            if (19 != i % 20) continue;
            DatabaseOptUtils.flush((Session)this.getCurrentSession());
        }
    }

    @Transactional
    public void batchMerge(List<UserInfo> userinfos) {
        for (int i = 0; i < userinfos.size(); ++i) {
            this.mergeObject((Serializable)userinfos.get(i));
            if (19 != i % 20) continue;
            DatabaseOptUtils.flush((Session)this.getCurrentSession());
        }
    }

    public List<UserInfo> listUsersByRoleCode(String roleCode) {
        return this.listObjects(QueryUtils.createSqlParamsMap((Object[])new Object[]{"roleCode", roleCode}));
    }

    public int isLoginNameExist(String userCode, String loginName) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USERCODE <> ? and t.LOGINNAME = ?";
        Object obj = DatabaseOptUtils.getSingleObjectBySql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{StringUtils.isBlank((CharSequence)userCode) ? " " : userCode, loginName});
        Integer uc = NumberBaseOpt.castObjectToInteger((Object)obj);
        return uc;
    }

    public int isCellPhoneExist(String userCode, String cellPhone) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USERCODE <> ? and t.REGCELLPHONE = ?";
        Object obj = DatabaseOptUtils.getSingleObjectBySql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{StringUtils.isBlank((CharSequence)userCode) ? " " : userCode, cellPhone});
        Integer uc = NumberBaseOpt.castObjectToInteger((Object)obj);
        return uc;
    }

    public int isEmailExist(String userCode, String email) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USERCODE <> ? and t.REGEMAIL = ?";
        Object obj = DatabaseOptUtils.getSingleObjectBySql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{StringUtils.isBlank((CharSequence)userCode) ? " " : userCode, email});
        Integer uc = NumberBaseOpt.castObjectToInteger((Object)obj);
        return uc;
    }

    public int isAnyOneExist(String userCode, String loginName, String regPhone, String regEmail) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USERCODE != ? and (t.LOGINNAME = ? or t.REGCELLPHONE= ? or t.REGEMAIL = ?)";
        Object obj = DatabaseOptUtils.getSingleObjectBySql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{StringUtils.isBlank((CharSequence)userCode) ? "null" : userCode, StringUtils.isBlank((CharSequence)loginName) ? "null" : loginName, StringUtils.isBlank((CharSequence)regPhone) ? "null" : regPhone, StringUtils.isBlank((CharSequence)regEmail) ? "null" : regEmail});
        return NumberBaseOpt.castObjectToInteger((Object)obj);
    }

    public void updateUser(UserInfo userInfo) {
        super.updateObject((Serializable)userInfo);
    }
}

