/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.hibernateimpl;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.po.UserUnit;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="userUnitDao")
public class UserUnitDaoImpl
extends BaseDaoImpl<UserUnit, String>
implements UserUnitDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("userCode_isValid", "userCode in (select userCode from UserInfo where isValid = :userCode_isValid)");
            this.filterField.put("unitCode", "EQUAL");
            this.filterField.put("userStation", "userStation = :userStation");
            this.filterField.put("userRank", "userRank = :userRank");
            this.filterField.put("userCode", "userCode = :userCode");
            this.filterField.put("isPrimary", "EQUAL");
            this.filterField.put("unitName", "LIKE");
            this.filterField.put("(like)userName", "userCode in (select userCode from UserInfo where userName like :userName)");
            this.filterField.put("isValid", "userCode in (select userCode from UserInfo where isValid = :isValid)");
            this.filterField.put("ORDER BY", "userOrder asc");
        }
        return this.filterField;
    }

    public void updateUserUnit(UserUnit userUnit) {
        super.updateObject((Serializable)userUnit);
    }

    @Transactional
    public List<UserUnit> listUserUnitsByUserCode(String userId) {
        List ls = this.listObjects("FROM UserUnit where userCode=?", userId);
        return ls;
    }

    @Transactional
    public List<UserUnit> listObjectByUserUnit(String userCode, String unitCode) {
        List ls = this.listObjects("FROM UserUnit where userCode=? and unitCode=?", new Object[]{userCode, unitCode});
        return ls;
    }

    @Transactional
    public String getNextKey() {
        return DatabaseOptUtils.getNextValueOfSequence((BaseDaoImpl)this, (String)"S_USER_UNIT_ID");
    }

    @Transactional
    public void deleteUserUnitByUser(String userCode) {
        DatabaseOptUtils.doExecuteHql((BaseDaoImpl)this, (String)"delete UserUnit  where userCode = ? ", (Object)userCode);
    }

    @Transactional
    public void deleteUserUnitByUnit(String unitCode) {
        DatabaseOptUtils.doExecuteHql((BaseDaoImpl)this, (String)"delete UserUnit  where unitCode = ? ", (Object)unitCode);
    }

    @Transactional
    public UserUnit getPrimaryUnitByUserId(String userId) {
        List list = this.listObjects("FROM UserUnit where userCode=? and isPrimary='T'", userId);
        if (list != null && list.size() > 0) {
            return (UserUnit)list.get(0);
        }
        return null;
    }

    @Transactional
    public List<UserUnit> listUnitUsersByUnitCode(String unitCode) {
        List ls = this.listObjects("FROM UserUnit where unitCode=?", unitCode);
        return ls;
    }

    @Transactional
    public List<UserUnit> listUserUnitsByRoleAndUnit(String roleType, String roleCode, String unitCode) {
        List ls = null;
        if (unitCode != null && !"".equals(unitCode)) {
            if ("gw".equals(roleType)) {
                ls = this.listObjects("FROM UserUnit where unitCode=? and userStation=? ", new Object[]{unitCode, roleCode});
            } else if ("xz".equals(roleType)) {
                ls = this.listObjects("FROM UserUnit where unitCode=? and userRank=? ", new Object[]{unitCode, roleCode});
            }
        } else if ("gw".equals(roleType)) {
            ls = this.listObjects("FROM UserUnit where userStation=? ", roleCode);
        } else if ("xz".equals(roleType)) {
            ls = this.listObjects("FROM UserUnit where userRank=? ", roleCode);
        }
        return ls;
    }

    @Transactional
    public List<UserUnit> listUnitUsersByUnitCodeAndFilter(String unitCode, PageDesc pageDesc, Map<String, Object> filterMap) {
        String hql = "FROM UserUnit where unitCode=? ";
        if (null != filterMap && null != filterMap.get("ORDER_BY")) {
            hql = hql + "order by " + filterMap.get("ORDER_BY");
        }
        return super.listObjects(hql, (Object)unitCode, pageDesc);
    }

    @Transactional
    public void batchSave(List<UserUnit> userunits) {
        for (int i = 0; i < userunits.size(); ++i) {
            super.saveObject((Serializable)userunits.get(i));
            if (0 != i % 20) continue;
            DatabaseOptUtils.flush((Session)this.getCurrentSession());
        }
    }

    @Transactional
    public void batchMerge(List<UserUnit> userunits) {
        for (int i = 0; i < userunits.size(); ++i) {
            this.mergeObject((Serializable)userunits.get(i));
            if (19 != i % 20) continue;
            DatabaseOptUtils.flush((Session)this.getCurrentSession());
        }
    }

    public int countSubUserUnits(Map<String, Object> filterDescMap) {
        String hql = "from UserUnit where 1=1 [:(STARTWITH)unitPath | and unitCode in (select unitCode from UnitInfo where unitPath like :unitPath)][:(like)userName | and userCode in (select userCode from UserInfo where userName like :userName)]";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)hql, filterDescMap);
        Query q = this.getCurrentSession().createQuery("SELECT COUNT(*) " + QueryUtils.removeOrderBy((String)qap.getQuery()));
        Map params = qap.getParams();
        DatabaseOptUtils.setQueryParameters((Query)q, (Map)params);
        Integer total = NumberBaseOpt.castObjectToInteger((Object)q.uniqueResult());
        return total == null ? 0 : total;
    }

    public List<UserUnit> querySubUserUnits(Map<String, Object> pageQueryMap) {
        String hql = "from UserUnit where 1=1 [:(STARTWITH)unitPath | and unitCode in (select unitCode from UnitInfo where unitPath like :unitPath)][:(like)userName | and userCode in (select userCode from UserInfo where userName like :userName or loginName like :userName)]";
        int startPos = 0;
        int maxSize = 0;
        if (pageQueryMap != null) {
            startPos = NumberBaseOpt.castObjectToInteger((Object)pageQueryMap.get("startRow"));
            maxSize = NumberBaseOpt.castObjectToInteger((Object)pageQueryMap.get("maxSize"));
        }
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)hql, pageQueryMap);
        return this.listObjectsByNamedHql(qap.getQuery(), qap.getParams(), startPos, maxSize);
    }
}

