/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.hibernateimpl;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.DataDictionaryDao;
import com.centit.framework.system.po.DataDictionary;
import com.centit.framework.system.po.DataDictionaryId;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="dataDictionaryDao")
public class DataDictionaryDaoImpl
extends BaseDaoImpl<DataDictionary, DataDictionaryId>
implements DataDictionaryDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("datacode", "id.dataCode = :datacode");
            this.filterField.put("catalogcode", "id.catalogCode = :catalogcode");
            this.filterField.put("catalogCode", "id.catalogCode = :catalogCode");
            this.filterField.put("NP_system", "dataStyle = 'S'");
            this.filterField.put("dataValue", "LIKE");
            this.filterField.put("ORDER BY", "dataOrder");
        }
        return this.filterField;
    }

    public List<DataDictionary> getWholeDictionary() {
        return this.listObjects("FROM DataDictionary ORDER BY id.catalogCode, dataOrder");
    }

    @Transactional
    public List<DataDictionary> listDataDictionary(String catalogCode) {
        return this.listObjects("FROM DataDictionary WHERE id.catalogCode = ? ORDER BY dataOrder", catalogCode);
    }

    @Transactional
    public void deleteDictionary(String catalog) {
        try {
            DatabaseOptUtils.doExecuteHql((BaseDaoImpl)this, (String)"delete from DataDictionary where id.catalogCode =?", (Object)catalog);
            logger.debug("delete DataDictionary successful");
        }
        catch (RuntimeException re) {
            logger.error("delete DataDictionary failed", (Throwable)re);
            throw re;
        }
    }

    public void updateDictionary(DataDictionary dataDictionary) {
        super.updateObject((Serializable)dataDictionary);
    }
}

