/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.hibernateimpl;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.RolePowerDao;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.RolePowerId;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="rolePowerDao")
public class RolePowerDaoImpl
extends BaseDaoImpl<RolePower, RolePowerId>
implements RolePowerDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("optCode", "id.optCode = :optCode");
            this.filterField.put("roleCode", "id.roleCode = :roleCode");
        }
        return this.filterField;
    }

    @Transactional
    public void deleteRolePowersByRoleCode(String rolecode) {
        DatabaseOptUtils.doExecuteHql((BaseDaoImpl)this, (String)"DELETE FROM RolePower rp where rp.id.roleCode=?", (Object)rolecode);
    }

    @Transactional
    public void deleteRolePowersByOptCode(String optecode) {
        DatabaseOptUtils.doExecuteHql((BaseDaoImpl)this, (String)"DELETE FROM RolePower rp where rp.id.optCode=?", (Object)optecode);
    }

    @Transactional
    public List<RolePower> listRolePowersByRoleCode(String rolecode) {
        return this.listObjects("FROM RolePower rp where rp.id.roleCode=?", rolecode);
    }

    @Transactional
    public void mergeBatchObject(List<RolePower> rolePowers) {
        for (int i = 0; i < rolePowers.size(); ++i) {
            super.mergeObject((Serializable)rolePowers.get(i));
            if (0 != i % 20) continue;
            DatabaseOptUtils.flush((Session)this.getCurrentSession());
        }
    }

    public void updateRolePower(RolePower rolePower) {
        super.updateObject((Serializable)rolePower);
    }

    public void saveNewRolePower(RolePower rolePower) {
        super.saveNewObject((Serializable)rolePower);
    }
}

