/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.hibernateimpl;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.UserQueryFilterDao;
import com.centit.framework.system.po.UserQueryFilter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="userQueryFilterDao")
public class UserQueryFilterDaoImpl
extends BaseDaoImpl<UserQueryFilter, Long>
implements UserQueryFilterDao {
    public static final Logger logger = LoggerFactory.getLogger(UserQueryFilterDaoImpl.class);

    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("filterNo", "EQUAL");
            this.filterField.put("userCode", "EQUAL");
            this.filterField.put("modleCode", "EQUAL");
            this.filterField.put("filterName", "EQUAL");
            this.filterField.put("filterValue", "EQUAL");
        }
        return this.filterField;
    }

    public void mergeUserFilter(UserQueryFilter userQueryFilter) {
        super.mergeObject((Serializable)userQueryFilter);
    }

    @Transactional
    public List<UserQueryFilter> listUserQueryFilterByModle(String userCode, String modelCode) {
        return super.listObjects("From UserQueryFilter where userCode = ? and modleCode = ? order by isDefault desc , createDate desc", new Object[]{userCode, modelCode});
    }

    @Transactional
    public List<UserQueryFilter> listUserDefaultFilterByModle(String userCode, String modelCode) {
        return super.listObjects("From UserQueryFilter where userCode = ? and modleCode = ? and isDefault = 'T' order by isDefault desc , createDate desc", new Object[]{userCode, modelCode});
    }

    @Transactional
    public UserQueryFilter getUserDefaultFilterByModle(String userCode, String modelCode) {
        List uqfs = super.listObjects("From UserQueryFilter where userCode = ? and modleCode = ? and isDefault = 'T' order by isDefault desc , createDate desc", new Object[]{userCode, modelCode});
        if (uqfs == null || uqfs.size() == 0) {
            return null;
        }
        return (UserQueryFilter)uqfs.get(0);
    }

    @Transactional
    public Long getNextKey() {
        return DatabaseOptUtils.getNextLongSequence((BaseDaoImpl)this, (String)"S_FILTER_NO");
    }
}

