/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.hibernateimpl;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.po.FVUserRoles;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserRoleId;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="userRoleDao")
public class UserRoleDaoImpl
extends BaseDaoImpl<UserRole, UserRoleId>
implements UserRoleDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("roleCode", "id.roleCode = :roleCode");
            this.filterField.put("userCode", "id.userCode = :userCode");
            this.filterField.put("roleName", "LIKE");
            this.filterField.put("roleUnitCode", "id.roleCode in (select roleCode from RoleInfo where (roleType = 'P' or (roleType = 'D' and unitCode = :unitCode))");
            this.filterField.put("unitCode", "id.userCode in (select uu.userCode from UserUnit uu where uu.unitCode = :unitCode)");
            this.filterField.put("userCode_isValid", "id.userCode in (select userCode from UserInfo where isValid = :userCode_isValid)");
            this.filterField.put("ORDER BY", " id.userCode ");
            this.filterField.put("(like)userName", "id.userCode in (select userCode from UserInfo where (userName like :userName or loginName like :userName ))");
        }
        return this.filterField;
    }

    @Transactional
    public List<UserRole> listUserRoles(String userCode) {
        return super.listObjects(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode}));
    }

    @Transactional
    public List<UserRole> listRoleUsers(String roleCode) {
        return super.listObjects(CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roleCode}));
    }

    @Transactional
    public void deleteByRoleId(String roid) {
        DatabaseOptUtils.doExecuteHql((BaseDaoImpl)this, (String)"DELETE FROM UserRole WHERE id.roleCode = ?", (Object)roid);
    }

    @Transactional
    public void deleteByUserId(String usid) {
        DatabaseOptUtils.doExecuteHql((BaseDaoImpl)this, (String)"DELETE FROM UserRole WHERE id.userCode = ?", (Object)usid);
    }

    @Transactional
    public List<FVUserRoles> listUserRolesByUserCode(String userCode) {
        String sSqlsen = "from FVUserRoles v where v.id.userCode = ?";
        return DatabaseOptUtils.findObjectsByHql((BaseDaoImpl)this, (String)"from FVUserRoles v where v.id.userCode = ?", (Object[])new Object[]{userCode});
    }

    @Transactional
    public List<FVUserRoles> listRoleUsersByRoleCode(String roleCode) {
        String sSqlsen = "from FVUserRoles v where v.id.roleCode = ?";
        return DatabaseOptUtils.findObjectsByHql((BaseDaoImpl)this, (String)"from FVUserRoles v where v.id.roleCode = ?", (Object[])new Object[]{roleCode});
    }

    @Transactional
    public int pageCountUserRole(Map<String, Object> filterDescMap) {
        String sSqlsen = "select count(*) as cnt from FVUserRoles v where 1=1 [:roleCode | and v.id.roleCode = :roleCode] [:userCode | and v.id.userCode = :userCode][:obtainType | and v.obtainType = :obtainType] ";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)"select count(*) as cnt from FVUserRoles v where 1=1 [:roleCode | and v.id.roleCode = :roleCode] [:userCode | and v.id.userCode = :userCode][:obtainType | and v.obtainType = :obtainType] ", filterDescMap);
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getSingleObjectByHql((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams()));
    }

    @Transactional
    public List<FVUserRoles> pageQueryUserRole(Map<String, Object> pageQureyMap) {
        String sSqlsen = "from FVUserRoles v where 1=1 [:roleCode | and v.id.roleCode = :roleCode] [:userCode | and v.id.userCode = :userCode][:obtainType | and v.obtainType = :obtainType] ";
        int startPos = 0;
        int maxSize = 0;
        if (pageQureyMap != null) {
            startPos = NumberBaseOpt.castObjectToInteger((Object)pageQureyMap.get("startRow"));
            maxSize = NumberBaseOpt.castObjectToInteger((Object)pageQureyMap.get("maxSize"));
        }
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)"from FVUserRoles v where 1=1 [:roleCode | and v.id.roleCode = :roleCode] [:userCode | and v.id.userCode = :userCode][:obtainType | and v.obtainType = :obtainType] ", pageQureyMap);
        return DatabaseOptUtils.findObjectsByHql((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams(), (int)startPos, (int)maxSize);
    }

    public void updateUserRole(UserRole userRole) {
        super.updateObject((Serializable)userRole);
    }

    public void mergeUserRole(UserRole dbUserRole) {
        super.mergeObject((Serializable)dbUserRole);
    }
}

