package com.centit.framework.system.dao.impl;

import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.dao.CodeBook;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.OptLogDao;
import com.centit.framework.system.po.OptLog;
import com.centit.support.database.utils.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.sql.SQLException;
import java.util.*;

@Repository("optLogDao")
public class OptLogDaoImpl extends BaseDaoImpl<OptLog, Long> implements OptLogDao {

    public static final Logger logger = LoggerFactory.getLogger(OptLogDaoImpl.class);

    public Map<String, String> getFilterField() {
        if (filterField == null) {
            filterField = new HashMap<>();
            filterField.put("logId", CodeBook.EQUAL_HQL_ID);
            filterField.put("logLevel", CodeBook.LIKE_HQL_ID);
            filterField.put(CodeRepositoryUtil.USER_CODE, CodeBook.EQUAL_HQL_ID);
            filterField.put("(date)optTimeBegin", "optTime >= :optTimeBegin ");
            filterField.put("(date)optTimeEnd", "optTime < :optTimeEnd");
            filterField.put("optId", CodeBook.LIKE_HQL_ID);
            filterField.put("optCode", CodeBook.LIKE_HQL_ID);
            filterField.put("optContent", CodeBook.LIKE_HQL_ID);
            filterField.put("oldValue", CodeBook.LIKE_HQL_ID);
            filterField.put("optMethod", CodeBook.EQUAL_HQL_ID);

        }
        return filterField;
    }

    @SuppressWarnings("unchecked")
    @Transactional
    public List<String> listOptIds() {
        final String hql = "select DISTINCT f.OPT_ID from F_OPT_LOG f";

        return this.getJdbcTemplate().queryForList(hql,String.class);
    }


    @Transactional
    public Long createNewLogId(){
        return DatabaseOptUtils.getSequenceNextValue(this, "S_SYS_LOG");
    }

    @Override
    public OptLog getObjectById(Long logId) {
        return super.getObjectById(logId);
    }

    @Override
    public void deleteObjectById(Long logId) {
        super.deleteObjectById(logId);
    }

    @Override
    @Transactional
    public void mergeObject(OptLog o) {
        if (null == o.getLogId()) {
            o.setLogId(DatabaseOptUtils.getSequenceNextValue(this, "S_SYS_LOG"));
        }
       /* return */super.mergeObject(o);
    }

    @Transactional
    public void delete(Date begin, Date end) {
        String hql = "delete from F_OPT_LOG o where 1=1 ";
        List<Object> objects = new ArrayList<>();
        if (null != begin) {
            hql += "and o.optTime > ?";
            objects.add(begin);
        }
        if (null != end) {
            hql += "and o.optTime < ?";
            objects.add(end);
        }

        try {
            DatabaseOptUtils.doExecuteSql(this, hql, objects.toArray(new Object[objects.size()]));
        } catch (SQLException e) {
            throw new PersistenceException(e);
        }

    }

}
