/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.jdbcimpl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.po.FVUserOptMoudleList;
import com.centit.framework.system.po.OptInfo;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.po.OptMethodUrlMap;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="optInfoDao")
public class OptInfoDaoImpl
extends BaseDaoImpl<OptInfo, String>
implements OptInfoDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("optId", "EQUAL");
            this.filterField.put("optUrl", "EQUAL");
            this.filterField.put("optName", "LIKE");
            this.filterField.put("preOptId", "EQUAL");
            this.filterField.put("NP_TOPOPT", "(preOptId is null or preOptId='0')");
            this.filterField.put("optType", "EQUAL");
            this.filterField.put("optTypes", "optType in (:optTypes)");
            this.filterField.put("topOptId", "EQUAL");
            this.filterField.put("isInToolbar", "EQUAL");
        }
        return this.filterField;
    }

    @Transactional
    public List<OptInfo> getMenuFuncByOptUrl() {
        String hql1 = "where OPT_URL='...' order by ORDER_IND ";
        return super.listObjectsByFilter(hql1, (Object[])null);
    }

    @Transactional
    public List<FVUserOptMoudleList> getMenuFuncByUserID(String userCode, String optType) {
        String querySql = "select OPT_ID, USER_CODE, OPT_NAME, PRE_OPT_ID, FORM_CODE,OPT_URL, OPT_ROUTE, OPT_TYPE, MSG_NO, MSG_PRM, IS_IN_TOOLBAR, IMG_INDEX, TOP_OPT_ID, ORDER_IND, PAGE_TYPE from F_V_USEROPTMOUDLELIST where IS_IN_TOOLBAR = 'Y' and USER_CODE = ? and OPT_TYPE = ? order by ORDER_IND ";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)querySql, (Object[])new Object[]{userCode, optType}, FVUserOptMoudleList.class));
    }

    @Transactional
    public List<String> listUserDataPowerByOptMethod(String userCode, String optId, String optMethod) {
        String sql = "select OPT_SCOPE_CODES from F_V_USEROPTDATASCOPES where USER_CODE = ? and OPT_ID = ? and OPT_METHOD = ?";
        return this.getJdbcTemplate().queryForList(sql, new Object[]{userCode, optId, optMethod}, String.class);
    }

    @Transactional
    public List<OptInfo> getFunctionsByUserAndSuperFunctionId(String userID, String superFunctionId) {
        String sql = "select OPT_ID, PRE_OPT_ID, OPT_NAME, OPT_TYPE, FORM_CODE, OPT_ROUTE, OPT_URL, MSG_NO, MSG_PRM, IS_IN_TOOLBAR, IMG_INDEX, TOP_OPT_ID, PAGE_TYPE,ORDER_IND from F_V_USEROPTMOUDLELIST where USERCODE= :userCode and TOP_OPT_ID=:topOptId ORDER BY PRE_OPT_ID, ORDER_IND";
        return super.listObjectsBySql(sql, QueryUtils.createSqlParamsMap((Object[])new Object[]{"userCode", userID, "topOptId", superFunctionId}));
    }

    @Transactional
    public List<OptMethod> getMethodByUserAndOptid(String userCode, String optid) {
        String querySql = "select USER_CODE, OPT_CODE, OPT_NAME, OPT_ID, OPT_METHOD from F_V_USEROPTLIST where USER_CODE= ? and OPT_ID = ?";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)querySql, (Object[])new Object[]{userCode, optid}, OptMethod.class));
    }

    @Transactional
    public List<OptMethodUrlMap> listAllOptMethodUrlMap() {
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.listAllObjects((Connection)conn, OptMethodUrlMap.class));
    }

    public List<OptInfo> listObjectByParentOptid(String optId) {
        return this.listObjectsByProperty("preOptId", optId);
    }

    public int countChildrenSum(String optId) {
        return this.pageCount(QueryUtils.createSqlParamsMap((Object[])new Object[]{"preOptId", optId}));
    }

    public OptInfo getObjectById(String optId) {
        return (OptInfo)super.getObjectById((Object)optId);
    }

    public List<OptInfo> listObjectsAll() {
        return super.listObjects();
    }

    public void deleteObjectById(String optId) {
        super.deleteObjectById((Object)optId);
    }

    public List<OptInfo> listMenuByTypes(String ... types) {
        HashMap<String, String[]> map = new HashMap<String, String[]>(2);
        if (types.length == 1) {
            map.put("optType", types);
        } else {
            map.put("optTypes", types);
        }
        return this.listObjects(map);
    }

    public void updateOptInfo(OptInfo optInfo) {
        super.updateObject((Serializable)optInfo);
    }

    public List<FVUserOptMoudleList> listUserAllSubMenu(String userCode, String optType) {
        String querySql = "select OPT_ID, USER_CODE, OPT_NAME, PRE_OPT_ID, FORM_CODE,OPT_URL, OPT_ROUTE, OPT_TYPE, MSG_NO, MSG_PRM, IS_IN_TOOLBAR, IMG_INDEX, TOP_OPT_ID, ORDER_IND, PAGE_TYPE from F_V_USEROPTMOUDLELIST where USER_CODE = ? and OPT_TYPE = ? order by ORDER_IND ";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)querySql, (Object[])new Object[]{userCode, optType}, FVUserOptMoudleList.class));
    }
}

