/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.jdbcimpl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.OptLogDao;
import com.centit.framework.system.po.OptLog;
import com.centit.support.database.utils.PersistenceException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="optLogDao")
public class OptLogDaoImpl
extends BaseDaoImpl<OptLog, Long>
implements OptLogDao {
    public static final Logger logger = LoggerFactory.getLogger(OptLogDaoImpl.class);

    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("logId", "EQUAL");
            this.filterField.put("logLevel", "LIKE");
            this.filterField.put("userCode", "EQUAL");
            this.filterField.put("(date)optTimeBegin", "optTime >= :optTimeBegin ");
            this.filterField.put("(nextday)optTimeEnd", "optTime < :optTimeEnd");
            this.filterField.put("optId", "LIKE");
            this.filterField.put("optCode", "LIKE");
            this.filterField.put("optContent", "LIKE");
            this.filterField.put("oldValue", "LIKE");
            this.filterField.put("optMethod", "EQUAL");
        }
        return this.filterField;
    }

    @Transactional
    public List<String> listOptIds() {
        String hql = "select DISTINCT f.OPT_ID from F_OPT_LOG f";
        return this.getJdbcTemplate().queryForList("select DISTINCT f.OPT_ID from F_OPT_LOG f", String.class);
    }

    @Transactional
    public Long createNewLogId() {
        return DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_SYS_LOG");
    }

    public OptLog getObjectById(Long logId) {
        return (OptLog)super.getObjectById((Object)logId);
    }

    public void deleteObjectById(Long logId) {
        super.deleteObjectById((Object)logId);
    }

    @Transactional
    public void mergeObject(OptLog o) {
        if (null == o.getLogId()) {
            o.setLogId(DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_SYS_LOG"));
        }
        super.mergeObject((Serializable)o);
    }

    @Transactional
    public void delete(Date begin, Date end) {
        String hql = "delete from F_OPT_LOG o where 1=1 ";
        ArrayList<Date> objects = new ArrayList<Date>();
        if (null != begin) {
            hql = hql + "and o.optTime > ?";
            objects.add(begin);
        }
        if (null != end) {
            hql = hql + "and o.optTime < ?";
            objects.add(end);
        }
        try {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)hql, (Object[])objects.toArray(new Object[objects.size()]));
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }
}

