/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.jdbcimpl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="unitInfoDao")
public class UnitInfoDaoImpl
extends BaseDaoImpl<UnitInfo, String>
implements UnitInfoDao {
    public static final Logger logger = LoggerFactory.getLogger(UnitInfoDaoImpl.class);

    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap(10);
            this.filterField.put("unitCode", "EQUAL");
            this.filterField.put("unitName", "LIKE");
            this.filterField.put("isValid", "EQUAL");
            this.filterField.put("UNITTAG", "EQUAL");
            this.filterField.put("unitWord", "EQUAL");
            this.filterField.put("parentUnit", "EQUAL");
            this.filterField.put("NP_TOPUnit", "(parentUnit is null or parentUnit='0')");
            this.filterField.put("ORDER BY", " unitOrder, unitCode ");
            this.filterField.put("(STARTWITH)unitPath", "LIKE");
        }
        return this.filterField;
    }

    @Transactional
    public String getNextKey() {
        return StringBaseOpt.objectToString((Object)DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_UNITCODE"));
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<UserInfo> listUnitUsers(String unitCode) {
        String sql = "select a.* from F_USERINFO a join F_USERUNIT b on(a.USERCODE=b.USERCODE) where b.UNITCODE =?";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{unitCode}, UserInfo.class));
    }

    @Transactional
    public UnitInfo getUnitByName(String name) {
        String sql = "select u.UNIT_CODE, u.PARENT_UNIT, u.UNIT_TYPE, u.IS_VALID, u.UNIT_NAME, u.ENGLISH_NAME, u.UNIT_SHORT_NAME, u.UNIT_WORD, u.UNIT_TAG, u.UNIT_DESC, u.ADDRBOOK_ID, u.UNIT_ORDER, u.UNIT_GRADE, u.DEP_NO, u.UNIT_PATH, u.UNIT_MANAGER, u.CREATE_DATE, u.CREATOR, u.UPDATOR, u.UPDATE_DATE from F_UNITINFO u where u.UNIT_NAME = ? or u.UNIT_SHORT_NAME = ? order by unitOrder asc";
        return (UnitInfo)((List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{name, name}, UnitInfo.class))).get(0);
    }

    @Transactional
    public UnitInfo getUnitByTag(String unitTag) {
        return (UnitInfo)super.getObjectByProperties(QueryUtils.createSqlParamsMap((Object[])new Object[]{"unitTag", unitTag}));
    }

    @Transactional
    public UnitInfo getUnitByWord(String unitWord) {
        return (UnitInfo)super.getObjectByProperties(QueryUtils.createSqlParamsMap((Object[])new Object[]{"unitWord", unitWord}));
    }

    @Transactional
    public List<UnitInfo> listSubUnits(String unitCode) {
        return super.listObjectsByProperty("parentUnit", (Object)unitCode);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<UnitInfo> listSubUnitsByUnitPaht(String unitPath) {
        return this.listObjects(QueryUtils.createSqlParamsMap((Object[])new Object[]{"unitPath", unitPath + "%"}));
    }

    public List<String> getAllParentUnit() {
        return this.getJdbcTemplate().queryForList("select distinct t.parent_unit from f_unitinfo t ", String.class);
    }

    public UnitInfo getObjectById(String unitCode) {
        return (UnitInfo)super.getObjectById((Object)unitCode);
    }

    public void deleteObjectById(String unitCode) {
        super.deleteObjectById((Object)unitCode);
    }

    public UnitInfo getPeerUnitByName(String unitName, String parentCode, String unitCode) {
        String sql = "select u.UNIT_CODE, u.PARENT_UNIT, u.UNIT_TYPE, u.IS_VALID, u.UNIT_NAME, u.ENGLISH_NAME, u.UNIT_SHORT_NAME, u.UNIT_WORD, u.UNIT_TAG, u.UNIT_DESC, u.ADDRBOOK_ID, u.UNIT_ORDER, u.UNIT_GRADE, u.DEP_NO, u.UNIT_PATH, u.UNIT_MANAGER, u.CREATE_DATE, u.CREATOR, u.UPDATOR, u.UPDATE_DATE from F_UNITINFO u where u.UNIT_NAME = :unitName and u.PARENT_UNIT = :parentUnit and u.UNIT_CODE <> :unitCode";
        List list = this.listObjectsBySql(sql, QueryUtils.createSqlParamsMap((Object[])new Object[]{"unitName", unitName, "parentUnit", parentCode, "unitCode", unitCode}));
        if (list == null || list.size() == 0) {
            return null;
        }
        return (UnitInfo)list.get(0);
    }

    public Integer isExistsUnitByParentAndOrder(String parentUnit, long unitOrder) {
        String sql = "select count(*) as existUnit from F_UNITINFO u where u.UNIT_ORDER = :unitOrder and u.PARENT_UNIT = :parentUnit ";
        Object object = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)sql, (Map)QueryUtils.createSqlParamsMap((Object[])new Object[]{"unitOrder", unitOrder, "parentUnit", parentUnit}));
        return NumberBaseOpt.castObjectToInteger((Object)object);
    }

    public void updateUnit(UnitInfo unitInfo) {
        super.updateObject((Serializable)unitInfo);
    }
}

