/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.jdbcimpl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.po.FVUserOptList;
import com.centit.framework.system.po.UserInfo;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="userInfoDao")
public class UserInfoDaoImpl
extends BaseDaoImpl<UserInfo, String>
implements UserInfoDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("userCode", "LIKE");
            this.filterField.put("USERCODE_EQ", "EQUAL");
            this.filterField.put("userName", "LIKE");
            this.filterField.put("isValid", "EQUAL");
            this.filterField.put("LOGINNAME", "LIKE");
            this.filterField.put("USERSTATE", "EQUAL");
            this.filterField.put("USERORDER", "EQUAL");
            this.filterField.put("USERTAG", "EQUAL");
            this.filterField.put("USERWORD", "EQUAL");
            this.filterField.put("byUnderUnit", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE = :byUnderUnit ) ");
            this.filterField.put("roleCode", "USER_CODE in (select v.USER_CODE from F_V_USERROLES v where v.ROLE_CODE = :roleCode) ");
            this.filterField.put("queryByUnit", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE = :queryByUnit ) ");
            this.filterField.put("queryByGW", "userCode in (select us.USER_CODE from f_userunit us where us.User_Station = :queryByGW )");
            this.filterField.put("queryByXZ", "userCode in (select us.USER_CODE from f_userunit us where us.USER_RANK = :queryByXZ )");
            this.filterField.put("queryByRole", "userCode in (select r.USER_CODE from f_userrole r join f_roleinfo i on r.ROLE_CODE = i.ROLE_CODE where r.ROLE_CODE = :queryByRole and i.IS_VALID = 'T')");
            this.filterField.put("unitCode", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE in (select un.UNIT_CODE from f_unitinfo un where un.UNIT_CODE = :unitCode or un.PARENT_UNIT = :unitCode))");
            this.filterField.put("(STARTWITH)unitPath", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE in (select un.UNIT_CODE from f_unitinfo un where un.UNIT_PATH like :unitPath))");
        }
        return this.filterField;
    }

    @Transactional
    public String getNextKey() {
        return StringBaseOpt.objectToString((Object)DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_USERCODE"));
    }

    @Transactional
    public List<FVUserOptList> getAllOptMethodByUser(String userCode) {
        String sql = "select USER_CODE,OPT_CODE,OPT_NAME,OPT_ID,OPT_METHOD from F_V_USEROPTLIST where USER_CODE=?";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{userCode}, FVUserOptList.class));
    }

    @Transactional
    public List<UserInfo> listUnderUnit(Map<String, Object> filterMap) {
        return this.listObjects(filterMap);
    }

    @Transactional
    public List<UserInfo> listUnderUnit(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.listObjectsByProperties(filterMap, pageDesc);
    }

    @Transactional
    public UserInfo getUserByCode(String userCode) {
        return (UserInfo)super.getObjectById((Object)userCode);
    }

    @Transactional
    public UserInfo getUserByLoginName(String loginName) {
        return (UserInfo)super.getObjectByProperties(QueryUtils.createSqlParamsMap((Object[])new Object[]{"loginName", loginName.toLowerCase()}));
    }

    @Transactional
    public UserInfo getUserByRegEmail(String regEmail) {
        return (UserInfo)super.getObjectByProperties(QueryUtils.createSqlParamsMap((Object[])new Object[]{"regEmail", regEmail}));
    }

    @Transactional
    public UserInfo getUserByRegCellPhone(String regCellPhone) {
        return (UserInfo)super.getObjectByProperties(QueryUtils.createSqlParamsMap((Object[])new Object[]{"regCellPhone", regCellPhone}));
    }

    @Transactional
    public UserInfo getUserByTag(String userTag) {
        return (UserInfo)super.getObjectByProperties(QueryUtils.createSqlParamsMap((Object[])new Object[]{"userTag", userTag}));
    }

    @Transactional
    public UserInfo getUserByUserWord(String userWord) {
        return (UserInfo)super.getObjectByProperties(QueryUtils.createSqlParamsMap((Object[])new Object[]{"userWord", userWord}));
    }

    @Transactional
    public UserInfo getUserByIdCardNo(String idCardNo) {
        return (UserInfo)super.getObjectByProperties(QueryUtils.createSqlParamsMap((Object[])new Object[]{"idCardNo", idCardNo}));
    }

    public void deleteObjectById(String userCode) {
        super.deleteObjectById((Object)userCode);
    }

    public List<UserInfo> listUsersByRoleCode(String roleCode) {
        return super.listObjects(QueryUtils.createSqlParamsMap((Object[])new Object[]{"roleCode", roleCode}));
    }

    public int isLoginNameExist(String userCode, String loginName) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USERCODE <> ? and t.LOGINNAME = ?";
        try {
            return DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{userCode, loginName});
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public int isCellPhoneExist(String userCode, String loginName) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USERCODE <> ? and t.REGCELLPHONE = ?";
        try {
            return DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{userCode, loginName});
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public int isEmailExist(String userCode, String loginName) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USERCODE <> ? and t.REGEMAIL = ?";
        try {
            return DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{userCode, loginName});
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public int isAnyOneExist(String userCode, String loginName, String regPhone, String regEmail) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USER_CODE != ? and (t.LOGIN_NAME = ? or t.REG_CELL_PHONE= ? or t.Reg_Email = ?)";
        try {
            return DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{userCode, loginName, regPhone, regEmail});
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public void updateUser(UserInfo userInfo) {
        super.updateObject((Serializable)userInfo);
    }
}

