/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.config;

import com.centit.framework.security.model.CentitUserDetailsService;
import com.centit.framework.security.model.StandardPasswordEncoderImpl;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;

@Configuration(value="securityBeanConfiguation")
public class SecurityBeanConfiguation {
    @Autowired
    protected CentitUserDetailsService centitUserDetailsService;
    @Autowired
    protected StandardPasswordEncoderImpl passwordEncoder;

    @Bean
    public AuthenticationManager authenticationManager() {
        DaoAuthenticationProvider authenticationProvider = new DaoAuthenticationProvider();
        authenticationProvider.setHideUserNotFoundExceptions(false);
        authenticationProvider.setUserDetailsService((UserDetailsService)this.centitUserDetailsService);
        authenticationProvider.setPasswordEncoder((PasswordEncoder)this.passwordEncoder);
        ArrayList<DaoAuthenticationProvider> providerList = new ArrayList<DaoAuthenticationProvider>();
        providerList.add(authenticationProvider);
        return new ProviderManager(providerList);
    }

    @Bean
    public CsrfTokenRepository csrfTokenRepository() {
        return new HttpSessionCsrfTokenRepository();
    }
}

