/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.config;

import com.centit.framework.config.SecurityProperties;
import com.centit.framework.security.AjaxAuthenticationFailureHandler;
import com.centit.framework.security.AjaxAuthenticationSuccessHandler;
import com.centit.framework.security.DaoAccessDecisionManager;
import com.centit.framework.security.DaoFilterSecurityInterceptor;
import com.centit.framework.security.DaoInvocationSecurityMetadataSource;
import com.centit.framework.security.model.CentitUserDetailsService;
import com.centit.support.algorithm.StringBaseOpt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.csrf.CsrfTokenRepository;

public abstract class WebSecurityBaseConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    protected SecurityProperties securityProperties;
    @Autowired
    protected CsrfTokenRepository csrfTokenRepository;
    @Autowired
    protected AuthenticationManager authenticationManager;
    @Autowired
    protected CentitUserDetailsService centitUserDetailsService;

    protected AjaxAuthenticationFailureHandler createFailureHandler() {
        AjaxAuthenticationFailureHandler ajaxFailureHandler = new AjaxAuthenticationFailureHandler();
        ajaxFailureHandler.setDefaultFailureUrl(StringBaseOpt.emptyValue((String)this.securityProperties.getLogin().getFailure().getTargetUrl(), (String)"/system/mainframe/login/error"));
        ajaxFailureHandler.setWriteLog(this.securityProperties.getLogin().getFailure().isWriteLog());
        return ajaxFailureHandler;
    }

    protected AjaxAuthenticationSuccessHandler createSuccessHandler(CentitUserDetailsService centitUserDetailsService) {
        AjaxAuthenticationSuccessHandler ajaxSuccessHandler = new AjaxAuthenticationSuccessHandler();
        ajaxSuccessHandler.setDefaultTargetUrl(StringBaseOpt.emptyValue((String)this.securityProperties.getLogin().getSuccess().getTargetUrl(), (String)"/"));
        ajaxSuccessHandler.setWriteLog(this.securityProperties.getLogin().getSuccess().isWriteLog());
        ajaxSuccessHandler.setUserDetailsService(centitUserDetailsService);
        return ajaxSuccessHandler;
    }

    protected DaoFilterSecurityInterceptor createCentitPowerFilter(DaoAccessDecisionManager centitAccessDecisionManagerBean, DaoInvocationSecurityMetadataSource centitSecurityMetadataSource) {
        DaoFilterSecurityInterceptor centitPowerFilter = new DaoFilterSecurityInterceptor();
        centitPowerFilter.setAccessDecisionManager((AccessDecisionManager)centitAccessDecisionManagerBean);
        centitPowerFilter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)centitSecurityMetadataSource);
        return centitPowerFilter;
    }

    protected DaoAccessDecisionManager createCentitAccessDecisionManager() {
        DaoAccessDecisionManager accessDecisionManager = new DaoAccessDecisionManager();
        return accessDecisionManager;
    }

    protected DaoInvocationSecurityMetadataSource createCentitSecurityMetadataSource() {
        return new DaoInvocationSecurityMetadataSource();
    }
}

