/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.config;

import com.centit.framework.config.SecurityProperties;
import com.centit.framework.config.WebSecurityBaseConfig;
import com.centit.framework.security.DaoFilterSecurityInterceptor;
import java.util.ArrayList;
import javax.servlet.Filter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;
import org.springframework.security.cas.web.CasAuthenticationFilter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.util.Assert;

@Configuration
@EnableWebSecurity
@ConditionalOnProperty(prefix="security.login.cas", name={"enabled"})
@EnableConfigurationProperties(value={SecurityProperties.class})
public class WebSecurityCasConfig
extends WebSecurityBaseConfig {
    private ServiceProperties createCasServiceProperties() {
        ServiceProperties casServiceProperties = new ServiceProperties();
        casServiceProperties.setService(this.securityProperties.getLogin().getCas().getLocalHome() + "/login/cas");
        casServiceProperties.setSendRenew(false);
        return casServiceProperties;
    }

    protected AuthenticationProvider getAuthenticationProvider() {
        CasAuthenticationProvider casAuthenticationProvider = new CasAuthenticationProvider();
        casAuthenticationProvider.setUserDetailsService((UserDetailsService)this.centitUserDetailsService);
        casAuthenticationProvider.setServiceProperties(this.createCasServiceProperties());
        casAuthenticationProvider.setTicketValidator((TicketValidator)new Cas20ServiceTicketValidator(this.securityProperties.getLogin().getCas().getCasHome()));
        casAuthenticationProvider.setKey(this.securityProperties.getLogin().getCas().getAppKey());
        return casAuthenticationProvider;
    }

    protected AuthenticationEntryPoint getAuthenticationEntryPoint() {
        ServiceProperties serviceProperties = this.createCasServiceProperties();
        CasAuthenticationEntryPoint casEntryPoint = new CasAuthenticationEntryPoint();
        casEntryPoint.setLoginUrl(this.securityProperties.getLogin().getCas().getCasHome());
        casEntryPoint.setServiceProperties(serviceProperties);
        return casEntryPoint;
    }

    protected AuthenticationManager createAuthenticationManager() {
        AuthenticationProvider authenticationProvider = this.getAuthenticationProvider();
        Assert.notNull((Object)authenticationProvider, (String)"authenticationProvider\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<AuthenticationProvider> providerList = new ArrayList<AuthenticationProvider>();
        providerList.add(authenticationProvider);
        return new ProviderManager(providerList);
    }

    private SingleSignOutFilter singleSignOutFilter() {
        SingleSignOutFilter singleLogoutFilter = new SingleSignOutFilter();
        singleLogoutFilter.setCasServerUrlPrefix(this.securityProperties.getLogin().getCas().getCasHome());
        return singleLogoutFilter;
    }

    protected AbstractAuthenticationProcessingFilter getAuthenticationFilter() {
        CasAuthenticationFilter casFilter = new CasAuthenticationFilter();
        casFilter.setAuthenticationManager(this.createAuthenticationManager());
        casFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.createFailureHandler());
        casFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.createSuccessHandler(this.centitUserDetailsService));
        return casFilter;
    }

    protected void configure(HttpSecurity http) throws Exception {
        if (this.securityProperties.getHttp().isCsrfEnable()) {
            http.csrf().csrfTokenRepository(this.csrfTokenRepository);
        } else {
            http.csrf().disable();
        }
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/system/mainframe/login", "/system/exception", "/oauth/check_token"})).permitAll().and()).exceptionHandling().accessDeniedPage("/system/exception/error/403").and()).sessionManagement().invalidSessionUrl("/system/exception/error/401").and()).httpBasic().authenticationEntryPoint(this.getAuthenticationEntryPoint());
        http.headers().frameOptions().sameOrigin();
        DaoFilterSecurityInterceptor centitPowerFilter = this.createCentitPowerFilter(this.createCentitAccessDecisionManager(), this.createCentitSecurityMetadataSource());
        http.addFilterAt((Filter)this.getAuthenticationFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)centitPowerFilter, FilterSecurityInterceptor.class).addFilterBefore((Filter)this.singleSignOutFilter(), CasAuthenticationFilter.class);
    }
}

