/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.config;

import com.centit.framework.config.SecurityProperties;
import com.centit.framework.config.WebSecurityBaseConfig;
import com.centit.framework.security.AjaxAuthenticationFailureHandler;
import com.centit.framework.security.AjaxAuthenticationSuccessHandler;
import com.centit.framework.security.DaoFilterSecurityInterceptor;
import com.centit.framework.security.PretreatmentAuthenticationProcessingFilter;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.CookieClearingLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.csrf.CsrfLogoutHandler;

@Configuration
@EnableWebSecurity
@ConditionalOnProperty(prefix="security.login.dao", name={"enabled"})
@EnableConfigurationProperties(value={SecurityProperties.class})
public class WebSecurityDaoConfig
extends WebSecurityBaseConfig {
    private LoginUrlAuthenticationEntryPoint authenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint("/system/mainframe/login");
    }

    private UsernamePasswordAuthenticationFilter createPretreatmentAuthenticationProcessingFilter(AuthenticationManager authenticationManager, AjaxAuthenticationSuccessHandler ajaxSuccessHandler, AuthenticationFailureHandler ajaxFailureHandler) {
        PretreatmentAuthenticationProcessingFilter pretreatmentAuthenticationProcessingFilter = new PretreatmentAuthenticationProcessingFilter();
        pretreatmentAuthenticationProcessingFilter.setAuthenticationManager(authenticationManager);
        pretreatmentAuthenticationProcessingFilter.setCheckCaptchaTime(this.securityProperties.getLogin().getCaptcha().getCheckTime());
        pretreatmentAuthenticationProcessingFilter.setCheckCaptchaType(this.securityProperties.getLogin().getCaptcha().getCheckType());
        pretreatmentAuthenticationProcessingFilter.setRetryCheckType(this.securityProperties.getLogin().getRetry().getCheckType());
        pretreatmentAuthenticationProcessingFilter.setRetryMaxTryTimes(this.securityProperties.getLogin().getRetry().getMaxTryTimes());
        pretreatmentAuthenticationProcessingFilter.setRetryLockMinites(this.securityProperties.getLogin().getRetry().getLockMinites());
        pretreatmentAuthenticationProcessingFilter.setRetryCheckTimeTnterval(this.securityProperties.getLogin().getRetry().getCheckTimeInterval());
        pretreatmentAuthenticationProcessingFilter.setContinueChainBeforeSuccessfulAuthentication(this.securityProperties.getHttp().isFilterContinueAuthentication());
        pretreatmentAuthenticationProcessingFilter.setAuthenticationFailureHandler(ajaxFailureHandler);
        pretreatmentAuthenticationProcessingFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)ajaxSuccessHandler);
        return pretreatmentAuthenticationProcessingFilter;
    }

    private LogoutFilter logoutFilter() {
        return new LogoutFilter(this.securityProperties.getLogout().getTargetUrl(), new LogoutHandler[]{new CsrfLogoutHandler(this.csrfTokenRepository), new CookieClearingLogoutHandler(new String[]{"JSESSIONID", "remember-me"}), new SecurityContextLogoutHandler()});
    }

    protected void configure(HttpSecurity http) throws Exception {
        if (this.securityProperties.getHttp().isCsrfEnable()) {
            http.csrf().csrfTokenRepository(this.csrfTokenRepository);
        } else {
            http.csrf().disable();
        }
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/system/mainframe/login", "/system/exception", "/oauth/check_token"})).permitAll().and()).exceptionHandling().accessDeniedPage("/system/exception/error/403").and()).sessionManagement().invalidSessionUrl("/system/exception/error/401").and()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint());
        http.headers().frameOptions().sameOrigin();
        AjaxAuthenticationFailureHandler ajaxFailureHandler = this.createFailureHandler();
        AjaxAuthenticationSuccessHandler ajaxSuccessHandler = this.createSuccessHandler(this.centitUserDetailsService);
        UsernamePasswordAuthenticationFilter pretreatmentAuthenticationProcessingFilter = this.createPretreatmentAuthenticationProcessingFilter(this.authenticationManager, ajaxSuccessHandler, (AuthenticationFailureHandler)ajaxFailureHandler);
        http.addFilterAt((Filter)pretreatmentAuthenticationProcessingFilter, UsernamePasswordAuthenticationFilter.class).addFilterAt((Filter)this.logoutFilter(), LogoutFilter.class);
        DaoFilterSecurityInterceptor centitPowerFilter = this.createCentitPowerFilter(this.createCentitAccessDecisionManager(), this.createCentitSecurityMetadataSource());
        http.addFilterBefore((Filter)centitPowerFilter, FilterSecurityInterceptor.class);
    }
}

