/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.security.model;

import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.security.utils.SM3Util;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.springframework.security.crypto.password.PasswordEncoder;

public class SM3PasswordEncoderImpl
implements CentitPasswordEncoder,
PasswordEncoder {
    private Function<String, String> passwordPreteat = null;

    public String encodePassword(String rawPass, Object salt) {
        return new String(Base64.encodeBase64URLSafe((byte[])SM3Util.hash(rawPass.getBytes())));
    }

    public String createPassword(String rawPass, Object salt) {
        return this.encodePassword(this.passwordPreteat != null ? this.passwordPreteat.apply(rawPass) : rawPass, salt);
    }

    public boolean isPasswordValid(String encodedPassword, String rawPass, Object salt) {
        return StringUtils.equals((CharSequence)encodedPassword, (CharSequence)this.encodePassword(rawPass, salt));
    }

    public String encode(CharSequence rawPassword) {
        return this.encodePassword(String.valueOf(rawPassword), null);
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        return this.isPasswordValid(String.valueOf(encodedPassword), String.valueOf(rawPassword), null);
    }
}

