/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.security;

import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.security.model.CentitUserDetailsService;
import com.centit.support.algorithm.DatetimeOpt;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;

public class AjaxAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private boolean writeLog = false;
    private boolean registToken = false;
    private SessionRegistry sessionRegistry;
    private CentitUserDetailsService userDetailsService;

    public void setWriteLog(boolean writeLog) {
        this.writeLog = writeLog;
    }

    public void setRegistToken(boolean registToken) {
        this.registToken = registToken;
    }

    public void setSessionRegistry(SessionRegistry sessionManger) {
        this.sessionRegistry = sessionManger;
    }

    public void setUserDetailsService(CentitUserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String ajax;
        CentitUserDetails ud = (CentitUserDetails)authentication.getPrincipal();
        String lang = WebOptUtils.getLocalLangParameter((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            WebOptUtils.setCurrentLang((HttpServletRequest)request, (String)lang);
            String userLang = ud.getUserSettingValue("LOCAL_LANG");
            if (!lang.equals(userLang)) {
                ud.setUserSettingValue("LOCAL_LANG", userLang);
                if (this.userDetailsService != null) {
                    this.userDetailsService.saveUserSetting(ud.getUserInfo().getUserCode(), "LOCAL_LANG", lang, "SYS", "\u7528\u6237\u9ed8\u8ba4\u533a\u57df\u8bed\u8a00");
                }
            }
        } else {
            lang = ud.getUserSettingValue("LOCAL_LANG");
            if (StringUtils.isNotBlank((CharSequence)lang)) {
                WebOptUtils.setCurrentLang((HttpServletRequest)request, (String)lang);
                request.setAttribute("LOCAL_LANG", (Object)lang);
            }
        }
        ud.setLoginIp(request.getRemoteHost() + ":" + request.getRemotePort());
        ud.setActiveTime(DatetimeOpt.currentUtilDate());
        request.getSession().setAttribute("SECURITY_CONTEXT_USERDETAIL", (Object)ud);
        String tokenKey = request.getSession().getId();
        if (this.registToken) {
            this.sessionRegistry.registerNewSession(tokenKey, (Object)ud);
            request.getSession().setAttribute("accessToken", (Object)tokenKey);
        }
        if (this.writeLog) {
            OperationLogCenter.log((String)ud.getUserInfo().getUserCode(), (String)"login", (String)"login", (String)("\u7528\u6237 \uff1a" + ud.getUserInfo().getUserName() + "\u4e8e" + DatetimeOpt.convertDatetimeToString((Date)DatetimeOpt.currentUtilDate()) + "\u4ece\u4e3b\u673a" + request.getRemoteHost() + ":" + request.getRemotePort() + "\u767b\u5f55\u3002"));
        }
        if ((ajax = request.getParameter("ajax")) == null || "".equals(ajax) || "null".equals(ajax) || "false".equals(ajax)) {
            super.onAuthenticationSuccess(request, response, authentication);
        } else {
            ResponseMapData resData = new ResponseMapData();
            if (this.registToken) {
                resData.addResponseData("accessToken", (Object)tokenKey);
            }
            resData.addResponseData("userInfo", (Object)ud);
            JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
        }
    }
}

