/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.security;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.security.SecurityContextUtils;
import com.centit.framework.security.model.CentitUserDetails;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.InterceptorStatusToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

public class DaoFilterSecurityInterceptor
extends AbstractSecurityInterceptor
implements Filter {
    private FilterInvocationSecurityMetadataSource securityMetadataSource;
    private SessionRegistry sessionRegistry;
    private boolean allResourceMustBeAudited = false;

    public void setSessionRegistry(SessionRegistry sessionManger) {
        this.sessionRegistry = sessionManger;
    }

    public void setAllResourceMustBeAudited(boolean allResourceMustBeAudited) {
        this.allResourceMustBeAudited = allResourceMustBeAudited;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        this.invoke(fi);
    }

    public FilterInvocationSecurityMetadataSource getSecurityMetadataSource() {
        return this.securityMetadataSource;
    }

    public Class<? extends Object> getSecureObjectClass() {
        return FilterInvocation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(FilterInvocation fi) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean alwaysReauthenticate = false;
        if ("XMLHttpRequest".equals(fi.getRequest().getHeader("X-Requested-With"))) {
            if (authentication == null || "anonymousUser".equals(authentication.getName())) {
                CentitUserDetails ud;
                HttpServletRequest request = fi.getHttpRequest();
                String accessToken = request.getParameter("accessToken");
                if (StringUtils.isBlank((CharSequence)accessToken)) {
                    accessToken = request.getHeader("x-auth-token");
                }
                if (StringUtils.isBlank((CharSequence)accessToken)) {
                    accessToken = request.getSession().getId();
                }
                if ((ud = SecurityContextUtils.getCurrentUserDetails((SessionRegistry)this.sessionRegistry, (String)accessToken)) != null && (StringUtils.isBlank((CharSequence)ud.getLoginIp()) || ud.getLoginIp().equals(WebOptUtils.getRequestAddr((HttpServletRequest)fi.getRequest())))) {
                    alwaysReauthenticate = this.isAlwaysReauthenticate();
                    if (alwaysReauthenticate) {
                        this.setAlwaysReauthenticate(false);
                    }
                    authentication = ud;
                    SecurityContextHolder.getContext().setAuthentication(authentication);
                    WebOptUtils.setCurrentLang((HttpServletRequest)fi.getHttpRequest(), (String)ud.getUserSettingValue("LOCAL_LANG"));
                }
            }
            if (this.allResourceMustBeAudited && (authentication == null || "anonymousUser".equals(authentication.getName()))) {
                fi.getResponse().setStatus(401);
                return;
            }
        }
        InterceptorStatusToken token = super.beforeInvocation((Object)fi);
        try {
            fi.getChain().doFilter((ServletRequest)fi.getRequest(), (ServletResponse)fi.getResponse());
        }
        finally {
            super.afterInvocation(token, null);
        }
        if (alwaysReauthenticate) {
            this.setAlwaysReauthenticate(true);
        }
    }

    public SecurityMetadataSource obtainSecurityMetadataSource() {
        return this.securityMetadataSource;
    }

    public void setSecurityMetadataSource(FilterInvocationSecurityMetadataSource newSource) {
        this.securityMetadataSource = newSource;
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

