/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.security;

import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;

public class DaoAccessDecisionManager
implements AccessDecisionManager {
    private static final Logger logger = LoggerFactory.getLogger(DaoAccessDecisionManager.class);

    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        if (configAttributes.contains(new SecurityConfig("forbidden"))) {
            String sErrMsg = "\u8d44\u6e90\u88ab\u7981\u6b62\u8bbf\u95ee";
            logger.error(sErrMsg);
            throw new AccessDeniedException(sErrMsg);
        }
        Collection userRoles = authentication.getAuthorities();
        if (userRoles != null) {
            Iterator userRolesItr = userRoles.iterator();
            Iterator<ConfigAttribute> needRolesItr = configAttributes.iterator();
            String needRole = needRolesItr.next().getAttribute();
            Object userRole = ((GrantedAuthority)userRolesItr.next()).getAuthority();
            while (true) {
                int n;
                if ((n = needRole.compareTo((String)userRole)) == 0) {
                    return;
                }
                if (n < 0) {
                    if (!needRolesItr.hasNext()) break;
                    needRole = needRolesItr.next().getAttribute();
                    continue;
                }
                if (!userRolesItr.hasNext()) break;
                userRole = ((GrantedAuthority)userRolesItr.next()).getAuthority();
            }
        }
        FilterInvocation fi = (FilterInvocation)object;
        String requestUrl = fi.getRequestUrl();
        StringBuilder needRoles = new StringBuilder();
        for (ConfigAttribute ca : configAttributes) {
            needRoles.append(ca.getAttribute().substring(2)).append(" ");
        }
        String sErrMsg = "\u65e0\u6743\u9650\u8bbf\u95ee\u8d44\u6e90:" + requestUrl + ",\u9700\u8981\u89d2\u8272 " + needRoles + "\u4e2d\u7684\u4e00\u4e2a\u3002";
        fi.getRequest().setAttribute("CENTIT_SYSTEM_ERROR_MSG", (Object)sErrMsg);
        logger.error(sErrMsg);
        throw new AccessDeniedException(sErrMsg);
    }

    public boolean supports(ConfigAttribute arg0) {
        return true;
    }

    public boolean supports(Class<?> arg0) {
        return true;
    }
}

