/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.security;

import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.security.CheckFailLogs;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.security.SecurityOptUtils;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class AjaxAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private boolean writeLog = false;

    public void setWriteLog(boolean writeLog) {
        this.writeLog = writeLog;
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (this.writeLog) {
            String loginName = SecurityOptUtils.decodeSecurityString((String)request.getParameter("username"));
            String loginHost = request.getRemoteHost() + ":" + request.getRemotePort();
            OperationLogCenter.log((OperationLog)OperationLog.create().user(loginName).method("loginError").application("mainframe").operation("login").content("\u7528\u6237 \uff1a" + loginName + "\u4e8e" + DatetimeOpt.convertDatetimeToString((Date)DatetimeOpt.currentUtilDate()) + "\u4ece\u4e3b\u673a" + loginHost + "\u5c1d\u8bd5\u767b\u5f55,\u5931\u8d25\u539f\u56e0:" + exception.getMessage()).loginIp(loginHost));
        }
        int tryTimes = CheckFailLogs.getHasTriedTimes(request);
        boolean isAjaxQuery = WebOptUtils.isAjax((HttpServletRequest)request);
        if (isAjaxQuery) {
            ResponseMapData resData = new ResponseMapData(101, exception.getMessage());
            resData.addResponseData("hasTriedTimes", (Object)tryTimes);
            JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
        } else {
            request.setAttribute("hasTriedTimes", (Object)tryTimes);
            super.onAuthenticationFailure(request, response, exception);
        }
    }
}

