/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.security;

import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.framework.security.SecurityContextUtils;
import com.centit.support.algorithm.DatetimeOpt;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;

public class AjaxAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private boolean writeLog = false;
    private PlatformEnvironment platformEnvironment;

    public void setWriteLog(boolean writeLog) {
        this.writeLog = writeLog;
    }

    public void setPlatformEnvironment(PlatformEnvironment platformEnvironment) {
        this.platformEnvironment = platformEnvironment;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        CentitUserDetails ud = (CentitUserDetails)authentication.getPrincipal();
        SecurityContextUtils.fetchAndSetLocalParams((CentitUserDetails)ud, (HttpServletRequest)request, (PlatformEnvironment)this.platformEnvironment);
        if (this.writeLog) {
            String remoteHost = request.getRemoteHost();
            String loginIp = ud.getLoginIp();
            if (!loginIp.startsWith(remoteHost)) {
                loginIp = remoteHost + ":" + loginIp;
            }
            OperationLogCenter.log((OperationLog)OperationLog.create().user(ud.getUserCode()).operation("mainframe").unit(ud.getCurrentUnitCode()).method("login").content("\u7528\u6237 \uff1a" + ud.getUserInfo().getUserName() + " \u4e8e" + DatetimeOpt.convertDatetimeToString((Date)DatetimeOpt.currentUtilDate()) + "\u4ece\u4e3b\u673a" + loginIp + "\u767b\u5f55\u3002").loginIp(loginIp).topUnit(ud.getTopUnitCode()));
        }
        Cookie cookie = new Cookie("X-Auth-Token", request.getSession().getId());
        cookie.setPath("/");
        response.addCookie(cookie);
        boolean isAjaxQuery = WebOptUtils.isAjax((HttpServletRequest)request);
        if (isAjaxQuery) {
            ResponseData resData = SecurityContextUtils.makeLoginSuccessResponse((CentitUserDetails)ud, (HttpServletRequest)request);
            JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
        } else {
            response.setHeader("X-Auth-Token", request.getSession().getId());
            response.setHeader(SecurityContextUtils.SecurityContextTokenName, request.getSession().getId());
            super.onAuthenticationSuccess(request, response, authentication);
        }
    }
}

