/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.security;

import com.centit.framework.security.CheckFailLogs;
import com.centit.framework.security.SecurityContextUtils;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.image.CaptchaImageUtil;
import com.centit.support.security.SecurityOptUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class PretreatmentAuthenticationProcessingFilter
extends UsernamePasswordAuthenticationFilter {
    private int checkCaptchaTime = 0;
    private int checkCaptchaType = 0;

    public void setCheckCaptchaTime(int checkCaptchaTime) {
        this.checkCaptchaTime = checkCaptchaTime;
    }

    public void setCheckCaptchaType(int checkCaptchaType) {
        this.checkCaptchaType = checkCaptchaType;
    }

    public void setRetryMaxTryTimes(int maxTryTimes) {
        CheckFailLogs.setMaxTryTimes(maxTryTimes);
    }

    public void setRetryCheckType(String checkType) {
        CheckFailLogs.setCheckType(checkType);
    }

    public void setRetryLockMinites(int lockMinites) {
        CheckFailLogs.setLockMinites(lockMinites);
    }

    public void setRetryCheckTimeTnterval(int checkTimeTnterval) {
        CheckFailLogs.setCheckTimeTnterval(checkTimeTnterval);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (CheckFailLogs.getMaxTryTimes() > 0 && CheckFailLogs.isLocked(request)) {
            throw new AuthenticationServiceException("User is locked, please try late!");
        }
        int tryTimes = CheckFailLogs.getHasTriedTimes(request);
        if (this.checkCaptchaType != 0 && (this.checkCaptchaTime == 2 || this.checkCaptchaTime == 1 && tryTimes > 0)) {
            if (!BooleanBaseOpt.castObjectToBoolean((Object)request.getSession().getAttribute(SecurityContextUtils.AJAX_CHECK_CAPTCHA_RESULT), (Boolean)false).booleanValue()) {
                String requestCheckcode = request.getParameter("j_checkcode");
                String sessionCheckcode = StringBaseOpt.castObjectToString((Object)request.getSession().getAttribute("session_checkcode"));
                if (StringUtils.isNotBlank((CharSequence)sessionCheckcode)) {
                    request.getSession().setAttribute("session_checkcode", (Object)CaptchaImageUtil.getRandomString((int)6));
                    if (!CaptchaImageUtil.checkcodeMatch((String)sessionCheckcode, (String)requestCheckcode)) {
                        throw new AuthenticationServiceException("\u9a8c\u8bc1\u7801\u8f93\u5165\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8f93\u5165\uff01");
                    }
                }
            }
            request.getSession().setAttribute(SecurityContextUtils.AJAX_CHECK_CAPTCHA_RESULT, (Object)false);
        }
        try {
            String username = this.obtainUsername(request);
            username = SecurityOptUtils.decodeSecurityString((String)username);
            String password = this.obtainPassword(request);
            password = SecurityOptUtils.decodeSecurityString((String)password);
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
            this.setDetails(request, authRequest);
            Authentication auth = this.getAuthenticationManager().authenticate((Authentication)authRequest);
            CheckFailLogs.removeCheckFail(request);
            return auth;
        }
        catch (AuthenticationException failed) {
            CheckFailLogs.plusCheckFail(request);
            throw failed;
        }
    }
}

