/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.session.jdbc;

import com.centit.support.database.utils.DBType;
import javax.sql.DataSource;
import oracle.jdbc.driver.OracleDriver;
import org.h2.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.jdbc.datasource.embedded.ConnectionProperties;
import org.springframework.jdbc.datasource.embedded.DataSourceFactory;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.jdbc.JdbcOperationsSessionRepository;
import org.springframework.session.jdbc.config.annotation.web.http.EnableJdbcHttpSession;
import org.springframework.session.security.SpringSessionBackedSessionRegistry;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJdbcHttpSession(maxInactiveIntervalInSeconds=-1)
public class JdbcSessionPersistenceConfig {
    private Logger logger = LoggerFactory.getLogger(JdbcSessionPersistenceConfig.class);
    @Value(value="${session.jdbc.url:jdbc:h2:mem:framework_session;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=false}")
    private String url;
    @Value(value="${session.jdbc.username:sa}")
    private String username;
    @Value(value="${session.jdbc.password:}")
    private String password;

    @Bean
    public EmbeddedDatabase jdbcSessionDataSource() {
        Class<com.mysql.jdbc.Driver> driverClass;
        String schema = "org/springframework/session/jdbc/schema-%s.sql";
        DBType type = DBType.mapDBType((String)this.url);
        switch (type) {
            case MySql: {
                schema = String.format(schema, "mysql");
                driverClass = com.mysql.jdbc.Driver.class;
                break;
            }
            case Oracle: {
                schema = String.format(schema, "oracle");
                driverClass = OracleDriver.class;
                break;
            }
            default: {
                schema = String.format(schema, "h2");
                driverClass = Driver.class;
            }
        }
        this.logger.info("\u5df2\u542f\u7528 jdbc [{}] session\u6301\u4e45\u5316", (Object)type.toString());
        return new EmbeddedDatabaseBuilder().setType(EmbeddedDatabaseType.H2).continueOnError(true).setDataSourceFactory(new DataSourceFactory(){
            private final SimpleDriverDataSource dataSource = new SimpleDriverDataSource();

            public ConnectionProperties getConnectionProperties() {
                return new ConnectionProperties(){

                    public void setDriverClass(Class<? extends java.sql.Driver> d) {
                        dataSource.setDriverClass(driverClass);
                    }

                    public void setUrl(String u) {
                        dataSource.setUrl(JdbcSessionPersistenceConfig.this.url);
                    }

                    public void setUsername(String u) {
                        dataSource.setUsername(JdbcSessionPersistenceConfig.this.username);
                    }

                    public void setPassword(String p) {
                        dataSource.setPassword(JdbcSessionPersistenceConfig.this.password);
                    }
                };
            }

            public DataSource getDataSource() {
                return this.dataSource;
            }
        }).addScript(schema).build();
    }

    @Bean
    public FindByIndexNameSessionRepository sessionRepository(@Qualifier(value="jdbcSessionDataSource") EmbeddedDatabase dataSource) {
        JdbcOperationsSessionRepository repository = new JdbcOperationsSessionRepository((JdbcOperations)new JdbcTemplate((DataSource)dataSource), (PlatformTransactionManager)new DataSourceTransactionManager((DataSource)dataSource));
        return repository;
    }

    @Bean
    public SessionRegistry sessionRegistry(@Autowired FindByIndexNameSessionRepository sessionRepository) {
        return new SpringSessionBackedSessionRegistry(sessionRepository);
    }
}

