/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.session.redis;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.support.spring.data.redis.GenericFastJsonRedisSerializer;
import com.centit.framework.session.CentitSessionRepo;
import com.centit.framework.session.redis.CentitSessionRedisRepo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.data.redis.RedisIndexedSessionRepository;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.security.SpringSessionBackedSessionRegistry;

@Configuration
@EnableRedisHttpSession(maxInactiveIntervalInSeconds=7200)
public class RedisSessionPersistenceConfig {
    @Value(value="${session.redis.host:}")
    private String host;
    @Value(value="${session.redis.port:6379}")
    private Integer port;
    @Value(value="${session.redis.password:}")
    private String password;
    @Value(value="${session.redis.database:0}")
    private Integer database;

    @Bean
    public RedisConnectionFactory redisConnectionFactory() {
        RedisStandaloneConfiguration configuration = new RedisStandaloneConfiguration(this.host, this.port.intValue());
        configuration.setDatabase(this.database.intValue());
        if (StringUtils.isNotBlank((CharSequence)this.password)) {
            configuration.setPassword(RedisPassword.of((String)this.password));
        }
        return new LettuceConnectionFactory(configuration);
    }

    @Bean
    public SessionRegistry sessionRegistry(@Autowired RedisIndexedSessionRepository sessionRepository) {
        return new SpringSessionBackedSessionRegistry((FindByIndexNameSessionRepository)sessionRepository);
    }

    @Bean
    public CentitSessionRepo centitSessionRepo(@Autowired RedisIndexedSessionRepository sessionRepository) {
        return new CentitSessionRedisRepo(sessionRepository);
    }

    @Bean
    public RedisTemplate<String, JSONObject> redisTemplate(@Autowired RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        GenericFastJsonRedisSerializer serializer = new GenericFastJsonRedisSerializer();
        template.setValueSerializer((RedisSerializer)serializer);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.afterPropertiesSet();
        return template;
    }
}

