/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.action;

import com.centit.core.action.BaseEntityExtremeAction;
import com.centit.core.utils.ExtremeTableUtils;
import com.centit.core.utils.PageDesc;
import com.centit.sys.po.FOptWithPower;
import com.centit.sys.po.FRoleinfo;
import com.centit.sys.po.FRolepower;
import com.centit.sys.po.FUnitinfo;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.FUserrole;
import com.centit.sys.po.FUserroleId;
import com.centit.sys.po.FUserunit;
import com.centit.sys.security.FUserDetail;
import com.centit.sys.service.CodeRepositoryManager;
import com.centit.sys.service.SysRoleManager;
import com.centit.sys.service.SysUnitManager;
import com.centit.sys.service.SysUserManager;
import com.centit.sys.util.ISysOptLog;
import com.centit.sys.util.SysOptLogFactoryImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.limit.Limit;

public class DeptManagerAction
extends BaseEntityExtremeAction<FUnitinfo> {
    private static final long serialVersionUID = 1L;
    private SysUnitManager sysUnitManager;
    private CodeRepositoryManager codeRepositoryManager;
    private SysRoleManager sysRoleManager;
    private SysUserManager sysUserManager;
    private List<FOptWithPower> fOptPowers;
    public static final Log log = LogFactory.getLog(DeptManagerAction.class);
    private static final ISysOptLog SYS_OPT_LOG = SysOptLogFactoryImpl.getSysOptLog("DEPTROLE");
    private List<FRoleinfo> unitRoles;
    private List<FUserrole> userroles;
    private Map<String, String> powerlist;
    private String[] optcodelist;
    private List<FRoleinfo> fRoleinfos;
    private FRoleinfo roleinfo;
    private String[] optlist;
    private List<FUserinfo> userList;
    private FUserinfo userinfo;
    private FUserrole userrole;
    private String roleprefix;

    public void setCodeRepositoryManager(CodeRepositoryManager codeRepositoryManager) {
        this.codeRepositoryManager = codeRepositoryManager;
    }

    public List<FOptWithPower> getFOptPowers() {
        if (this.fOptPowers == null) {
            this.fOptPowers = new ArrayList<FOptWithPower>();
        }
        return this.fOptPowers;
    }

    public void setFOptPowers(List<FOptWithPower> fOptPowers) {
        this.fOptPowers = fOptPowers;
    }

    public List<FUserrole> getUserroles() {
        if (this.userroles == null) {
            this.userroles = new ArrayList<FUserrole>();
        }
        return this.userroles;
    }

    public void setUserroles(List<FUserrole> userroles) {
        this.userroles = userroles;
    }

    public void setSysUnitManager(SysUnitManager sysUnitManager) {
        this.sysUnitManager = sysUnitManager;
        this.setBaseEntityManager(sysUnitManager);
    }

    public void setSysRoleManager(SysRoleManager sysRoleManager) {
        this.sysRoleManager = sysRoleManager;
    }

    public void setSysUserManager(SysUserManager sysUserManager) {
        this.sysUserManager = sysUserManager;
    }

    public List<FRoleinfo> getUnitRoles() {
        if (this.unitRoles == null) {
            this.unitRoles = new ArrayList<FRoleinfo>();
        }
        return this.unitRoles;
    }

    public List<FOptWithPower> getAllPowers() {
        return this.fOptPowers;
    }

    public void setAllPowers(List<FOptWithPower> ops) {
        this.fOptPowers = ops;
    }

    public String listunit() {
        try {
            FUserDetail user = (FUserDetail)this.getLoginUser();
            FUserunit dept = this.sysUserManager.getUserPrimaryUnit(user.getUsercode());
            if (dept != null) {
                String sParentUnit = dept.getUnitcode();
                this.objList = this.sysUnitManager.getAllSubUnits(sParentUnit);
            }
            return "listunit";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public Map<String, String> getPowerlist() {
        if (this.powerlist == null) {
            this.powerlist = new HashMap<String, String>();
        }
        return this.powerlist;
    }

    public void setPowerlist(Map<String, String> powerlist) {
        this.powerlist = powerlist;
    }

    public String editDeptPower() {
        try {
            FUserDetail user = (FUserDetail)this.getLoginUser();
            FUserunit dept = this.sysUserManager.getUserPrimaryUnit(user.getUsercode());
            String sParentUnit = dept.getUnitcode();
            FUnitinfo o = (FUnitinfo)this.sysUnitManager.getObjectById((Serializable)((Object)((FUnitinfo)this.object).getUnitcode()));
            if (o != null) {
                ((FUnitinfo)this.object).copyNotNullProperty(o);
            }
            List<FRolepower> list = this.sysRoleManager.getRolePowers(sParentUnit + "$" + ((FUnitinfo)this.object).getUnitcode());
            this.powerlist = new HashMap<String, String>();
            for (FRolepower p : list) {
                this.powerlist.put(p.getOptcode(), "1");
            }
            this.fOptPowers = this.sysRoleManager.getOptWithPowerUnderUnit(sParentUnit);
            return "editDeptPower";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String[] getOptcodelist() {
        return this.optcodelist;
    }

    public String saveDeptPower() {
        try {
            FUserDetail user = (FUserDetail)this.getLoginUser();
            FUserunit dept = this.sysUserManager.getUserPrimaryUnit(user.getUsercode());
            String sParentUnit = dept.getUnitcode();
            this.object = this.sysUnitManager.getObjectById((Serializable)((Object)((FUnitinfo)this.object).getUnitcode()));
            if (this.object == null || ((FUnitinfo)this.object).getUnitcode() == null) {
                return "editDeptPower";
            }
            try {
                this.sysRoleManager.saveRolePowers(sParentUnit + "$" + ((FUnitinfo)this.object).getUnitcode(), this.optcodelist);
                this.savedMessage();
                SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), "DEPTPOW", String.valueOf(((FUnitinfo)this.object).getUnitcode()), "saveDeptPower", ((FUnitinfo)this.object).display(), null);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.saveError(e.getMessage());
                return "editDeptPower";
            }
            return "saveDeptPower";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }

    public void setOptcodelist(String[] optcodelist) {
        this.optcodelist = optcodelist;
    }

    public List<FRoleinfo> getFRoleinfos() {
        return this.fRoleinfos;
    }

    public void setFRoleinfos(List<FRoleinfo> fRoleinfos) {
        this.fRoleinfos = fRoleinfos;
    }

    public String listrole() {
        try {
            Limit limit = ExtremeTableUtils.getLimit((HttpServletRequest)this.request);
            PageDesc pageDesc = ExtremeTableUtils.makePageDesc((Limit)limit);
            this.request.getParameterMap();
            Map filterMap = this.convertSearchColumn(this.request.getParameterMap());
            FUserDetail user = (FUserDetail)this.getLoginUser();
            FUserunit dept = this.sysUserManager.getUserPrimaryUnit(user.getUsercode());
            if (dept != null) {
                String sParentUnit = dept.getUnitcode();
                filterMap.put("ROLECODE", sParentUnit + "-%");
                this.fRoleinfos = this.sysRoleManager.listObjects(filterMap, pageDesc);
                this.totalRows = this.fRoleinfos.size();
            }
            return "listrole";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public FRoleinfo getRoleinfo() {
        return this.roleinfo;
    }

    public void setRoleinfo(FRoleinfo roleinfo) {
        this.roleinfo = roleinfo;
    }

    public String editDeptRole() {
        try {
            FUserDetail user = (FUserDetail)this.getLoginUser();
            FUserunit dept = this.sysUserManager.getUserPrimaryUnit(user.getUsercode());
            String sParentUnit = dept.getUnitcode();
            if (this.roleinfo != null) {
                FRoleinfo dbobject = (FRoleinfo)this.sysRoleManager.getObjectById((Serializable)((Object)this.roleinfo.getRolecode()));
                if (dbobject != null) {
                    this.roleinfo = dbobject;
                }
                List<FRolepower> list = this.sysRoleManager.getRolePowers(this.roleinfo.getRolecode());
                this.powerlist = new HashMap<String, String>();
                for (FRolepower p : list) {
                    this.powerlist.put(p.getOptcode(), "1");
                }
            }
            this.fOptPowers = this.sysRoleManager.getOptWithPowerUnderUnit(sParentUnit);
            return "editDeptRole";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String builtDeptRole() {
        try {
            FUserDetail user = (FUserDetail)this.getLoginUser();
            FUserunit dept = this.sysUserManager.getUserPrimaryUnit(user.getUsercode());
            if (dept != null) {
                String sParentUnit = dept.getUnitcode();
                this.roleinfo = new FRoleinfo();
                this.powerlist = new HashMap<String, String>();
                this.fOptPowers = this.sysRoleManager.getOptWithPowerUnderUnit(sParentUnit);
            }
            return "editDeptRole";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String[] getOptlist() {
        return this.optlist;
    }

    public void setOptlist(String[] optlist) {
        this.optlist = optlist;
    }

    public String saveDeptRole() {
        try {
            FUserDetail user = (FUserDetail)this.getLoginUser();
            FUserunit dept = this.sysUserManager.getUserPrimaryUnit(user.getUsercode());
            if (dept == null) {
                this.saveError("dept is null!");
                return "error";
            }
            String sParentUnit = dept.getUnitcode();
            if (this.roleinfo.getRolecode() == null) {
                return "savedrole";
            }
            try {
                FRoleinfo dbRoleinfo;
                if (!this.roleinfo.getRolecode().startsWith(sParentUnit + "-")) {
                    this.roleinfo.setRolecode(sParentUnit + "-" + this.roleinfo.getRolecode());
                }
                if ((dbRoleinfo = (FRoleinfo)this.sysRoleManager.getObjectById((Serializable)((Object)this.roleinfo.getRolecode()))) != null) {
                    dbRoleinfo.copyNotNullProperty(this.roleinfo);
                    this.sysRoleManager.saveObject(dbRoleinfo);
                    this.sysRoleManager.saveRolePowers(dbRoleinfo.getRolecode(), this.optlist);
                } else {
                    if (this.roleinfo.getIsvalid() == null) {
                        this.roleinfo.setIsvalid("T");
                    }
                    this.sysRoleManager.saveObject(this.roleinfo);
                    this.sysRoleManager.saveRolePowers(this.roleinfo.getRolecode(), this.optlist);
                }
                this.codeRepositoryManager.refresh("rolecode");
                this.savedMessage();
                SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), this.roleinfo.getRolecode(), this.roleinfo.display(), dbRoleinfo == null ? "" : dbRoleinfo.display());
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.saveError(e.getMessage());
                return "error";
            }
            return "saveDeptRole";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }

    public String deleteDeptRole() {
        try {
            try {
                FRoleinfo dbObject = (FRoleinfo)this.sysRoleManager.getObjectById((Serializable)((Object)this.roleinfo.getRolecode()));
                this.sysRoleManager.disableObject(dbObject);
                this.deletedMessage();
                this.codeRepositoryManager.refresh("rolecode");
                SYS_OPT_LOG.log(((FUserinfo)this.getLoginUser()).getUsercode(), dbObject.getRolecode(), dbObject.display());
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return "saveDeptRole";
            }
            return "saveDeptRole";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String renewDeptRole() {
        try {
            FRoleinfo dbObject = (FRoleinfo)this.sysRoleManager.getObjectById((Serializable)((Object)this.roleinfo.getRolecode()));
            try {
                this.sysRoleManager.renewObject(dbObject);
                this.codeRepositoryManager.refresh("rolecode");
                this.renewedMessage();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return "saveDeptRole";
            }
            return "saveDeptRole";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public List<FUserinfo> getUserList() {
        return this.userList;
    }

    public void setUserList(List<FUserinfo> userList) {
        this.userList = userList;
    }

    public String listuser() {
        try {
            Limit limit = ExtremeTableUtils.getLimit((HttpServletRequest)this.request);
            PageDesc pageDesc = ExtremeTableUtils.makePageDesc((Limit)limit);
            Map paramMap = this.request.getParameterMap();
            this.resetPageParam(paramMap);
            if (paramMap.get("unitcode") != null) {
                FUserDetail user = (FUserDetail)this.getLoginUser();
                FUserunit dept = this.sysUserManager.getUserPrimaryUnit(user.getUsercode());
                if (dept != null) {
                    String sParentUnit = dept.getUnitcode();
                    this.userList = this.sysUnitManager.getRelationUsers(sParentUnit);
                }
            } else {
                Map filterMap = this.convertSearchColumn(paramMap);
                this.userList = this.sysUserManager.listObjects(filterMap, pageDesc);
            }
            this.userList = this.userList == null ? new ArrayList() : this.userList;
            this.totalRows = this.userList.size();
            return "listuser";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public FUserinfo getUserinfo() {
        return this.userinfo;
    }

    public void setUserinfo(FUserinfo userinfo) {
        this.userinfo = userinfo;
    }

    public String viewUserRole() {
        try {
            FUserinfo dbobject = (FUserinfo)this.sysUserManager.getObjectById((Serializable)((Object)this.userinfo.getUsercode()));
            if (dbobject == null) {
                this.saveError("entity.missing");
                return "list";
            }
            this.userinfo = dbobject;
            FUserDetail user = (FUserDetail)this.getLoginUser();
            FUserunit dept = this.sysUserManager.getUserPrimaryUnit(user.getUsercode());
            if (dept != null) {
                String sParentUnit = dept.getUnitcode();
                this.userroles = this.sysUserManager.getAllUserRoles(this.userinfo.getUsercode(), sParentUnit + "-");
                List<FUserrole> list = this.sysUserManager.getAllUserRoles(this.userinfo.getUsercode(), "P-");
                if (list != null) {
                    this.userroles.addAll(list);
                }
                this.totalRows = this.userroles.size();
            }
            return "viewUserRole";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public FUserrole getUserrole() {
        return this.userrole;
    }

    public void setUserrole(FUserrole userrole) {
        this.userrole = userrole;
    }

    public String getRoleprefix() {
        return this.roleprefix;
    }

    public void setRoleprefix(String roleprefix) {
        this.roleprefix = roleprefix;
    }

    public String bulitUserRole() {
        try {
            FUserroleId id = new FUserroleId();
            id.setUsercode(this.userrole.getUsercode());
            this.userrole = new FUserrole();
            id.setObtaindateToToday();
            this.userrole.setId(id);
            FUserDetail user = (FUserDetail)this.getLoginUser();
            FUserunit dept = this.sysUserManager.getUserPrimaryUnit(user.getUsercode());
            if (dept != null) {
                String sParentUnit = dept.getUnitcode();
                this.roleprefix = sParentUnit + "-";
            }
            return "editUserRole";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String editUserRole() {
        try {
            FUserroleId id = new FUserroleId();
            id.setUsercode(this.userrole.getUsercode());
            id.setRolecode(this.userrole.getRolecode());
            this.userrole = this.sysUserManager.getValidUserrole(id.getUsercode(), id.getRolecode());
            FUserDetail user = (FUserDetail)this.getLoginUser();
            FUserunit dept = this.sysUserManager.getUserPrimaryUnit(user.getUsercode());
            if (dept != null) {
                String sParentUnit = dept.getUnitcode();
                this.roleprefix = sParentUnit + "-";
            }
            return "editUserRole";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public String saveUserRole() {
        try {
            FUserrole desobj = this.sysUserManager.getValidUserrole(this.userrole.getUsercode(), this.userrole.getRolecode());
            if (desobj != null) {
                desobj.copyNotNullProperty(this.userrole);
                this.userrole = desobj;
            }
            try {
                log.debug((Object)this.userrole);
                this.sysUserManager.saveUserrole(this.userrole);
                this.savedMessage();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return "error";
            }
            return "saveUserRole";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }

    public String deleteUserRole() {
        try {
            this.userrole = this.sysUserManager.getFUserroleByID(this.userrole.getId());
            this.sysUserManager.deleteUserrole(this.userrole);
            this.deletedMessage();
            return "saveUserRole";
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return "error";
        }
    }
}

