/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.dao;

import com.centit.core.dao.BaseDaoImpl;
import com.centit.sys.po.FUnitinfo;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.FUserunit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class UnitInfoDao
extends BaseDaoImpl<FUnitinfo> {
    public static final Log log = LogFactory.getLog(UnitInfoDao.class);
    private static final long serialVersionUID = 1L;

    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("UNITCODE", "EQUAL");
            this.filterField.put("UNITNAME", "LIKE");
            this.filterField.put("ISVALID", "EQUAL");
            this.filterField.put("PARENTUNIT", "EQUAL");
            this.filterField.put("ORDER BY", " parentunit,unitorder asc");
        }
        return this.filterField;
    }

    public List<FUnitinfo> getSubUnits(String superUnitID) {
        String dn = this.getDialectName();
        String sSqlsen = "Oracle10gDialect".endsWith(dn) || "OracleDialect".endsWith(dn) ? "select UNITCODE,PARENTUNIT,UNITTYPE,ISVALID,UNITNAME,UNITDESC,ADDRBOOKID  from f_Unitinfo where ISVALID='T' start with (UNITCODE = '" + superUnitID + "') " + "connect by  prior UNITCODE = PARENTUNIT " + "order by LEVEL,unitorder" : "WITH RPL (LEVEL,UNITCODE,PARENTUNIT,UNITTYPE,ISVALID,UNITNAME,UNITDESC,ADDRBOOKID) AS  (SELECT 1 as LEVEL,UNITCODE,PARENTUNIT,UNITTYPE,ISVALID,UNITNAME,UNITDESC,ADDRBOOKID FROM f_Unitinfo WHERE UNITCODE='" + superUnitID + "' " + "UNION ALL " + "SELECT PARENT.LEVEL+1 as LEVEL, CHILD.UNITCODE,CHILD.PARENTUNIT,CHILD.UNITTYPE, " + "CHILD.ISVALID,CHILD.UNITNAME,CHILD.UNITDESC,CHILD.ADDRBOOKID " + "FROM RPL PARENT, f_Unitinfo CHILD " + "WHERE PARENT.UNITCODE = CHILD.PARENTUNIT " + ") " + "SELECT UNITCODE,PARENTUNIT,UNITTYPE,ISVALID,UNITNAME,UNITDESC,ADDRBOOKID " + "FROM RPL WHERE ISVALID='T' ORDER BY LEVEL,unitorder";
        List l = this.findObjectsBySql(sSqlsen, FUnitinfo.class);
        return l;
    }

    public List<FUnitinfo> getAllSubUnits(String superUnitID) {
        String dn = this.getDialectName();
        String sSqlsen = "Oracle10gDialect".endsWith(dn) || "OracleDialect".endsWith(dn) ? "select * from f_Unitinfo connect by  prior UNITCODE = PARENTUNIT start with (UNITCODE = '" + superUnitID + "') " + "order by LEVEL,unitorder" : "WITH RPL (LEVEL,UNITCODE,PARENTUNIT,UNITTYPE,ISVALID,UNITNAME,UNITDESC,ADDRBOOKID) AS  (SELECT 1 as LEVEL,UNITCODE,PARENTUNIT,UNITTYPE,ISVALID,UNITNAME,UNITDESC,ADDRBOOKID FROM f_Unitinfo WHERE UNITCODE='" + superUnitID + "' " + "UNION ALL " + "SELECT PARENT.LEVEL+1 as LEVEL, CHILD.UNITCODE,CHILD.PARENTUNIT,CHILD.UNITTYPE, " + "CHILD.ISVALID,CHILD.UNITNAME,CHILD.UNITDESC,CHILD.ADDRBOOKID " + "FROM RPL PARENT, f_Unitinfo CHILD " + "WHERE PARENT.UNITCODE = CHILD.PARENTUNIT " + ") " + "SELECT UNITCODE,PARENTUNIT,UNITTYPE,ISVALID,UNITNAME,UNITDESC,ADDRBOOKID " + "FROM RPL ORDER BY LEVEL,unitorder";
        log.debug((Object)sSqlsen);
        List l = this.findObjectsBySql(sSqlsen, FUnitinfo.class);
        return l;
    }

    public String getNextKey() {
        return this.getNextKeyBySequence("S_UNITCODE", 6);
    }

    public List<FUserunit> getSysUnitsByUserId(String userId) {
        List ls = this.getHibernateTemplate().find("FROM FUserunit where id.usercode=?", (Object)userId);
        return ls;
    }

    public FUserunit getUserPrimaryUnit(String userId) {
        List<FUserunit> ul = this.getSysUnitsByUserId(userId);
        FUserunit uu = null;
        for (FUserunit u : ul) {
            if ("T".equals(u.getIsprimary())) {
                uu = u;
                break;
            }
            if (uu != null) continue;
            uu = u;
        }
        return uu;
    }

    public List<FUserunit> getSysUsersByUnitId(String unitCode) {
        List ls = this.getHibernateTemplate().find("FROM FUserunit where id.unitcode=?", (Object)unitCode);
        return ls;
    }

    public String getUnitCode(String depno) {
        List ls = this.getHibernateTemplate().find("FROM FUnitinfo where 1=1 and depno=?", (Object)depno);
        if (ls != null) {
            return ((FUnitinfo)ls.get(0)).getUnitcode();
        }
        return null;
    }

    public List<FUserinfo> getUnitUsers(String unitCode) {
        String sSqlsen = "select a.* from f_Userinfo a join f_userunit b on(a.usercode=b.usercode) where b.unitcode ='" + unitCode + "'";
        return this.findObjectsBySql(sSqlsen, FUserinfo.class);
    }

    public List<FUserinfo> getRelationUsers(String unitCode) {
        String sSqlsen = "select * FROM F_Userinfo ui where ui.usercode in (select usercode from f_userunit where unitcode='" + unitCode + "') or " + "ui.usercode in (select usercode from f_userrole where rolecode like '" + unitCode + "-%')";
        return this.findObjectsBySql(sSqlsen, FUserinfo.class);
    }

    public String getUnitNameOfCode(String unitcode) {
        SQLQuery query = super.getSession().createSQLQuery("select unitname from f_unitinfo where unitcode='" + unitcode + "'");
        List username = query.list();
        Object o = username.get(0);
        return o.toString();
    }

    public List<FUnitinfo> listUnitinfoByUnitcodes(List<String> unitcodes) {
        return super.getHibernateTemplate().findByCriteria(DetachedCriteria.forClass(FUnitinfo.class).add(Restrictions.in((String)"unitcode", unitcodes)));
    }

    public void batchSave(List<FUnitinfo> unitinfos) {
        for (int i = 0; i < unitinfos.size(); ++i) {
            this.saveObject(unitinfos.get(i));
        }
    }

    public void batchMerge(List<FUnitinfo> unitinfos) {
        for (int i = 0; i < unitinfos.size(); ++i) {
            this.getHibernateTemplate().merge((Object)unitinfos.get(i));
            if (19 != i % 20) continue;
            super.getHibernateTemplate().flush();
            super.getHibernateTemplate().clear();
        }
    }

    public FUnitinfo getUnitByName(String name) {
        String hql;
        List list;
        if (StringUtils.isNotBlank((String)name) && !(list = this.listObjects(hql = "from FUnitinfo where unitname like '%" + name + "%' or unitshortname like '%" + name + "%' order by unitorder asc")).isEmpty()) {
            return (FUnitinfo)list.get(0);
        }
        return null;
    }
}

