/*
 * Decompiled with CFR 0.152.
 */
package com.centit.sys.dao;

import com.centit.core.dao.BaseDaoImpl;
import com.centit.core.dao.HQLUtils;
import com.centit.core.dao.HqlAndParams;
import com.centit.core.dao.SQLQueryCallBack;
import com.centit.core.service.ObjectException;
import com.centit.core.utils.PageDesc;
import com.centit.sys.po.FUserinfo;
import com.centit.sys.po.FUserunit;
import com.centit.sys.security.FUserDetail;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;

public class UserInfoDao
extends BaseDaoImpl<FUserinfo> {
    private static final long serialVersionUID = 1L;

    public boolean checkIfUserExists(FUserinfo user) {
        long size;
        String hql;
        long hasExist = 0L;
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)user.getUsercode())) {
            hql = "SELECT COUNT(*) FROM FUserinfo WHERE usercode = " + HQLUtils.buildHqlStringForSQL((String)user.getUsercode());
            hasExist = this.getSingleIntByHql(hql);
        }
        hql = "SELECT COUNT(*) FROM FUserinfo WHERE loginname = " + HQLUtils.buildHqlStringForSQL((String)user.getLoginname());
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)user.getUsercode())) {
            hql = hql + " AND usercode <> " + HQLUtils.buildHqlStringForSQL((String)user.getUsercode());
        }
        if ((size = this.getSingleIntByHql(hql)) >= 1L) {
            throw new ObjectException("\u767b\u5f55\u540d\uff1a" + user.getLoginname() + " \u5df2\u5b58\u5728!!!");
        }
        return hasExist > 0L;
    }

    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("USERCODE", "EQUAL");
            this.filterField.put("USERNAME", "LIKE");
            this.filterField.put("ISVALID", "EQUAL");
            this.filterField.put("LOGINNAME", "LIKE");
            this.filterField.put("USERSTATE", "EQUAL");
            this.filterField.put("USERORDER", "EQUAL");
            this.filterField.put("byUnderUnit", "usercode in ( select  usercode from f_userunit where unitcode = ? ) ");
            this.filterField.put("queryByUnit", "usercode in ( select  id.usercode from FUserunit where unitcode in (select unitcode from VHiunitinfo where topunitcode = ?) ) ");
            this.filterField.put("queryByGW", "usercode in ( select  id.usercode from FUserunit where id.userstation = ? )");
            this.filterField.put("queryByXZ", "usercode in ( select  id.usercode from FUserunit where id.userrank = ? )");
            this.filterField.put("queryUnderUnit", " usercode in ( select usercode from f_userunit  where unitcode in ( select unitcode from f_unitinfo connect by prior unitcode = parentunit start with unitcode= ? ) ) ");
            this.filterField.put("queryByRole", "usercode in (select r.id.usercode from FUserrole r, FRoleinfo i where r.id.rolecode = ? and (r.secededate is null or r.secededate > sysdate) and r.id.rolecode = i.rolecode and i.isvalid = 'T')");
            this.filterField.put("ORDER BY", "userorder asc");
        }
        return this.filterField;
    }

    public String getNextKey() {
        return this.getNextKeyByHqlStrOfMax("usercode", "FUserinfo WHERE usercode !='U0000000'", 7);
    }

    public void saveObject(FUserinfo o) {
        if (!StringUtils.hasText((String)o.getUsercode())) {
            o.setUsercode(this.getNextKey());
        }
        if (!StringUtils.hasText((String)o.getUserpin())) {
            o.setUserpin(new Md5PasswordEncoder().encodePassword("000000", (Object)o.getUsercode()));
        }
        super.saveObject((Object)o);
    }

    public UserDetails loadUserByLoginname(String loginname) throws UsernameNotFoundException {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)loginname)) {
            throw new UsernameNotFoundException("loginname is null...");
        }
        List l = null;
        try {
            l = this.getHibernateTemplate().find("FROM FUserinfo WHERE loginname = ? or usercode = ? or regemail = ?", (Object[])new String[]{loginname, loginname, loginname});
        }
        catch (Exception e) {
            throw new UsernameNotFoundException("user not found...");
        }
        if (l != null && l.size() != 0) {
            return new FUserDetail((FUserinfo)l.get(0));
        }
        this.log.error((Object)("user '" + loginname + "' not found..."));
        throw new UsernameNotFoundException("user '" + loginname + "' not found...");
    }

    public void deleteOtherPrimaryUnit(FUserunit object) {
        this.doExecuteHql("update FUserunit set isPrimary='F' where id.usercode = ? and (id.unitcode <> ? or id.userstation <> ? or id.userrank <> ?) and isPrimary='T'", new Object[]{object.getUsercode(), object.getUnitcode(), object.getUserstation(), object.getUserrank()});
    }

    public List<FUserinfo> listUnderUnit(Map<String, Object> filterMap) {
        String shql = "from f_userinfo where 1=1 ";
        HqlAndParams hql = this.builderHqlAndParams(shql, filterMap);
        String hql1 = "select *  " + hql.getHql();
        System.out.println(1);
        List l = null;
        try {
            l = this.getHibernateTemplate().executeFind((HibernateCallback)new SQLQueryCallBack(hql1, hql.getParams(), FUserinfo.class));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        return l;
    }

    public List<FUserinfo> listUnderUnit(Map<String, Object> filterMap, PageDesc pageDesc) {
        String shql = "from f_userinfo where 1=1 ";
        HqlAndParams hql = this.builderHqlAndParams(shql, filterMap);
        String hql1 = "select *  " + hql.getHql();
        String hql2 = "select count(*)  " + hql.getHql();
        System.out.println(2);
        int startPos = 0;
        startPos = pageDesc.getRowStart();
        int maxSize = pageDesc.getPageSize();
        List l = null;
        try {
            l = this.getHibernateTemplate().executeFind((HibernateCallback)new SQLQueryCallBack(hql1, hql.getParams(), startPos, maxSize, FUserinfo.class));
            pageDesc.setTotalRows(Integer.valueOf(this.getHibernateTemplate().executeFind((HibernateCallback)new SQLQueryCallBack(hql2, hql.getParams())).get(0).toString()).intValue());
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        return l;
    }

    public List<FUserinfo> getUserUnderUnit(String unitcode) {
        String shql = "select * from f_userinfo where usercode in ( select usercode from f_userunit  where unitcode in ( select unitcode from f_unitinfo connect by prior unitcode = parentunit start with unitcode = " + unitcode + " ) )";
        System.out.println(3);
        List l = null;
        try {
            l = this.getHibernateTemplate().executeFind((HibernateCallback)new SQLQueryCallBack(shql, FUserinfo.class));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        return l;
    }

    public List<FUserinfo> listUserinfoByUsercodes(List<String> usercodes) {
        return super.getHibernateTemplate().findByCriteria(DetachedCriteria.forClass(FUserinfo.class).add((Criterion)Restrictions.or((Criterion)Restrictions.in((String)"usercode", usercodes), (Criterion)Restrictions.in((String)"loginname", usercodes))));
    }

    public List<FUserinfo> listUserinfoByLoginname(List<String> loginnames) {
        return super.getHibernateTemplate().findByCriteria(DetachedCriteria.forClass(FUserinfo.class).add(Restrictions.in((String)"loginname", loginnames)));
    }

    public void batchSave(List<FUserinfo> userinfos) {
        for (int i = 0; i < userinfos.size(); ++i) {
            this.saveObject(userinfos.get(i));
            if (19 != i % 20) continue;
            super.getHibernateTemplate().flush();
            super.getHibernateTemplate().clear();
        }
    }

    public void batchMerge(List<FUserinfo> userinfos) {
        for (int i = 0; i < userinfos.size(); ++i) {
            this.getHibernateTemplate().merge((Object)userinfos.get(i));
            if (19 != i % 20) continue;
            super.getHibernateTemplate().flush();
            super.getHibernateTemplate().clear();
        }
    }
}

